/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.cmd;

import java.net.InetAddress;
import net.wimpi.modbus.Modbus;
import net.wimpi.modbus.io.ModbusTCPTransaction;
import net.wimpi.modbus.msg.WriteSingleRegisterRequest;
import net.wimpi.modbus.net.TCPMasterConnection;
import net.wimpi.modbus.procimg.SimpleRegister;

public class AOTest {
    public static void main(String[] args) {
        InetAddress addr = null;
        TCPMasterConnection con = null;
        WriteSingleRegisterRequest req = null;
        ModbusTCPTransaction trans = null;
        int ref = 0;
        int count = 0;
        int repeat = 1;
        int port = 502;
        try {
            if (args.length < 3) {
                AOTest.printUsage();
                System.exit(1);
            } else {
                try {
                    String astr = args[0];
                    int idx = astr.indexOf(58);
                    if (idx > 0) {
                        port = Integer.parseInt(astr.substring(idx + 1));
                        astr = astr.substring(0, idx);
                    }
                    addr = InetAddress.getByName(astr);
                    ref = Integer.parseInt(args[1]);
                    count = Integer.parseInt(args[2]);
                    if (args.length == 4) {
                        repeat = Integer.parseInt(args[3]);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    AOTest.printUsage();
                    System.exit(1);
                }
            }
            con = new TCPMasterConnection(addr);
            con.setPort(port);
            con.connect();
            if (Modbus.debug) {
                System.out.println("Connected to " + addr.toString() + ":" + con.getPort());
            }
            req = new WriteSingleRegisterRequest(ref, new SimpleRegister(count));
            req.setUnitID(0);
            if (Modbus.debug) {
                System.out.println("Request: " + req.getHexMessage());
            }
            trans = new ModbusTCPTransaction(con);
            trans.setRequest(req);
            int k = 0;
            do {
                trans.execute();
                if (!Modbus.debug) continue;
                System.out.println("Response: " + trans.getResponse().getHexMessage());
            } while (++k < repeat);
            con.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void printUsage() {
        System.out.println("java net.wimpi.modbus.cmd.AOTest <address{:<port>} [String]> <register [int]> <value [int]> {<repeat [int]>}");
    }
}

