/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.executors;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.common.util.concurrent.FutureUtils;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.searchrelevance.dao.ExperimentDao;
import org.opensearch.searchrelevance.dao.QuerySetDao;
import org.opensearch.searchrelevance.dao.ScheduledExperimentHistoryDao;
import org.opensearch.searchrelevance.dao.SearchConfigurationDao;
import org.opensearch.searchrelevance.exception.SearchRelevanceException;
import org.opensearch.searchrelevance.experiment.HybridOptimizerExperimentProcessor;
import org.opensearch.searchrelevance.experiment.PointwiseExperimentProcessor;
import org.opensearch.searchrelevance.metrics.MetricsHelper;
import org.opensearch.searchrelevance.model.AsyncStatus;
import org.opensearch.searchrelevance.model.Experiment;
import org.opensearch.searchrelevance.model.ExperimentType;
import org.opensearch.searchrelevance.model.QuerySet;
import org.opensearch.searchrelevance.model.QuerySetEntry;
import org.opensearch.searchrelevance.model.ScheduledExperimentResult;
import org.opensearch.searchrelevance.model.SearchConfiguration;
import org.opensearch.searchrelevance.model.SearchConfigurationDetails;
import org.opensearch.searchrelevance.scheduler.ExperimentCancellationToken;
import org.opensearch.searchrelevance.settings.SearchRelevanceSettingsAccessor;
import org.opensearch.searchrelevance.transport.experiment.PutExperimentRequest;
import org.opensearch.searchrelevance.utils.TimeUtils;
import org.opensearch.threadpool.ThreadPool;

public class ExperimentRunningManager {
    @Generated
    private static final Logger log = LogManager.getLogger(ExperimentRunningManager.class);
    private ExperimentDao experimentDao;
    private QuerySetDao querySetDao;
    private SearchConfigurationDao searchConfigurationDao;
    private ScheduledExperimentHistoryDao scheduledExperimentHistoryDao;
    private MetricsHelper metricsHelper;
    private HybridOptimizerExperimentProcessor hybridOptimizerExperimentProcessor;
    private PointwiseExperimentProcessor pointwiseExperimentProcessor;
    private ThreadPool threadPool;
    private SearchRelevanceSettingsAccessor settingsAccessor;
    private static final double MEMORY_WARNING_THRESHOLD = 0.75;
    private static final double MEMORY_CRITICAL_THRESHOLD = 0.9;
    private static final int RESULTS_SIZE_WARNING = 50000;
    private final Map<String, List<Future<?>>> runningFutures = new ConcurrentHashMap();

    public void startExperimentRun(String experimentId, PutExperimentRequest request, ExperimentCancellationToken cancellationToken, CountDownLatch actuallyFinished) {
        ArrayList futures = new ArrayList();
        if (request.getScheduledExperimentResultId() != null) {
            if (this.runningFutures.containsKey(request.getScheduledExperimentResultId())) {
                this.handleAsyncFailure(experimentId, request, "There is a running scheduled run with the same scheduled experiment id", new Exception("Cannot run experiment!"), actuallyFinished);
                log.error("Cannot run experiment as there is a running scheduled run with the same experiment id, {}", (Object)experimentId);
                return;
            }
            this.runningFutures.compute(request.getScheduledExperimentResultId(), (key, existingList) -> {
                List list = existingList != null ? existingList : new CopyOnWriteArrayList();
                return list;
            });
            cancellationToken.onCancel(() -> {
                this.runningFutures.get(request.getScheduledExperimentResultId()).forEach(f -> FutureUtils.cancel((Future)f));
                this.runningFutures.remove(request.getScheduledExperimentResultId());
            });
        }
        this.querySetDao.getQuerySet(request.getQuerySetId(), (ActionListener<SearchResponse>)ActionListener.wrap(querySetResponse -> {
            try {
                QuerySet querySet = this.convertToQuerySet((SearchResponse)querySetResponse);
                List<String> queryTextWithReferences = querySet.querySetQueries().stream().map(e -> e.queryText()).collect(Collectors.toList());
                if (queryTextWithReferences.isEmpty()) {
                    log.info("Experiment {} completed with 0 query texts", (Object)experimentId);
                    this.updateFinalExperiment(experimentId, request, new ArrayList<Map<String, Object>>(), request.getJudgmentList(), actuallyFinished);
                    return;
                }
                this.fetchSearchConfigurationsAsync(experimentId, request, queryTextWithReferences, cancellationToken, actuallyFinished);
            }
            catch (Exception e2) {
                this.handleAsyncFailure(experimentId, request, "Failed to process QuerySet", e2, actuallyFinished);
            }
        }, e -> this.handleAsyncFailure(experimentId, request, "Failed to fetch QuerySet", (Exception)e, actuallyFinished)));
    }

    @VisibleForTesting
    void fetchSearchConfigurationsAsync(String experimentId, PutExperimentRequest request, List<String> queryTextWithReferences, ExperimentCancellationToken cancellationToken, CountDownLatch actuallyFinished) {
        HashMap<String, SearchConfigurationDetails> searchConfigurations = new HashMap<String, SearchConfigurationDetails>();
        AtomicBoolean hasFailure = new AtomicBoolean(false);
        ArrayList<CompletableFuture<Map.Entry<String, Object>>> configFutures = new ArrayList<CompletableFuture<Map.Entry<String, Object>>>();
        for (String string : request.getSearchConfigurationList()) {
            CompletableFuture<Map.Entry<String, Object>> singleSearchConfigurationFuture = this.fetchSingleSearchConfigurationAsync(experimentId, request, queryTextWithReferences, hasFailure, string, cancellationToken, actuallyFinished);
            if (request.getScheduledExperimentResultId() != null && !this.checkIfCancelled(cancellationToken)) {
                try {
                    this.runningFutures.get(request.getScheduledExperimentResultId()).add(singleSearchConfigurationFuture);
                }
                catch (Exception e) {
                    log.info("Fetching search configuration, {} for scheduled experiment with underlying experiment {} cannot be completed", (Object)string, (Object)experimentId);
                }
            }
            configFutures.add(singleSearchConfigurationFuture);
        }
        for (CompletableFuture completableFuture : configFutures) {
            Map.Entry configEntry;
            try {
                configEntry = (Map.Entry)completableFuture.get();
            }
            catch (InterruptedException e) {
                this.handleFailure(e, hasFailure, experimentId, request, actuallyFinished);
                return;
            }
            catch (ExecutionException e) {
                this.handleFailure(e, hasFailure, experimentId, request, actuallyFinished);
                return;
            }
            searchConfigurations.put((String)configEntry.getKey(), (SearchConfigurationDetails)configEntry.getValue());
        }
        if (queryTextWithReferences == null || searchConfigurations == null) {
            throw new IllegalStateException("Missing required data for metrics calculation");
        }
        List<Map<String, Object>> finalResults = Collections.synchronizedList(new ArrayList());
        AtomicInteger atomicInteger = new AtomicInteger(queryTextWithReferences.size());
        this.executeExperimentEvaluation(experimentId, request, searchConfigurations, queryTextWithReferences, finalResults, atomicInteger, hasFailure, request.getJudgmentList(), cancellationToken, actuallyFinished);
    }

    private boolean checkIfCancelled(ExperimentCancellationToken cancellationToken) {
        return cancellationToken != null && cancellationToken.isCancelled();
    }

    private CompletableFuture<Map.Entry<String, Object>> fetchSingleSearchConfigurationAsync(String experimentId, PutExperimentRequest request, List<String> queryTextWithReferences, AtomicBoolean hasFailure, String configId, ExperimentCancellationToken cancellationToken, CountDownLatch actuallyFinished) {
        CompletableFuture<Map.Entry<String, Object>> future = new CompletableFuture<Map.Entry<String, Object>>();
        this.searchConfigurationDao.getSearchConfiguration(configId, (ActionListener<SearchResponse>)ActionListener.wrap(searchConfigResponse -> {
            block3: {
                try {
                    if (hasFailure.get() || this.checkIfCancelled(cancellationToken)) {
                        log.info("Experiment {} has been timed out while search configuration fetching id {}", (Object)experimentId, (Object)configId);
                        future.completeExceptionally(new Exception("Experiment Cancelled"));
                        return;
                    }
                    SearchConfiguration config = this.convertToSearchConfiguration((SearchResponse)searchConfigResponse);
                    future.complete(Map.entry(config.id(), SearchConfigurationDetails.builder().index(config.index()).query(config.query()).pipeline(config.searchPipeline()).build()));
                }
                catch (Exception e) {
                    future.completeExceptionally(e);
                    if (!hasFailure.compareAndSet(false, true)) break block3;
                    this.handleAsyncFailure(experimentId, request, "Failed to process SearchConfiguration", e, actuallyFinished);
                }
            }
        }, e -> {
            future.completeExceptionally((Throwable)e);
            if (hasFailure.compareAndSet(false, true)) {
                this.handleAsyncFailure(experimentId, request, "Failed to fetch SearchConfiguration: " + configId, (Exception)e, actuallyFinished);
            }
        }));
        return future;
    }

    private QuerySet convertToQuerySet(SearchResponse response) {
        if (response.getHits().getTotalHits().value() == 0L) {
            throw new SearchRelevanceException("QuerySet not found", RestStatus.NOT_FOUND);
        }
        Map sourceMap = response.getHits().getHits()[0].getSourceAsMap();
        ArrayList<QuerySetEntry> querySetEntries = new ArrayList();
        Object querySetQueriesObj = sourceMap.get("querySetQueries");
        if (querySetQueriesObj instanceof List) {
            List querySetQueriesList = (List)querySetQueriesObj;
            querySetEntries = querySetQueriesList.stream().map(entryMap -> QuerySetEntry.Builder.builder().queryText((String)entryMap.get("queryText")).build()).collect(Collectors.toList());
        }
        return QuerySet.Builder.builder().id((String)sourceMap.get("id")).name((String)sourceMap.get("name")).description((String)sourceMap.get("description")).timestamp((String)sourceMap.get("timestamp")).sampling((String)sourceMap.get("sampling")).querySetQueries(querySetEntries).build();
    }

    private SearchConfiguration convertToSearchConfiguration(SearchResponse response) {
        if (response.getHits().getTotalHits().value() == 0L) {
            throw new SearchRelevanceException("SearchConfiguration not found", RestStatus.NOT_FOUND);
        }
        Map source = response.getHits().getHits()[0].getSourceAsMap();
        return new SearchConfiguration((String)source.get("id"), (String)source.get("name"), (String)source.get("timestamp"), (String)source.get("index"), (String)source.get("query"), (String)source.get("searchPipeline"));
    }

    private void calculateMetricsAsync(String experimentId, PutExperimentRequest request, Map<String, SearchConfigurationDetails> searchConfigurations, List<String> queryTextWithReferences) {
        if (queryTextWithReferences == null || searchConfigurations == null) {
            throw new IllegalStateException("Missing required data for metrics calculation");
        }
        this.processQueryTextMetrics(experimentId, request, searchConfigurations, queryTextWithReferences);
    }

    private void processQueryTextMetrics(String experimentId, PutExperimentRequest request, Map<String, SearchConfigurationDetails> searchConfigurations, List<String> queryTexts) {
        List<Map<String, Object>> finalResults = Collections.synchronizedList(new ArrayList());
        AtomicInteger pendingQueries = new AtomicInteger(queryTexts.size());
        AtomicBoolean hasFailure = new AtomicBoolean(false);
        this.executeExperimentEvaluation(experimentId, request, searchConfigurations, queryTexts, finalResults, pendingQueries, hasFailure, request.getJudgmentList(), null, null);
    }

    @VisibleForTesting
    void executeExperimentEvaluation(String experimentId, PutExperimentRequest request, Map<String, SearchConfigurationDetails> searchConfigurations, List<String> queryTexts, List<Map<String, Object>> finalResults, AtomicInteger pendingQueries, AtomicBoolean hasFailure, List<String> judgmentList, ExperimentCancellationToken cancellationToken, CountDownLatch actuallyFinished) {
        int completedQueries = 0;
        int totalQueries = queryTexts.size();
        for (String queryText : queryTexts) {
            if (hasFailure.get() || this.checkIfCancelled(cancellationToken)) {
                log.info("Scheduled experiment based on underlying experiment {} has been timed out while executing experiments for each queryText on queryText, {}. Completed {} queries out of {} queries", (Object)experimentId, (Object)queryText, (Object)completedQueries, (Object)totalQueries);
                this.handleFailure(new Exception("Experiment cancelled"), hasFailure, experimentId, request, actuallyFinished);
                return;
            }
            if (request.getType() == ExperimentType.PAIRWISE_COMPARISON) {
                this.metricsHelper.processPairwiseMetrics(queryText, searchConfigurations, request.getSize(), (ActionListener<Map<String, Object>>)ActionListener.wrap(queryResults -> this.handleQueryResults(queryText, (Map<String, Object>)queryResults, finalResults, pendingQueries, experimentId, request, hasFailure, judgmentList, cancellationToken, actuallyFinished), error -> this.handleFailure((Exception)error, hasFailure, experimentId, request, actuallyFinished)));
            } else if (request.getType() == ExperimentType.HYBRID_OPTIMIZER) {
                this.hybridOptimizerExperimentProcessor.processHybridOptimizerExperiment(experimentId, queryText, searchConfigurations, judgmentList, request.getSize(), request.getScheduledExperimentResultId(), cancellationToken, this.runningFutures, (ActionListener<Map<String, Object>>)ActionListener.wrap(queryResults -> this.handleQueryResults(queryText, (Map<String, Object>)queryResults, finalResults, pendingQueries, experimentId, request, hasFailure, judgmentList, cancellationToken, actuallyFinished), error -> this.handleFailure((Exception)error, hasFailure, experimentId, request, actuallyFinished)));
            } else if (request.getType() == ExperimentType.POINTWISE_EVALUATION) {
                this.pointwiseExperimentProcessor.processPointwiseExperiment(experimentId, queryText, searchConfigurations, judgmentList, request.getSize(), hasFailure, request.getScheduledExperimentResultId(), cancellationToken, (ActionListener<Map<String, Object>>)ActionListener.wrap(queryResults -> this.handleQueryResults(queryText, (Map<String, Object>)queryResults, finalResults, pendingQueries, experimentId, request, hasFailure, judgmentList, cancellationToken, actuallyFinished), error -> this.handleFailure((Exception)error, hasFailure, experimentId, request, actuallyFinished)));
            } else {
                throw new SearchRelevanceException("Unknown experimentType" + String.valueOf((Object)request.getType()), RestStatus.BAD_REQUEST);
            }
            ++completedQueries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleQueryResults(String queryText, Map<String, Object> queryResults, List<Map<String, Object>> finalResults, AtomicInteger pendingQueries, String experimentId, PutExperimentRequest request, AtomicBoolean hasFailure, List<String> judgmentList, ExperimentCancellationToken cancellationToken, CountDownLatch actuallyFinished) {
        if (hasFailure.get() || this.checkIfCancelled(cancellationToken)) {
            log.info("Experiment with underlying id {} has been timed out or failed before handling query results, therefore we should not update results", (Object)experimentId);
            this.handleFailure(null, hasFailure, experimentId, request, actuallyFinished);
            return;
        }
        try {
            List<Map<String, Object>> list = finalResults;
            synchronized (list) {
                if (request.getType() == ExperimentType.HYBRID_OPTIMIZER) {
                    List searchConfigResults = (List)queryResults.get("searchConfigurationResults");
                    if (searchConfigResults != null) {
                        for (Map configResult : searchConfigResults) {
                            HashMap<String, String> resultWithQuery = new HashMap<String, String>(configResult);
                            resultWithQuery.put("query_text", queryText);
                            finalResults.add(resultWithQuery);
                        }
                    }
                } else if (request.getType() == ExperimentType.POINTWISE_EVALUATION) {
                    List pointwiseResults = (List)queryResults.get("results");
                    if (pointwiseResults != null) {
                        finalResults.addAll(pointwiseResults);
                    }
                } else {
                    queryResults.put("query_text", queryText);
                    finalResults.add(queryResults);
                }
                if (pendingQueries.decrementAndGet() == 0) {
                    this.updateFinalExperiment(experimentId, request, finalResults, judgmentList, actuallyFinished);
                }
            }
        }
        catch (Exception e) {
            this.handleFailure(e, hasFailure, experimentId, request, actuallyFinished);
        }
    }

    private void handleFailure(Exception error, AtomicBoolean hasFailure, String experimentId, PutExperimentRequest request, CountDownLatch actuallyFinished) {
        if (hasFailure.compareAndSet(false, true)) {
            this.handleAsyncFailure(experimentId, request, "Failed to process metrics", error, actuallyFinished);
        }
    }

    private void updateFinalExperiment(String experimentId, PutExperimentRequest request, List<Map<String, Object>> finalResults, List<String> judgmentList, CountDownLatch actuallyFinished) {
        if (request.getScheduledExperimentResultId() != null) {
            ScheduledExperimentResult finalExperiment = new ScheduledExperimentResult(request.getScheduledExperimentResultId(), experimentId, TimeUtils.getTimestamp(), AsyncStatus.COMPLETED, finalResults);
            this.scheduledExperimentHistoryDao.updateScheduledExperimentResult(finalExperiment, ActionListener.wrap(response -> log.debug("Updated completed scheduled experiment: {}", (Object)experimentId), error -> this.handleAsyncFailure(experimentId, request, "Failed to update final experiment", (Exception)error, actuallyFinished)));
            actuallyFinished.countDown();
            return;
        }
        Experiment finalExperiment = new Experiment(experimentId, TimeUtils.getTimestamp(), request.getType(), AsyncStatus.COMPLETED, request.getQuerySetId(), request.getSearchConfigurationList(), judgmentList, request.getSize(), finalResults);
        this.experimentDao.updateExperiment(finalExperiment, ActionListener.wrap(response -> log.debug("Updated final experiment: {}", (Object)experimentId), error -> this.handleAsyncFailure(experimentId, request, "Failed to update final experiment", (Exception)error, actuallyFinished)));
    }

    private void handleAsyncFailure(String experimentId, PutExperimentRequest request, String message, Exception error, CountDownLatch actuallyFinished) {
        log.error(message + " for scheduled experiment: " + experimentId, (Throwable)error);
        if (request.getScheduledExperimentResultId() != null) {
            ScheduledExperimentResult finalExperiment = new ScheduledExperimentResult(request.getScheduledExperimentResultId(), experimentId, TimeUtils.getTimestamp(), AsyncStatus.ERROR, null);
            this.scheduledExperimentHistoryDao.updateScheduledExperimentResult(finalExperiment, ActionListener.wrap(response -> log.info("Updated scheduled experiment {} status to ERROR", (Object)experimentId), e -> log.error("Failed to update error status for scheduled experiment: " + experimentId, (Throwable)e)));
            actuallyFinished.countDown();
            return;
        }
        log.error(message + " for experiment: " + experimentId, (Throwable)error);
        Experiment errorExperiment = new Experiment(experimentId, TimeUtils.getTimestamp(), request.getType(), AsyncStatus.ERROR, request.getQuerySetId(), request.getSearchConfigurationList(), request.getJudgmentList(), request.getSize(), List.of(Map.of("error", error.getMessage())));
        this.experimentDao.updateExperiment(errorExperiment, ActionListener.wrap(response -> log.info("Updated experiment {} status to ERROR", (Object)experimentId), e -> log.error("Failed to update error status for experiment: " + experimentId, (Throwable)e)));
    }

    @Generated
    public ExperimentRunningManager(ExperimentDao experimentDao, QuerySetDao querySetDao, SearchConfigurationDao searchConfigurationDao, ScheduledExperimentHistoryDao scheduledExperimentHistoryDao, MetricsHelper metricsHelper, HybridOptimizerExperimentProcessor hybridOptimizerExperimentProcessor, PointwiseExperimentProcessor pointwiseExperimentProcessor, ThreadPool threadPool, SearchRelevanceSettingsAccessor settingsAccessor) {
        this.experimentDao = experimentDao;
        this.querySetDao = querySetDao;
        this.searchConfigurationDao = searchConfigurationDao;
        this.scheduledExperimentHistoryDao = scheduledExperimentHistoryDao;
        this.metricsHelper = metricsHelper;
        this.hybridOptimizerExperimentProcessor = hybridOptimizerExperimentProcessor;
        this.pointwiseExperimentProcessor = pointwiseExperimentProcessor;
        this.threadPool = threadPool;
        this.settingsAccessor = settingsAccessor;
    }
}

