/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.scheduler;

import java.time.Instant;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.jobscheduler.spi.schedule.CronSchedule;
import org.opensearch.jobscheduler.spi.schedule.Schedule;
import org.opensearch.searchrelevance.dao.ExperimentDao;
import org.opensearch.searchrelevance.dao.ScheduledExperimentHistoryDao;
import org.opensearch.searchrelevance.dao.ScheduledJobsDao;
import org.opensearch.searchrelevance.exception.SearchRelevanceException;
import org.opensearch.searchrelevance.executors.ExperimentRunningManager;
import org.opensearch.searchrelevance.model.AsyncStatus;
import org.opensearch.searchrelevance.model.Experiment;
import org.opensearch.searchrelevance.model.ExperimentType;
import org.opensearch.searchrelevance.model.ScheduledExperimentResult;
import org.opensearch.searchrelevance.model.ScheduledJob;
import org.opensearch.searchrelevance.scheduler.ExperimentCancellationToken;
import org.opensearch.searchrelevance.scheduler.SearchRelevanceJobParameters;
import org.opensearch.searchrelevance.transport.experiment.PutExperimentRequest;
import org.opensearch.searchrelevance.utils.TimeUtils;

@ExperimentalApi
public class ScheduledExperimentRunnerManager {
    @Generated
    private static final Logger log = LogManager.getLogger(ScheduledExperimentRunnerManager.class);
    private ExperimentDao experimentDao;
    private ScheduledExperimentHistoryDao scheduledExperimentHistoryDao;
    private ExperimentRunningManager experimentRunningManager;
    private ScheduledJobsDao scheduledJobsDao;

    @Inject
    public ScheduledExperimentRunnerManager(ExperimentDao experimentDao, ScheduledExperimentHistoryDao scheduledExperimentHistoryDao, ExperimentRunningManager experimentRunningManager, ScheduledJobsDao scheduledJobsDao) {
        this.experimentDao = experimentDao;
        this.scheduledExperimentHistoryDao = scheduledExperimentHistoryDao;
        this.experimentRunningManager = experimentRunningManager;
        this.scheduledJobsDao = scheduledJobsDao;
    }

    public void runScheduledExperiment(SearchRelevanceJobParameters parameter, String scheduledExperimentResultId, ExperimentCancellationToken cancellationToken, CountDownLatch actuallyFinished) {
        final String experimentId = parameter.getExperimentId();
        try {
            this.experimentDao.getExperiment(experimentId, (ActionListener<SearchResponse>)ActionListener.wrap(experimentResponse -> {
                try {
                    if (this.checkIfCancelled(cancellationToken)) {
                        log.info("Scheduled experiment for {} timed out before placing scheduled experiment into index.", (Object)experimentId);
                        actuallyFinished.countDown();
                        return;
                    }
                    Experiment experiment = this.convertToExperiment((SearchResponse)experimentResponse);
                    String timestamp = TimeUtils.getTimestamp();
                    ScheduledExperimentResult scheduledExperimentResult = new ScheduledExperimentResult(scheduledExperimentResultId, experimentId, timestamp, AsyncStatus.PROCESSING, null);
                    PutExperimentRequest request = new PutExperimentRequest(experiment.type(), scheduledExperimentResultId, experiment.querySetId(), experiment.searchConfigurationList(), experiment.judgmentList(), experiment.size());
                    this.scheduledExperimentHistoryDao.putScheduledExperimentResult(scheduledExperimentResult, ActionListener.wrap(response -> {
                        if (this.checkIfCancelled(cancellationToken)) {
                            log.info("Scheduled experiment for {} timed out after placing scheduled experiment into index.", (Object)experimentId);
                            actuallyFinished.countDown();
                            return;
                        }
                        this.scheduledJobsDao.getScheduledJob(experimentId, (ActionListener<SearchResponse>)ActionListener.wrap(jobResponse -> {
                            ScheduledJob scheduledJob = this.convertToScheduledJob((SearchResponse)jobResponse);
                            this.scheduledJobsDao.updateScheduledJob(scheduledJob, ActionListener.wrap(updatedJobResponse -> this.experimentRunningManager.startExperimentRun(experimentId, request, cancellationToken, actuallyFinished), e -> {
                                log.error("Somehow for experiment {}, we cannot update the experiment run job", (Object)experimentId);
                                this.handleAsyncFailure(experimentId, request, timestamp, (Exception)e);
                                actuallyFinished.countDown();
                            }));
                        }, e -> {
                            log.error("Somehow for experiment {}, we cannot retrieve the experiment run job", (Object)experimentId);
                            this.handleAsyncFailure(experimentId, request, timestamp, (Exception)e);
                            actuallyFinished.countDown();
                        }));
                    }, e -> {
                        log.error("Somehow for experiment {}, we cannot put the experiment result", (Object)experimentId);
                        this.handleAsyncFailure(experimentId, request, "Failed to put ScheduledExperimentResult", (Exception)e);
                        actuallyFinished.countDown();
                    }));
                }
                catch (Exception e2) {
                    log.error("Scheduled experiment result for: {} cannot be added.", (Object)experimentId);
                    actuallyFinished.countDown();
                }
            }, e -> {
                log.error("Experiment id: {} is not found.", (Object)experimentId);
                this.scheduledJobsDao.deleteScheduledJob(experimentId, new ActionListener<DeleteResponse>(){

                    public void onResponse(DeleteResponse deleteResponse) {
                        log.info("Non existent experiment. Deleting scheduled job {}", (Object)experimentId);
                    }

                    public void onFailure(Exception e) {
                        log.error("Somehow scheduled experiment job was deleted while experiment {} was in scheduling queue.", (Object)experimentId);
                    }
                });
                actuallyFinished.countDown();
            }));
        }
        catch (Exception e2) {
            actuallyFinished.countDown();
            throw new IllegalStateException("Experiment not found.");
        }
    }

    private boolean checkIfCancelled(ExperimentCancellationToken cancellationToken) {
        return cancellationToken != null && cancellationToken.isCancelled();
    }

    private Experiment convertToExperiment(SearchResponse response) {
        if (response.getHits().getTotalHits().value() == 0L) {
            throw new SearchRelevanceException("Experiment not found", RestStatus.NOT_FOUND);
        }
        Map sourceMap = response.getHits().getHits()[0].getSourceAsMap();
        return new Experiment("", "", ExperimentType.valueOf((String)sourceMap.get("type")), AsyncStatus.valueOf((String)sourceMap.get("status")), (String)sourceMap.get("querySetId"), (List)sourceMap.get("searchConfigurationList"), (List)sourceMap.get("judgmentList"), (Integer)sourceMap.get("size"), List.of());
    }

    private ScheduledJob convertToScheduledJob(SearchResponse response) {
        if (response.getHits().getTotalHits().value() == 0L) {
            throw new SearchRelevanceException("Experiment not found", RestStatus.NOT_FOUND);
        }
        Map sourceMap = response.getHits().getHits()[0].getSourceAsMap();
        String cronExpression = (String)((Map)((Map)sourceMap.get("schedule")).get("cron")).get("expression");
        return new ScheduledJob((String)sourceMap.get("id"), Instant.now(), Instant.ofEpochMilli((Long)sourceMap.get("enabledTime")), true, (Schedule)new CronSchedule(cronExpression, ZoneId.systemDefault()), (String)sourceMap.get("timestamp"));
    }

    private void handleAsyncFailure(String experimentId, PutExperimentRequest request, String message, Exception error) {
        log.error(message + " for scheduled experiment: " + experimentId, (Throwable)error);
        ScheduledExperimentResult finalExperiment = new ScheduledExperimentResult(request.getScheduledExperimentResultId(), experimentId, TimeUtils.getTimestamp(), AsyncStatus.ERROR, null);
        this.scheduledExperimentHistoryDao.updateScheduledExperimentResult(finalExperiment, ActionListener.wrap(response -> log.info("Updated scheduled experiment {} status to ERROR", (Object)request.getScheduledExperimentResultId()), e -> log.error("Failed to update error status for scheduled experiment: {}", (Object)request.getScheduledExperimentResultId(), e)));
    }

    public void cleanupResources(String experimentId, String scheduledExperimentResultId, ExperimentCancellationToken cancellationToken) {
        log.info("Cleaning up all resources for {}", (Object)experimentId);
        ScheduledExperimentResult finalExperiment = new ScheduledExperimentResult(scheduledExperimentResultId, experimentId, TimeUtils.getTimestamp(), AsyncStatus.TIMEOUT, null);
        if (cancellationToken.isCancelled()) {
            this.scheduledExperimentHistoryDao.updateScheduledExperimentResult(finalExperiment, ActionListener.wrap(response -> log.info("Updated scheduled experiment {} status to TIMEOUT", (Object)scheduledExperimentResultId), e -> log.error("Failed to update error status for scheduled experiment: {}", (Object)scheduledExperimentResultId, e)));
        }
    }
}

