/*
 * Decompiled with CFR 0.152.
 */
package ciir.umass.edu.metric;

import ciir.umass.edu.learning.RankList;
import ciir.umass.edu.metric.MetricScorer;
import java.util.Arrays;

public class BestAtKScorer
extends MetricScorer {
    public BestAtKScorer() {
        this.k = 10;
    }

    public BestAtKScorer(int k) {
        this.k = k;
    }

    @Override
    public double score(RankList rl) {
        return rl.get(this.maxToK(rl, this.k - 1)).getLabel();
    }

    @Override
    public MetricScorer copy() {
        return new BestAtKScorer();
    }

    public int maxToK(RankList rl, int k) {
        int size = k;
        if (size < 0 || size > rl.size() - 1) {
            size = rl.size() - 1;
        }
        double max = -1.0;
        int max_i = 0;
        for (int i = 0; i <= size; ++i) {
            if (!(max < (double)rl.get(i).getLabel())) continue;
            max = rl.get(i).getLabel();
            max_i = i;
        }
        return max_i;
    }

    @Override
    public String name() {
        return "Best@" + this.k;
    }

    @Override
    public double[][] swapChange(RankList rl) {
        int i;
        int[] labels = new int[rl.size()];
        int[] best = new int[rl.size()];
        int max = -1;
        int maxVal = -1;
        int secondMaxVal = -1;
        int maxCount = 0;
        for (int i2 = 0; i2 < rl.size(); ++i2) {
            int v;
            labels[i2] = v = (int)rl.get(i2).getLabel();
            if (maxVal < v) {
                if (i2 < this.k) {
                    secondMaxVal = maxVal;
                    maxCount = 0;
                }
                maxVal = v;
                max = i2;
            } else if (maxVal == v && i2 < this.k) {
                ++maxCount;
            }
            best[i2] = max;
        }
        if (secondMaxVal == -1) {
            secondMaxVal = 0;
        }
        double[][] changes = new double[rl.size()][];
        for (i = 0; i < rl.size(); ++i) {
            changes[i] = new double[rl.size()];
            Arrays.fill(changes[i], 0.0);
        }
        for (i = 0; i < rl.size() - 1; ++i) {
            for (int j = i + 1; j < rl.size(); ++j) {
                double change = 0.0;
                change = j < this.k || i >= this.k ? 0.0 : (labels[i] == labels[j] || labels[j] == labels[best[this.k - 1]] ? 0.0 : (labels[j] > labels[best[this.k - 1]] ? (double)(labels[j] - labels[best[i]]) : (labels[i] < labels[best[this.k - 1]] || maxCount > 1 ? 0.0 : (double)(maxVal - Math.max(secondMaxVal, labels[j])))));
                double d = change;
                changes[j][i] = d;
                changes[i][j] = d;
            }
        }
        return changes;
    }
}

