/*
 * Decompiled with CFR 0.152.
 */
package ciir.umass.edu.stats;

import ciir.umass.edu.stats.BasicStats;
import ciir.umass.edu.stats.SignificanceTest;
import java.util.HashMap;
import java.util.Random;

public class RandomPermutationTest
extends SignificanceTest {
    public static int nPermutation = 10000;
    private static String[] pad = new String[]{"", "0", "00", "000", "0000", "00000", "000000", "0000000", "00000000", "000000000"};

    @Override
    public double test(HashMap<String, Double> target, HashMap<String, Double> baseline) {
        double[] b = new double[baseline.keySet().size()];
        double[] t = new double[target.keySet().size()];
        int c = 0;
        for (String key : baseline.keySet()) {
            b[c] = baseline.get(key);
            t[c] = target.get(key);
            ++c;
        }
        double trueDiff = Math.abs(BasicStats.mean(b) - BasicStats.mean(t));
        double pvalue = 0.0;
        double[] pb = new double[baseline.keySet().size()];
        double[] pt = new double[target.keySet().size()];
        for (int i = 0; i < nPermutation; ++i) {
            char[] bits = this.randomBitVector(b.length).toCharArray();
            for (int j = 0; j < b.length; ++j) {
                if (bits[j] == '0') {
                    pb[j] = b[j];
                    pt[j] = t[j];
                    continue;
                }
                pb[j] = t[j];
                pt[j] = b[j];
            }
            double pDiff = Math.abs(BasicStats.mean(pb) - BasicStats.mean(pt));
            if (!(pDiff >= trueDiff)) continue;
            pvalue += 1.0;
        }
        return pvalue / (double)nPermutation;
    }

    private String randomBitVector(int size) {
        Random r = new Random();
        String output = "";
        for (int i = 0; i < size / 10 + 1; ++i) {
            int x = (int)(1024.0 * r.nextDouble());
            String s = Integer.toBinaryString(x);
            output = s.length() == 11 ? output + s.substring(1) : output + pad[10 - s.length()] + s;
        }
        return output;
    }
}

