/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.processor;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.ml.engine.annotation.Processor;
import org.opensearch.ml.engine.processor.AbstractMLProcessor;
import org.opensearch.ml.engine.processor.MLProcessor;
import org.opensearch.ml.engine.processor.MLProcessorType;
import org.opensearch.ml.engine.processor.ProcessorChain;

@Processor(value=MLProcessorType.PROCESS_AND_SET)
public class MLProcessAndSetProcessor
extends AbstractMLProcessor {
    @Generated
    private static final Logger log = LogManager.getLogger(MLProcessAndSetProcessor.class);
    private final String targetPath;
    private final List<MLProcessor> nestedProcessors;

    public MLProcessAndSetProcessor(Map<String, Object> config) {
        super(config);
        this.targetPath = (String)config.get("path");
        Object processorsConfig = config.get("processors");
        this.nestedProcessors = ProcessorChain.parseProcessorConfigs(processorsConfig);
        if (this.nestedProcessors.isEmpty()) {
            throw new IllegalArgumentException("'processors' list cannot be empty for process_and_set processor");
        }
    }

    @Override
    protected void validateConfig() {
        if (!this.config.containsKey("path")) {
            throw new IllegalArgumentException("'path' is required for process_and_set processor");
        }
        String pathValue = (String)this.config.get("path");
        if (pathValue == null || pathValue.trim().isEmpty()) {
            throw new IllegalArgumentException("'path' cannot be empty for process_and_set processor");
        }
        if (!this.config.containsKey("processors")) {
            throw new IllegalArgumentException("'processors' is required for process_and_set processor");
        }
    }

    @Override
    public Object process(Object input) {
        try {
            String jsonStr = StringUtils.toJson((Object)input);
            DocumentContext context = JsonPath.parse((String)jsonStr);
            Object processedValue = ProcessorChain.applyProcessors(input, this.nestedProcessors);
            if (!this.setValueAtPath(context, processedValue)) {
                return input;
            }
            return context.json();
        }
        catch (Exception e) {
            log.warn("Failed to process and set at path '{}': {}", (Object)this.targetPath, (Object)e.getMessage());
            return input;
        }
    }

    private boolean setValueAtPath(DocumentContext context, Object value) {
        try {
            context.set(this.targetPath, value, new Predicate[0]);
            return true;
        }
        catch (Exception setException) {
            log.debug("Failed to set value at path '{}': {}. Attempting to create it", (Object)this.targetPath, (Object)setException.getMessage());
            return this.createAndSetPath(context, value, setException);
        }
    }

    private boolean createAndSetPath(DocumentContext context, Object value, Exception originalException) {
        int lastBracketIndex;
        int lastDotIndex = this.targetPath.lastIndexOf(46);
        if (lastDotIndex > (lastBracketIndex = this.targetPath.lastIndexOf(91))) {
            String parentPath = this.targetPath.substring(0, lastDotIndex);
            String key = this.targetPath.substring(lastDotIndex + 1);
            try {
                context.put(parentPath, key, value, new Predicate[0]);
                log.debug("Successfully created new field '{}' at parent path '{}'", (Object)key, (Object)parentPath);
                return true;
            }
            catch (Exception putException) {
                log.warn("Failed to create new path '{}': parent path '{}' may not exist or is not an object. Error: {}", (Object)this.targetPath, (Object)parentPath, (Object)putException.getMessage());
                return false;
            }
        }
        log.warn("Failed to set path '{}' and cannot create it (array paths not supported for creation): {}", (Object)this.targetPath, (Object)originalException.getMessage());
        return false;
    }
}

