/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.util;

import com.amazonaws.encryptionsdk.AwsCrypto;
import com.amazonaws.encryptionsdk.CommitmentPolicy;
import com.amazonaws.encryptionsdk.CryptoResult;
import com.amazonaws.encryptionsdk.MasterKeyProvider;
import com.amazonaws.encryptionsdk.jce.JceMasterKey;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.get.GetResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Nullable;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.indices.FlowFrameworkIndicesHandler;
import org.opensearch.flowframework.model.Config;
import org.opensearch.flowframework.model.Template;
import org.opensearch.flowframework.model.Workflow;
import org.opensearch.flowframework.model.WorkflowNode;
import org.opensearch.flowframework.util.ParseUtils;
import org.opensearch.remote.metadata.client.GetDataObjectRequest;
import org.opensearch.remote.metadata.client.PutDataObjectRequest;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.remote.metadata.common.SdkClientUtils;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.transport.client.Client;

public class EncryptorUtils {
    private static final Logger logger = LogManager.getLogger(EncryptorUtils.class);
    private static final String ALGORITHM = "AES";
    private static final String PROVIDER = "Custom";
    private static final String WRAPPING_ALGORITHM = "AES/GCM/NOPADDING";
    private static final String DEFAULT_TENANT_ID = "";
    private final ClusterService clusterService;
    private final Client client;
    private final SdkClient sdkClient;
    private final Map<String, String> tenantMasterKeys = new ConcurrentHashMap<String, String>();
    private final NamedXContentRegistry xContentRegistry;
    private static boolean multiTenancyEnabled;

    public EncryptorUtils(ClusterService clusterService, Client client, SdkClient sdkClient, NamedXContentRegistry xContentRegistry, boolean multiTenancyEnabled) {
        this.clusterService = clusterService;
        this.client = client;
        this.sdkClient = sdkClient;
        this.xContentRegistry = xContentRegistry;
        EncryptorUtils.multiTenancyEnabled = multiTenancyEnabled;
    }

    void setMasterKey(@Nullable String tenantId, String masterKey) {
        this.tenantMasterKeys.put(Objects.requireNonNullElse(tenantId, DEFAULT_TENANT_ID), masterKey);
    }

    String getMasterKey(@Nullable String tenantId) {
        return this.tenantMasterKeys.get(Objects.requireNonNullElse(tenantId, DEFAULT_TENANT_ID));
    }

    String generateMasterKey() {
        byte[] masterKeyBytes = new byte[32];
        new SecureRandom().nextBytes(masterKeyBytes);
        return Base64.getEncoder().encodeToString(masterKeyBytes);
    }

    public Template encryptTemplateCredentials(Template template) {
        return this.processTemplateCredentials(template, this::encrypt);
    }

    public Template decryptTemplateCredentials(Template template) {
        return this.processTemplateCredentials(template, this::decrypt);
    }

    private Template processTemplateCredentials(Template template, BiFunction<String, String, String> cipherFunction) {
        HashMap<String, Workflow> processedWorkflows = new HashMap<String, Workflow>();
        for (Map.Entry<String, Workflow> entry : template.workflows().entrySet()) {
            ArrayList<WorkflowNode> processedNodes = new ArrayList<WorkflowNode>();
            for (WorkflowNode node : entry.getValue().nodes()) {
                if (node.userInputs().containsKey("credential")) {
                    HashMap<String, String> credentials = new HashMap<String, String>((Map)node.userInputs().get("credential"));
                    credentials.replaceAll((key, cred) -> (String)cipherFunction.apply((String)cred, template.getTenantId()));
                    HashMap<String, Object> processedUserInputs = new HashMap<String, Object>();
                    processedUserInputs.putAll(node.userInputs());
                    processedUserInputs.replace("credential", credentials);
                    WorkflowNode processedWorkflowNode = new WorkflowNode(node.id(), node.type(), node.previousNodeInputs(), processedUserInputs);
                    processedNodes.add(processedWorkflowNode);
                    continue;
                }
                processedNodes.add(node);
            }
            processedWorkflows.put(entry.getKey(), new Workflow(entry.getValue().userParams(), processedNodes, entry.getValue().edges()));
        }
        return Template.builder(template).workflows(processedWorkflows).build();
    }

    String encrypt(String credential, @Nullable String tenantId) {
        CountDownLatch latch = new CountDownLatch(1);
        this.initializeMasterKeyIfAbsent(tenantId).whenComplete((v, throwable) -> latch.countDown());
        try {
            if (!latch.await(5L, TimeUnit.SECONDS)) {
                throw new FlowFrameworkException("Timeout while initializing master key", RestStatus.INTERNAL_SERVER_ERROR);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new FlowFrameworkException("Interrupted while initializing master key", RestStatus.REQUEST_TIMEOUT);
        }
        AwsCrypto crypto = AwsCrypto.builder().withCommitmentPolicy(CommitmentPolicy.RequireEncryptRequireDecrypt).build();
        byte[] bytes = Base64.getDecoder().decode(this.getMasterKey(tenantId));
        JceMasterKey jceMasterKey = JceMasterKey.getInstance((SecretKey)new SecretKeySpec(bytes, ALGORITHM), (String)PROVIDER, (String)DEFAULT_TENANT_ID, (String)WRAPPING_ALGORITHM);
        CryptoResult encryptResult = crypto.encryptData((MasterKeyProvider)jceMasterKey, credential.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString((byte[])encryptResult.getResult());
    }

    String decrypt(String encryptedCredential, @Nullable String tenantId) {
        CountDownLatch latch = new CountDownLatch(1);
        this.initializeMasterKeyIfAbsent(tenantId).whenComplete((v, throwable) -> latch.countDown());
        try {
            if (!latch.await(5L, TimeUnit.SECONDS)) {
                throw new FlowFrameworkException("Timeout while initializing master key", RestStatus.INTERNAL_SERVER_ERROR);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new FlowFrameworkException("Interrupted while initializing master key", RestStatus.REQUEST_TIMEOUT);
        }
        AwsCrypto crypto = AwsCrypto.builder().withCommitmentPolicy(CommitmentPolicy.RequireEncryptRequireDecrypt).build();
        byte[] bytes = Base64.getDecoder().decode(this.getMasterKey(tenantId));
        JceMasterKey jceMasterKey = JceMasterKey.getInstance((SecretKey)new SecretKeySpec(bytes, ALGORITHM), (String)PROVIDER, (String)DEFAULT_TENANT_ID, (String)WRAPPING_ALGORITHM);
        CryptoResult decryptedResult = crypto.decryptData((MasterKeyProvider)jceMasterKey, Base64.getDecoder().decode(encryptedCredential));
        return new String((byte[])decryptedResult.getResult(), StandardCharsets.UTF_8);
    }

    public Template redactTemplateSecuredFields(User user, Template template) {
        HashMap<String, Workflow> processedWorkflows = new HashMap<String, Workflow>();
        for (Map.Entry<String, Workflow> entry : template.workflows().entrySet()) {
            ArrayList<WorkflowNode> processedNodes = new ArrayList<WorkflowNode>();
            for (WorkflowNode node : entry.getValue().nodes()) {
                if (node.userInputs().containsKey("credential")) {
                    HashMap<String, Object> processedUserInputs = new HashMap<String, Object>(node.userInputs());
                    processedUserInputs.remove("credential");
                    processedNodes.add(new WorkflowNode(node.id(), node.type(), node.previousNodeInputs(), processedUserInputs));
                    continue;
                }
                processedNodes.add(node);
            }
            processedWorkflows.put(entry.getKey(), new Workflow(entry.getValue().userParams(), processedNodes, entry.getValue().edges()));
        }
        if (ParseUtils.isAdmin(user)) {
            return Template.builder(template).workflows(processedWorkflows).build();
        }
        return Template.builder(template).user(null).workflows(processedWorkflows).build();
    }

    public void initializeMasterKey(@Nullable String tenantId, ActionListener<Boolean> listener) {
        ((CompletableFuture)this.cacheMasterKeyFromConfigIndex(tenantId).thenApply(v -> {
            listener.onResponse((Object)true);
            return null;
        })).exceptionally(throwable -> {
            Exception exception = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
            if (exception instanceof FlowFrameworkException) {
                FlowFrameworkException ffe = (FlowFrameworkException)((Object)((Object)exception));
                if (ffe.status() == RestStatus.NOT_FOUND) {
                    this.generateAndIndexNewMasterKey(tenantId, listener);
                } else {
                    listener.onFailure((Exception)((Object)ffe));
                }
            } else {
                listener.onFailure(exception);
            }
            return null;
        });
    }

    private void generateAndIndexNewMasterKey(String tenantId, ActionListener<Boolean> listener) {
        String masterKeyId = tenantId == null ? "master_key" : "master_key_" + this.hashString(tenantId);
        Config config = new Config(this.generateMasterKey(), Instant.now());
        PutDataObjectRequest putRequest = ((PutDataObjectRequest.Builder)((PutDataObjectRequest.Builder)((PutDataObjectRequest.Builder)PutDataObjectRequest.builder().index(".plugins-flow-framework-config")).id(masterKeyId)).tenantId(tenantId)).overwriteIfExists(false).dataObject((ToXContentObject)config).build();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.sdkClient.putDataObjectAsync(putRequest).whenComplete((r, throwable) -> {
                context.restore();
                if (throwable == null) {
                    logger.info("Config has been initialized successfully");
                    this.setMasterKey(tenantId, config.masterKey());
                    listener.onResponse((Object)true);
                } else {
                    Exception exception = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                    if (exception instanceof OpenSearchStatusException && ((OpenSearchStatusException)exception).status() == RestStatus.CONFLICT) {
                        logger.debug("Concurrent master key creation detected, retrying to get existing key");
                        this.cacheMasterKeyFromConfigIndex(tenantId).handle((v, ex) -> {
                            if (ex == null) {
                                listener.onResponse((Object)true);
                            } else {
                                listener.onFailure(SdkClientUtils.unwrapAndConvertToException((Throwable)ex, (Class[])new Class[0]));
                            }
                            return null;
                        });
                    } else {
                        logger.error("Failed to index new master key in config for tenant id {}", (Object)tenantId, (Object)exception);
                        listener.onFailure(exception);
                    }
                }
            });
        }
    }

    CompletableFuture<Void> initializeMasterKeyIfAbsent(@Nullable String tenantId) {
        if (this.tenantMasterKeys.containsKey(Objects.requireNonNullElse(tenantId, DEFAULT_TENANT_ID))) {
            return CompletableFuture.completedFuture(null);
        }
        if (!FlowFrameworkIndicesHandler.doesIndexExistMultitenant(this.clusterService, ".plugins-flow-framework-config", multiTenancyEnabled)) {
            return CompletableFuture.failedFuture((Throwable)((Object)new FlowFrameworkException("Config Index has not been initialized", RestStatus.INTERNAL_SERVER_ERROR)));
        }
        return this.cacheMasterKeyFromConfigIndex(tenantId);
    }

    private CompletableFuture<Void> cacheMasterKeyFromConfigIndex(String tenantId) {
        CompletableFuture<Void> resultFuture = new CompletableFuture<Void>();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            FetchSourceContext fetchSourceContext = new FetchSourceContext(true);
            String masterKeyId = tenantId == null ? "master_key" : "master_key_" + this.hashString(tenantId);
            this.sdkClient.getDataObjectAsync(((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(".plugins-flow-framework-config")).id(masterKeyId)).tenantId(tenantId)).fetchSourceContext(fetchSourceContext).build()).whenComplete((r, throwable) -> {
                block11: {
                    context.restore();
                    if (throwable == null) {
                        try {
                            GetResponse response;
                            GetResponse getResponse = response = r.parser() == null ? null : GetResponse.fromXContent((XContentParser)r.parser());
                            if (response != null && response.isExists()) {
                                try (XContentParser parser = ParseUtils.createXContentParserFromRegistry(this.xContentRegistry, response.getSourceAsBytesRef());){
                                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                                    Config config = Config.parse(parser);
                                    this.setMasterKey(tenantId, config.masterKey());
                                    resultFuture.complete(null);
                                    break block11;
                                }
                            }
                            resultFuture.completeExceptionally((Throwable)((Object)new FlowFrameworkException("Master key has not been initialized in config index", RestStatus.NOT_FOUND)));
                        }
                        catch (IOException e) {
                            logger.error("Failed to parse config index getResponse", (Throwable)e);
                            resultFuture.completeExceptionally((Throwable)((Object)new FlowFrameworkException("Failed to parse config index getResponse", RestStatus.INTERNAL_SERVER_ERROR)));
                        }
                    } else {
                        Exception exception = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                        logger.error("Failed to get master key from config index", (Throwable)exception);
                        resultFuture.completeExceptionally((Throwable)((Object)new FlowFrameworkException("Failed to get master key from config index", ExceptionsHelper.status((Throwable)exception))));
                    }
                }
            });
            CompletableFuture<Void> completableFuture = resultFuture;
            return completableFuture;
        }
    }

    private String hashString(String input) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hashBytes = digest.digest(input.getBytes(StandardCharsets.UTF_8));
            return Base64.getUrlEncoder().encodeToString(hashBytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Error: Unable to compute hash", e);
        }
    }
}

