/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.core.service.categorizer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.util.BytesRef;
import org.opensearch.cluster.ClusterChangedEvent;
import org.opensearch.cluster.ClusterStateListener;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.hash.MurmurHash3;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.index.Index;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilderVisitor;
import org.opensearch.index.query.WithFieldName;
import org.opensearch.plugin.insights.core.service.categorizer.IndicesFieldTypeCache;
import org.opensearch.plugin.insights.core.service.categorizer.QueryShapeVisitor;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.PipelineAggregationBuilder;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.SortBuilder;

public class QueryShapeGenerator
implements ClusterStateListener {
    static final String EMPTY_STRING = "";
    static final String ONE_SPACE_INDENT = " ";
    private final ClusterService clusterService;
    private final IndicesFieldTypeCache indicesFieldTypeCache;
    private long cacheHitCount;
    private long cacheMissCount;
    private final String NO_FIELD_TYPE_VALUE = "";
    public static final String HIT_COUNT = "hit_count";
    public static final String MISS_COUNT = "miss_count";
    public static final String EVICTIONS = "evictions";
    public static final String ENTRY_COUNT = "entry_count";
    public static final String SIZE_IN_BYTES = "size_in_bytes";

    public QueryShapeGenerator(ClusterService clusterService) {
        this.clusterService = clusterService;
        clusterService.addListener((ClusterStateListener)this);
        this.indicesFieldTypeCache = new IndicesFieldTypeCache(clusterService.getSettings());
        this.cacheHitCount = 0L;
        this.cacheMissCount = 0L;
    }

    public void clusterChanged(ClusterChangedEvent event) {
        List indicesDeleted = event.indicesDeleted();
        for (Index index : indicesDeleted) {
            this.indicesFieldTypeCache.invalidate(index);
        }
        if (event.metadataChanged()) {
            Metadata previousMetadata = event.previousState().metadata();
            Metadata currentMetadata = event.state().metadata();
            for (Index index : this.indicesFieldTypeCache.keySet()) {
                if (previousMetadata.index(index) == currentMetadata.index(index)) continue;
                this.indicesFieldTypeCache.invalidate(index);
            }
        }
    }

    public MurmurHash3.Hash128 getShapeHashCode(SearchSourceBuilder source, Boolean showFieldName, Boolean showFieldType, Set<Index> successfulSearchShardIndices) {
        String shape = this.buildShape(source, showFieldName, showFieldType, successfulSearchShardIndices);
        BytesRef shapeBytes = new BytesRef((CharSequence)shape);
        return MurmurHash3.hash128((byte[])shapeBytes.bytes, (int)0, (int)shapeBytes.length, (long)0L, (MurmurHash3.Hash128)new MurmurHash3.Hash128());
    }

    public String getShapeHashCodeAsString(SearchSourceBuilder source, Boolean showFieldName, Boolean showFieldType, Set<Index> successfulSearchShardIndices) {
        MurmurHash3.Hash128 hashcode = this.getShapeHashCode(source, showFieldName, showFieldType, successfulSearchShardIndices);
        String hashAsString = Long.toHexString(hashcode.h1) + Long.toHexString(hashcode.h2);
        return hashAsString;
    }

    public String getShapeHashCodeAsString(String queryShape) {
        BytesRef shapeBytes = new BytesRef((CharSequence)queryShape);
        MurmurHash3.Hash128 hashcode = MurmurHash3.hash128((byte[])shapeBytes.bytes, (int)0, (int)shapeBytes.length, (long)0L, (MurmurHash3.Hash128)new MurmurHash3.Hash128());
        return Long.toHexString(hashcode.h1) + Long.toHexString(hashcode.h2);
    }

    public String buildShape(SearchSourceBuilder source, Boolean showFieldName, Boolean showFieldType, Set<Index> successfulSearchShardIndices) {
        Index firstIndex = null;
        Map<String, Object> propertiesAsMap = null;
        if (successfulSearchShardIndices != null) {
            firstIndex = successfulSearchShardIndices.iterator().next();
            propertiesAsMap = this.getPropertiesMapForIndex(firstIndex);
        }
        StringBuilder shape = new StringBuilder();
        shape.append(this.buildQueryShape(source.query(), showFieldName, showFieldType, propertiesAsMap, firstIndex));
        shape.append(this.buildAggregationShape(source.aggregations(), showFieldName, showFieldType, propertiesAsMap, firstIndex));
        shape.append(this.buildSortShape(source.sorts(), showFieldName, showFieldType, propertiesAsMap, firstIndex));
        return shape.toString();
    }

    private Map<String, Object> getPropertiesMapForIndex(Index index) {
        IndexMetadata indexMetadata = this.clusterService.state().metadata().index(index);
        if (indexMetadata == null) {
            return Collections.emptyMap();
        }
        Map propertiesMap = (Map)indexMetadata.mapping().getSourceAsMap().get("properties");
        if (propertiesMap == null) {
            return Collections.emptyMap();
        }
        return propertiesMap;
    }

    String buildQueryShape(QueryBuilder queryBuilder, Boolean showFieldName, Boolean showFieldType, Map<String, Object> propertiesAsMap, Index index) {
        if (queryBuilder == null) {
            return EMPTY_STRING;
        }
        QueryShapeVisitor shapeVisitor = new QueryShapeVisitor(this, propertiesAsMap, index, showFieldName, showFieldType);
        queryBuilder.visit((QueryBuilderVisitor)shapeVisitor);
        return shapeVisitor.prettyPrintTree(EMPTY_STRING, showFieldName, showFieldType);
    }

    String buildAggregationShape(AggregatorFactories.Builder aggregationsBuilder, Boolean showFieldName, Boolean showFieldType, Map<String, Object> propertiesAsMap, Index index) {
        if (aggregationsBuilder == null) {
            return EMPTY_STRING;
        }
        StringBuilder aggregationShape = this.recursiveAggregationShapeBuilder(aggregationsBuilder.getAggregatorFactories(), aggregationsBuilder.getPipelineAggregatorFactories(), new StringBuilder(), new StringBuilder(), showFieldName, showFieldType, propertiesAsMap, index);
        return aggregationShape.toString();
    }

    StringBuilder recursiveAggregationShapeBuilder(Collection<AggregationBuilder> aggregationBuilders, Collection<PipelineAggregationBuilder> pipelineAggregations, StringBuilder outputBuilder, StringBuilder baseIndent, Boolean showFieldName, Boolean showFieldType, Map<String, Object> propertiesAsMap, Index index) {
        if (!aggregationBuilders.isEmpty()) {
            outputBuilder.append((CharSequence)baseIndent).append("aggregation:").append("\n");
        }
        ArrayList<String> aggShapeStrings = new ArrayList<String>();
        for (AggregationBuilder aggBuilder : aggregationBuilders) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append((CharSequence)baseIndent).append(ONE_SPACE_INDENT.repeat(2)).append(aggBuilder.getType());
            if (showFieldName.booleanValue() || showFieldType.booleanValue()) {
                stringBuilder.append(this.buildFieldDataString((NamedWriteable)aggBuilder, propertiesAsMap, index, showFieldName, showFieldType));
            }
            stringBuilder.append("\n");
            if (!aggBuilder.getSubAggregations().isEmpty()) {
                this.recursiveAggregationShapeBuilder(aggBuilder.getSubAggregations(), aggBuilder.getPipelineAggregations(), stringBuilder, baseIndent.append(ONE_SPACE_INDENT.repeat(4)), showFieldName, showFieldType, propertiesAsMap, index);
                baseIndent.delete(0, 4);
            }
            aggShapeStrings.add(stringBuilder.toString());
        }
        Collections.sort(aggShapeStrings);
        for (String shapeString : aggShapeStrings) {
            outputBuilder.append(shapeString);
        }
        if (!pipelineAggregations.isEmpty()) {
            outputBuilder.append((CharSequence)baseIndent).append(ONE_SPACE_INDENT.repeat(2)).append("pipeline aggregation:").append("\n");
            ArrayList<String> pipelineAggShapeStrings = new ArrayList<String>();
            for (PipelineAggregationBuilder pipelineAgg : pipelineAggregations) {
                pipelineAggShapeStrings.add(baseIndent + ONE_SPACE_INDENT.repeat(4) + pipelineAgg.getType() + "\n");
            }
            Collections.sort(pipelineAggShapeStrings);
            for (String shapeString : pipelineAggShapeStrings) {
                outputBuilder.append(shapeString);
            }
        }
        return outputBuilder;
    }

    String buildSortShape(List<SortBuilder<?>> sortBuilderList, Boolean showFieldName, Boolean showFieldType, Map<String, Object> propertiesAsMap, Index index) {
        if (sortBuilderList == null || sortBuilderList.isEmpty()) {
            return EMPTY_STRING;
        }
        StringBuilder sortShape = new StringBuilder();
        sortShape.append("sort:\n");
        ArrayList<String> shapeStrings = new ArrayList<String>();
        for (SortBuilder<?> sortBuilder : sortBuilderList) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(ONE_SPACE_INDENT.repeat(2)).append(sortBuilder.order());
            if (showFieldName.booleanValue() || showFieldType.booleanValue()) {
                stringBuilder.append(this.buildFieldDataString((NamedWriteable)sortBuilder, propertiesAsMap, index, showFieldName, showFieldType));
            }
            shapeStrings.add(stringBuilder.toString());
        }
        for (String line : shapeStrings) {
            sortShape.append(line).append("\n");
        }
        return sortShape.toString();
    }

    String buildFieldDataString(NamedWriteable builder, Map<String, Object> propertiesAsMap, Index index, Boolean showFieldName, Boolean showFieldType) {
        ArrayList<String> fieldDataList = new ArrayList<String>();
        if (builder instanceof WithFieldName) {
            String fieldType;
            String fieldName = ((WithFieldName)builder).fieldName();
            if (showFieldName.booleanValue()) {
                fieldDataList.add(fieldName);
            }
            if (showFieldType.booleanValue() && (fieldType = this.getFieldType(fieldName, propertiesAsMap, index)) != null && !fieldType.isEmpty()) {
                fieldDataList.add(fieldType);
            }
        }
        return " [" + String.join((CharSequence)", ", fieldDataList) + "]";
    }

    String getFieldType(String fieldName, Map<String, Object> propertiesAsMap, Index index) {
        if (propertiesAsMap == null || index == null) {
            return null;
        }
        String fieldType = this.getFieldTypeFromCache(fieldName, index);
        if (fieldType != null) {
            ++this.cacheHitCount;
            return fieldType;
        }
        ++this.cacheMissCount;
        fieldType = this.getFieldTypeFromProperties(fieldName, propertiesAsMap);
        String string = fieldType = fieldType != null ? fieldType : EMPTY_STRING;
        if (this.indicesFieldTypeCache.getOrInitialize(index).putIfAbsent(fieldName, fieldType)) {
            this.indicesFieldTypeCache.incrementCountAndWeight(fieldName, fieldType);
        }
        return fieldType;
    }

    String getFieldTypeFromProperties(String fieldName, Map<String, Object> propertiesAsMap) {
        if (propertiesAsMap == null) {
            return null;
        }
        String[] fieldParts = fieldName.split("\\.");
        Map currentProperties = propertiesAsMap;
        for (int depth = 0; depth < fieldParts.length; ++depth) {
            Object currentMapping = currentProperties.get(fieldParts[depth]);
            if (currentMapping instanceof Map) {
                Map currentMap = (Map)currentMapping;
                if (currentMap.containsKey("properties")) {
                    currentProperties = (Map)currentMap.get("properties");
                    continue;
                }
                if (currentMap.containsKey("fields") && depth + 1 < fieldParts.length) {
                    currentProperties = (Map)currentMap.get("fields");
                    continue;
                }
                if (currentMap.containsKey("type")) {
                    return (String)currentMap.get("type");
                }
                return null;
            }
            return null;
        }
        return null;
    }

    String getFieldTypeFromCache(String fieldName, Index index) {
        return this.indicesFieldTypeCache.getOrInitialize(index).get(fieldName);
    }

    public Map<String, Long> getFieldTypeCacheStats() {
        return Map.of(SIZE_IN_BYTES, this.indicesFieldTypeCache.getWeight(), ENTRY_COUNT, this.indicesFieldTypeCache.getEntryCount(), EVICTIONS, this.indicesFieldTypeCache.getEvictionCount(), HIT_COUNT, this.cacheHitCount, MISS_COUNT, this.cacheMissCount);
    }
}

