/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.core.utils;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.admin.cluster.state.ClusterStateRequest;
import org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.core.action.ActionListener;
import org.opensearch.plugin.insights.core.metrics.OperationalMetric;
import org.opensearch.plugin.insights.core.metrics.OperationalMetricsCounter;
import org.opensearch.plugin.insights.core.utils.ExporterReaderUtils;
import org.opensearch.transport.client.Client;

public final class IndexDiscoveryHelper {
    private static final Logger logger = LogManager.getLogger(IndexDiscoveryHelper.class);

    private IndexDiscoveryHelper() {
    }

    public static void discoverIndicesInDateRange(Client client, final DateTimeFormatter indexPattern, final ZonedDateTime start, final ZonedDateTime end, final ActionListener<List<String>> callback) {
        ClusterStateRequest clusterStateRequest = IndexDiscoveryHelper.createClusterStateRequest();
        client.admin().cluster().state(clusterStateRequest, (ActionListener)new ActionListener<ClusterStateResponse>(){

            public void onResponse(ClusterStateResponse clusterStateResponse) {
                try {
                    Set<String> existingIndices = clusterStateResponse.getState().metadata().indices().keySet();
                    List<String> indexNames = IndexDiscoveryHelper.findIndicesInDateRange(existingIndices, indexPattern, start, end);
                    callback.onResponse(indexNames);
                }
                catch (Exception e) {
                    logger.error("Error processing cluster state response for index discovery: ", (Throwable)e);
                    OperationalMetricsCounter.getInstance().incrementCounter(OperationalMetric.LOCAL_INDEX_READER_SEARCH_EXCEPTIONS);
                    callback.onFailure(e);
                }
            }

            public void onFailure(Exception e) {
                OperationalMetricsCounter.getInstance().incrementCounter(OperationalMetric.LOCAL_INDEX_READER_SEARCH_EXCEPTIONS);
                logger.error("Failed to get cluster state for indices matching {}: ", (Object)"top_queries-*", (Object)e);
                callback.onFailure(e);
            }
        });
    }

    private static ClusterStateRequest createClusterStateRequest() {
        return IndexDiscoveryHelper.createClusterStateRequest(IndicesOptions.lenientExpandOpen());
    }

    public static ClusterStateRequest createClusterStateRequest(IndicesOptions indicesOptions) {
        return ((ClusterStateRequest)new ClusterStateRequest().clear().indices(new String[]{"top_queries-*"}).metadata(true).local(true)).indicesOptions(indicesOptions);
    }

    static List<String> findIndicesInDateRange(Set<String> existingIndices, DateTimeFormatter indexPattern, ZonedDateTime start, ZonedDateTime end) {
        ArrayList<String> indexNames = new ArrayList<String>();
        ZonedDateTime currentDay = start.toLocalDate().atStartOfDay(start.getZone());
        ZonedDateTime endDay = end.toLocalDate().atStartOfDay(end.getZone());
        while (!currentDay.isAfter(endDay)) {
            String potentialIndexName = IndexDiscoveryHelper.buildLocalIndexName(indexPattern, currentDay);
            if (existingIndices.contains(potentialIndexName)) {
                indexNames.add(potentialIndexName);
            }
            currentDay = currentDay.plusDays(1L);
        }
        return indexNames;
    }

    public static String buildLocalIndexName(DateTimeFormatter indexPattern, ZonedDateTime date) {
        return indexPattern.format(date) + "-" + ExporterReaderUtils.generateLocalIndexDateHash(date.toLocalDate());
    }
}

