/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.ranker.ranklib;

import com.o19s.es.ltr.ranker.LtrRanker;
import com.o19s.es.ltr.ranker.parser.LtrRankerParserFactory;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opensearch.script.ScriptContext;
import org.opensearch.script.ScriptEngine;

public class RankLibScriptEngine
implements ScriptEngine {
    public static final String NAME = "ranklib";
    public static final String EXTENSION = "ranklib";
    public static final ScriptContext<RankLibModelContainer.Factory> CONTEXT = new ScriptContext("ranklib", RankLibModelContainer.Factory.class);
    private final LtrRankerParserFactory factory;

    public RankLibScriptEngine(LtrRankerParserFactory factory) {
        this.factory = Objects.requireNonNull(factory);
    }

    public String getType() {
        return "ranklib";
    }

    public <T> T compile(String scriptName, String scriptSource, ScriptContext<T> context, Map<String, String> params) {
        RankLibModelContainer.Factory retFactory = () -> {
            LtrRanker ltrRanker = this.factory.getParser("model/ranklib").parse(null, scriptSource);
            return new RankLibModelContainer(ltrRanker);
        };
        return context.factoryClazz.cast(retFactory);
    }

    public void close() throws IOException {
    }

    public Set<ScriptContext<?>> getSupportedContexts() {
        return Collections.singleton(CONTEXT);
    }

    public static class RankLibModelContainer {
        LtrRanker _ranker;

        public RankLibModelContainer(LtrRanker ranker) {
            this._ranker = ranker;
        }

        public void setNextVar(String name, Object value) {
            this._ranker = (LtrRanker)value;
        }

        public Object run() {
            return this._ranker;
        }

        public void execute() {
        }

        public static interface Factory {
            public RankLibModelContainer newInstance();
        }
    }
}

