/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.LongToIntFunction;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesSkipper;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.DocIdStream;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.CollectionUtil;
import org.opensearch.common.Rounding;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.util.IntArray;
import org.opensearch.common.util.LongArray;
import org.opensearch.core.common.util.ByteArray;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.BucketOrder;
import org.opensearch.search.aggregations.CardinalityUpperBound;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.bucket.DeferableBucketAggregator;
import org.opensearch.search.aggregations.bucket.DeferringBucketCollector;
import org.opensearch.search.aggregations.bucket.HistogramSkiplistLeafCollector;
import org.opensearch.search.aggregations.bucket.MergingBucketsDeferringCollector;
import org.opensearch.search.aggregations.bucket.filterrewrite.DateHistogramAggregatorBridge;
import org.opensearch.search.aggregations.bucket.filterrewrite.FilterRewriteOptimizationContext;
import org.opensearch.search.aggregations.bucket.histogram.AutoDateHistogramAggregationBuilder;
import org.opensearch.search.aggregations.bucket.histogram.InternalAutoDateHistogram;
import org.opensearch.search.aggregations.bucket.terms.LongKeyedBucketOrds;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.internal.SearchContext;

abstract class AutoDateHistogramAggregator
extends DeferableBucketAggregator {
    private final ValuesSource.Numeric valuesSource;
    private final DocValueFormat formatter;
    private final Function<Rounding, Rounding.Prepared> roundingPreparer;
    private MergingBucketsDeferringCollector deferringCollector;
    protected final AutoDateHistogramAggregationBuilder.RoundingInfo[] roundingInfos;
    protected final int targetBuckets;
    protected int roundingIdx;
    protected Rounding.Prepared preparedRounding;
    private final String fieldName;
    private final FilterRewriteOptimizationContext filterRewriteOptimizationContext;

    static AutoDateHistogramAggregator build(String name, AggregatorFactories factories, int targetBuckets, AutoDateHistogramAggregationBuilder.RoundingInfo[] roundingInfos, Function<Rounding, Rounding.Prepared> roundingPreparer, ValuesSourceConfig valuesSourceConfig, SearchContext aggregationContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return cardinality == CardinalityUpperBound.ONE ? new FromSingle(name, factories, targetBuckets, roundingInfos, roundingPreparer, valuesSourceConfig, aggregationContext, parent, metadata) : new FromMany(name, factories, targetBuckets, roundingInfos, roundingPreparer, valuesSourceConfig, aggregationContext, parent, metadata);
    }

    private AutoDateHistogramAggregator(String name, AggregatorFactories factories, final int targetBuckets, final AutoDateHistogramAggregationBuilder.RoundingInfo[] roundingInfos, Function<Rounding, Rounding.Prepared> roundingPreparer, final ValuesSourceConfig valuesSourceConfig, SearchContext aggregationContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, factories, aggregationContext, parent, metadata);
        this.targetBuckets = targetBuckets;
        this.valuesSource = valuesSourceConfig.hasValues() ? (ValuesSource.Numeric)valuesSourceConfig.getValuesSource() : null;
        this.formatter = valuesSourceConfig.format();
        this.roundingInfos = roundingInfos;
        this.roundingPreparer = roundingPreparer;
        this.preparedRounding = this.prepareRounding(0);
        this.fieldName = this.valuesSource instanceof ValuesSource.Numeric.FieldData ? ((ValuesSource.Numeric.FieldData)this.valuesSource).getIndexFieldName() : null;
        DateHistogramAggregatorBridge bridge = new DateHistogramAggregatorBridge(this){
            final /* synthetic */ AutoDateHistogramAggregator this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected boolean canOptimize() {
                return this.canOptimize(valuesSourceConfig, roundingInfos[0].rounding);
            }

            @Override
            protected void prepare() throws IOException {
                this.buildRanges(this.this$0.context);
            }

            @Override
            protected Rounding getRounding(long low, long high) {
                long bestDuration = (high - low) / (long)targetBuckets;
                int prevRoundingIdx = this.this$0.roundingIdx;
                this.this$0.roundingIdx = 0;
                while (this.this$0.roundingIdx < roundingInfos.length - 1) {
                    AutoDateHistogramAggregationBuilder.RoundingInfo curRoundingInfo = roundingInfos[this.this$0.roundingIdx];
                    int temp = curRoundingInfo.innerIntervals[curRoundingInfo.innerIntervals.length - 1];
                    if (bestDuration <= (long)temp * curRoundingInfo.roughEstimateDurationMillis) break;
                    ++this.this$0.roundingIdx;
                }
                if (this.this$0.roundingIdx > prevRoundingIdx) {
                    this.this$0.preparedRounding = this.this$0.prepareRounding(this.this$0.roundingIdx);
                }
                return roundingInfos[this.this$0.roundingIdx].rounding;
            }

            @Override
            protected Rounding.Prepared getRoundingPrepared() {
                return this.this$0.preparedRounding;
            }

            @Override
            protected Function<Long, Long> bucketOrdProducer() {
                return key -> this.this$0.getBucketOrds().add(0L, this.this$0.preparedRounding.round((long)key));
            }
        };
        this.filterRewriteOptimizationContext = new FilterRewriteOptimizationContext(bridge, parent, this.subAggregators.length, this.context);
    }

    protected abstract LongKeyedBucketOrds getBucketOrds();

    @Override
    public final ScoreMode scoreMode() {
        if (this.valuesSource != null && this.valuesSource.needsScores()) {
            return ScoreMode.COMPLETE;
        }
        return super.scoreMode();
    }

    @Override
    protected final boolean shouldDefer(Aggregator aggregator) {
        return true;
    }

    @Override
    public final DeferringBucketCollector getDeferringCollector() {
        this.deferringCollector = new MergingBucketsDeferringCollector(this.context, AutoDateHistogramAggregator.descendsFromGlobalAggregator(this.parent()));
        return this.deferringCollector;
    }

    protected abstract LeafBucketCollector getLeafCollector(SortedNumericDocValues var1, DocValuesSkipper var2, LeafBucketCollector var3) throws IOException;

    @Override
    protected boolean tryPrecomputeAggregationForLeaf(LeafReaderContext ctx) throws IOException {
        return this.filterRewriteOptimizationContext.tryOptimize(ctx, this::incrementBucketDocCount, DateHistogramAggregatorBridge.segmentMatchAll(this.context, ctx), this.collectableSubAggregators);
    }

    @Override
    public final LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        SortedNumericDocValues values = this.valuesSource.longValues(ctx);
        DocValuesSkipper skipper = null;
        if (this.fieldName != null) {
            skipper = ctx.reader().getDocValuesSkipper(this.fieldName);
        }
        return this.getLeafCollector(values, skipper, sub);
    }

    protected final InternalAggregation[] buildAggregations(LongKeyedBucketOrds bucketOrds, LongToIntFunction roundingIndexFor, long[] owningBucketOrds) throws IOException {
        return this.buildAggregationsForVariableBuckets(owningBucketOrds, bucketOrds, (bucketValue, docCount, subAggregationResults) -> new InternalAutoDateHistogram.Bucket(bucketValue, docCount, this.formatter, subAggregationResults), (owningBucketOrd, buckets) -> {
            this.checkCancelled();
            CollectionUtil.introSort((List)buckets, BucketOrder.key(true).comparator());
            InternalAutoDateHistogram.BucketInfo emptyBucketInfo = new InternalAutoDateHistogram.BucketInfo(this.roundingInfos, roundingIndexFor.applyAsInt(owningBucketOrd), this.buildEmptySubAggregations());
            return new InternalAutoDateHistogram(this.name, buckets, this.targetBuckets, emptyBucketInfo, this.formatter, this.metadata(), 1L);
        });
    }

    @Override
    public final InternalAggregation buildEmptyAggregation() {
        InternalAutoDateHistogram.BucketInfo emptyBucketInfo = new InternalAutoDateHistogram.BucketInfo(this.roundingInfos, 0, this.buildEmptySubAggregations());
        return new InternalAutoDateHistogram(this.name, Collections.emptyList(), this.targetBuckets, emptyBucketInfo, this.formatter, this.metadata(), 1L);
    }

    protected final Rounding.Prepared prepareRounding(int index) {
        return this.roundingPreparer.apply(this.roundingInfos[index].rounding);
    }

    protected final void merge(long[] mergeMap, long newNumBuckets) {
        this.mergeBuckets(mergeMap, newNumBuckets);
        if (this.deferringCollector != null) {
            this.deferringCollector.mergeBuckets(mergeMap);
        }
    }

    @Override
    public void collectDebugInfo(BiConsumer<String, Object> add) {
        super.collectDebugInfo(add);
        this.filterRewriteOptimizationContext.populateDebugInfo(add);
    }

    private static class FromSingle
    extends AutoDateHistogramAggregator {
        private LongKeyedBucketOrds.FromSingle bucketOrds;
        private long min = Long.MAX_VALUE;
        private long max = Long.MIN_VALUE;
        private int skiplistCollectorCount = 0;

        FromSingle(String name, AggregatorFactories factories, int targetBuckets, AutoDateHistogramAggregationBuilder.RoundingInfo[] roundingInfos, Function<Rounding, Rounding.Prepared> roundingPreparer, ValuesSourceConfig valuesSourceConfig, SearchContext aggregationContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
            super(name, factories, targetBuckets, roundingInfos, roundingPreparer, valuesSourceConfig, aggregationContext, parent, metadata);
            this.bucketOrds = new LongKeyedBucketOrds.FromSingle(this.context.bigArrays());
        }

        @Override
        protected LongKeyedBucketOrds getBucketOrds() {
            return this.bucketOrds;
        }

        @Override
        protected LeafBucketCollector getLeafCollector(final SortedNumericDocValues values, DocValuesSkipper skipper, final LeafBucketCollector sub) throws IOException {
            NumericDocValues singleton = DocValues.unwrapSingleton((SortedNumericDocValues)values);
            if (HistogramSkiplistLeafCollector.canUseSkiplist(null, this.parent, skipper, singleton)) {
                ++this.skiplistCollectorCount;
                return new HistogramSkiplistLeafCollector(singleton, skipper, owningBucketOrd -> this.preparedRounding, () -> this.bucketOrds, sub, this, (owningBucket, rounded) -> this.increaseRoundingIfNeeded(rounded));
            }
            return new LeafBucketCollectorBase(this, sub, values){
                final /* synthetic */ FromSingle this$0;
                {
                    this.this$0 = this$0;
                    super(sub2, values2);
                }

                @Override
                public void collect(int doc, long owningBucketOrd) throws IOException {
                    assert (owningBucketOrd == 0L);
                    if (!values.advanceExact(doc)) {
                        return;
                    }
                    int valuesCount = values.docValueCount();
                    long previousRounded = Long.MIN_VALUE;
                    for (int i = 0; i < valuesCount; ++i) {
                        long value = values.nextValue();
                        long rounded = this.this$0.preparedRounding.round(value);
                        assert (rounded >= previousRounded);
                        if (rounded == previousRounded) continue;
                        this.collectValue(doc, rounded);
                        previousRounded = rounded;
                    }
                }

                @Override
                public void collect(DocIdStream stream, long owningBucketOrd) throws IOException {
                    super.collect(stream, owningBucketOrd);
                }

                @Override
                public void collectRange(int min, int max) throws IOException {
                    super.collectRange(min, max);
                }

                private void collectValue(int doc, long rounded) throws IOException {
                    long bucketOrd = this.this$0.bucketOrds.add(0L, rounded);
                    if (bucketOrd < 0L) {
                        bucketOrd = -1L - bucketOrd;
                        this.this$0.collectExistingBucket(sub, doc, bucketOrd);
                        return;
                    }
                    this.this$0.collectBucket(sub, doc, bucketOrd);
                    this.this$0.increaseRoundingIfNeeded(rounded);
                }
            };
        }

        private void increaseRoundingIfNeeded(long rounded) {
            if (this.roundingIdx >= this.roundingInfos.length - 1) {
                return;
            }
            this.min = Math.min(this.min, rounded);
            this.max = Math.max(this.max, rounded);
            if (this.bucketOrds.size() <= (long)(this.targetBuckets * this.roundingInfos[this.roundingIdx].getMaximumInnerInterval()) && this.max - this.min <= (long)this.targetBuckets * this.roundingInfos[this.roundingIdx].getMaximumRoughEstimateDurationMillis()) {
                return;
            }
            do {
                try (LongKeyedBucketOrds.FromSingle oldOrds = this.bucketOrds;){
                    this.preparedRounding = this.prepareRounding(++this.roundingIdx);
                    long[] mergeMap = new long[Math.toIntExact(((LongKeyedBucketOrds)oldOrds).size())];
                    this.bucketOrds = new LongKeyedBucketOrds.FromSingle(this.context.bigArrays());
                    LongKeyedBucketOrds.BucketOrdsEnum ordsEnum = ((LongKeyedBucketOrds)oldOrds).ordsEnum(0L);
                    while (ordsEnum.next()) {
                        long oldKey = ordsEnum.value();
                        long newKey = this.preparedRounding.round(oldKey);
                        long newBucketOrd = this.bucketOrds.add(0L, newKey);
                        mergeMap[(int)ordsEnum.ord()] = newBucketOrd >= 0L ? newBucketOrd : -1L - newBucketOrd;
                    }
                    this.merge(mergeMap, this.bucketOrds.size());
                }
            } while (this.roundingIdx < this.roundingInfos.length - 1 && (this.bucketOrds.size() > (long)(this.targetBuckets * this.roundingInfos[this.roundingIdx].getMaximumInnerInterval()) || this.max - this.min > (long)this.targetBuckets * this.roundingInfos[this.roundingIdx].getMaximumRoughEstimateDurationMillis()));
        }

        @Override
        public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
            return this.buildAggregations(this.bucketOrds, l -> this.roundingIdx, owningBucketOrds);
        }

        @Override
        public void collectDebugInfo(BiConsumer<String, Object> add) {
            super.collectDebugInfo(add);
            add.accept("surviving_buckets", this.bucketOrds.size());
            add.accept("skiplist_collectors_used", this.skiplistCollectorCount);
        }

        @Override
        protected void doClose() {
            Releasables.close((Releasable)this.bucketOrds);
        }
    }

    private static class FromMany
    extends AutoDateHistogramAggregator {
        private final Rounding.Prepared[] preparedRoundings;
        private LongKeyedBucketOrds.FromMany bucketOrds;
        private ByteArray roundingIndices;
        private LongArray mins;
        private LongArray maxes;
        private IntArray liveBucketCountUnderestimate;
        private long wastedBucketsOverestimate = 0L;
        private long nextRebucketAt = 1000L;
        private int rebucketCount = 0;
        private int skiplistCollectorCount = 0;

        FromMany(String name, AggregatorFactories factories, int targetBuckets, AutoDateHistogramAggregationBuilder.RoundingInfo[] roundingInfos, Function<Rounding, Rounding.Prepared> roundingPreparer, ValuesSourceConfig valuesSourceConfig, SearchContext aggregationContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
            super(name, factories, targetBuckets, roundingInfos, roundingPreparer, valuesSourceConfig, aggregationContext, parent, metadata);
            assert (roundingInfos.length < 127) : "Rounding must fit in a signed byte";
            this.roundingIndices = this.context.bigArrays().newByteArray(1L, true);
            this.mins = this.context.bigArrays().newLongArray(1L, false);
            this.mins.set(0L, Long.MAX_VALUE);
            this.maxes = this.context.bigArrays().newLongArray(1L, false);
            this.maxes.set(0L, Long.MIN_VALUE);
            this.preparedRoundings = new Rounding.Prepared[roundingInfos.length];
            this.preparedRoundings[0] = roundingPreparer.apply(roundingInfos[0].rounding);
            this.bucketOrds = new LongKeyedBucketOrds.FromMany(this.context.bigArrays());
            this.liveBucketCountUnderestimate = this.context.bigArrays().newIntArray(1L, true);
        }

        @Override
        protected LongKeyedBucketOrds getBucketOrds() {
            return this.bucketOrds;
        }

        @Override
        protected LeafBucketCollector getLeafCollector(final SortedNumericDocValues values, DocValuesSkipper skipper, final LeafBucketCollector sub) throws IOException {
            NumericDocValues singleton = DocValues.unwrapSingleton((SortedNumericDocValues)values);
            if (HistogramSkiplistLeafCollector.canUseSkiplist(null, this.parent, skipper, singleton)) {
                ++this.skiplistCollectorCount;
                return new HistogramSkiplistLeafCollector(singleton, skipper, owningBucketOrd -> this.preparedRoundings[this.roundingIndexFor(owningBucketOrd)], () -> this.bucketOrds, sub, this, (owningBucketOrd, rounded) -> {
                    int roundingIdx = this.roundingIndexFor(owningBucketOrd);
                    this.liveBucketCountUnderestimate = this.context.bigArrays().grow(this.liveBucketCountUnderestimate, owningBucketOrd + 1L);
                    int estimatedBucketCount = this.liveBucketCountUnderestimate.increment(owningBucketOrd, 1);
                    this.increaseRoundingIfNeeded(owningBucketOrd, estimatedBucketCount, rounded, roundingIdx);
                });
            }
            return new LeafBucketCollectorBase(this, sub, values){
                final /* synthetic */ FromMany this$0;
                {
                    this.this$0 = this$0;
                    super(sub2, values2);
                }

                @Override
                public void collect(int doc, long owningBucketOrd) throws IOException {
                    if (!values.advanceExact(doc)) {
                        return;
                    }
                    int valuesCount = values.docValueCount();
                    long previousRounded = Long.MIN_VALUE;
                    int roundingIdx = this.this$0.roundingIndexFor(owningBucketOrd);
                    for (int i = 0; i < valuesCount; ++i) {
                        long value = values.nextValue();
                        long rounded = this.this$0.preparedRoundings[roundingIdx].round(value);
                        assert (rounded >= previousRounded);
                        if (rounded == previousRounded) continue;
                        roundingIdx = this.collectValue(owningBucketOrd, roundingIdx, doc, rounded);
                        previousRounded = rounded;
                    }
                }

                @Override
                public void collect(DocIdStream stream, long owningBucketOrd) throws IOException {
                    super.collect(stream, owningBucketOrd);
                }

                @Override
                public void collectRange(int min, int max) throws IOException {
                    super.collectRange(min, max);
                }

                private int collectValue(long owningBucketOrd, int roundingIdx, int doc, long rounded) throws IOException {
                    long bucketOrd = this.this$0.bucketOrds.add(owningBucketOrd, rounded);
                    if (bucketOrd < 0L) {
                        bucketOrd = -1L - bucketOrd;
                        this.this$0.collectExistingBucket(sub, doc, bucketOrd);
                        return roundingIdx;
                    }
                    this.this$0.collectBucket(sub, doc, bucketOrd);
                    this.this$0.liveBucketCountUnderestimate = this.this$0.context.bigArrays().grow(this.this$0.liveBucketCountUnderestimate, owningBucketOrd + 1L);
                    int estimatedBucketCount = this.this$0.liveBucketCountUnderestimate.increment(owningBucketOrd, 1);
                    return this.this$0.increaseRoundingIfNeeded(owningBucketOrd, estimatedBucketCount, rounded, roundingIdx);
                }
            };
        }

        private int increaseRoundingIfNeeded(long owningBucketOrd, int oldEstimatedBucketCount, long newKey, int oldRounding) {
            int newEstimatedBucketCount;
            long oldSize;
            if (oldRounding >= this.roundingInfos.length - 1) {
                return oldRounding;
            }
            if (this.mins.size() < owningBucketOrd + 1L) {
                oldSize = this.mins.size();
                this.mins = this.context.bigArrays().grow(this.mins, owningBucketOrd + 1L);
                this.mins.fill(oldSize, this.mins.size(), Long.MAX_VALUE);
            }
            if (this.maxes.size() < owningBucketOrd + 1L) {
                oldSize = this.maxes.size();
                this.maxes = this.context.bigArrays().grow(this.maxes, owningBucketOrd + 1L);
                this.maxes.fill(oldSize, this.maxes.size(), Long.MIN_VALUE);
            }
            long min = Math.min(this.mins.get(owningBucketOrd), newKey);
            this.mins.set(owningBucketOrd, min);
            long max = Math.max(this.maxes.get(owningBucketOrd), newKey);
            this.maxes.set(owningBucketOrd, max);
            if (oldEstimatedBucketCount <= this.targetBuckets * this.roundingInfos[oldRounding].getMaximumInnerInterval() && max - min <= (long)this.targetBuckets * this.roundingInfos[oldRounding].getMaximumRoughEstimateDurationMillis()) {
                return oldRounding;
            }
            long oldRoughDuration = this.roundingInfos[oldRounding].roughEstimateDurationMillis;
            int newRounding = oldRounding;
            do {
                double ratio = (double)oldRoughDuration / (double)this.roundingInfos[++newRounding].getRoughEstimateDurationMillis();
                newEstimatedBucketCount = (int)Math.ceil((double)oldEstimatedBucketCount * ratio);
            } while (newRounding < this.roundingInfos.length - 1 && (newEstimatedBucketCount > this.targetBuckets * this.roundingInfos[newRounding].getMaximumInnerInterval() || max - min > (long)this.targetBuckets * this.roundingInfos[newRounding].getMaximumRoughEstimateDurationMillis()));
            this.setRounding(owningBucketOrd, newRounding);
            this.mins.set(owningBucketOrd, this.preparedRoundings[newRounding].round(this.mins.get(owningBucketOrd)));
            this.maxes.set(owningBucketOrd, this.preparedRoundings[newRounding].round(this.maxes.get(owningBucketOrd)));
            this.wastedBucketsOverestimate += (long)(oldEstimatedBucketCount - newEstimatedBucketCount);
            if (this.wastedBucketsOverestimate > this.nextRebucketAt) {
                this.rebucket();
                this.wastedBucketsOverestimate = 0L;
                this.nextRebucketAt *= 2L;
            } else {
                this.liveBucketCountUnderestimate.set(owningBucketOrd, newEstimatedBucketCount);
            }
            return newRounding;
        }

        private void rebucket() {
            ++this.rebucketCount;
            try (LongKeyedBucketOrds.FromMany oldOrds = this.bucketOrds;){
                this.checkCancelled();
                long[] mergeMap = new long[Math.toIntExact(((LongKeyedBucketOrds)oldOrds).size())];
                this.bucketOrds = new LongKeyedBucketOrds.FromMany(this.context.bigArrays());
                for (long owningBucketOrd = 0L; owningBucketOrd <= ((LongKeyedBucketOrds)oldOrds).maxOwningBucketOrd(); ++owningBucketOrd) {
                    LongKeyedBucketOrds.BucketOrdsEnum ordsEnum = ((LongKeyedBucketOrds)oldOrds).ordsEnum(owningBucketOrd);
                    Rounding.Prepared preparedRounding = this.preparedRoundings[this.roundingIndexFor(owningBucketOrd)];
                    while (ordsEnum.next()) {
                        long oldKey = ordsEnum.value();
                        long newKey = preparedRounding.round(oldKey);
                        long newBucketOrd = this.bucketOrds.add(owningBucketOrd, newKey);
                        mergeMap[(int)ordsEnum.ord()] = newBucketOrd >= 0L ? newBucketOrd : -1L - newBucketOrd;
                    }
                    this.liveBucketCountUnderestimate = this.context.bigArrays().grow(this.liveBucketCountUnderestimate, owningBucketOrd + 1L);
                    this.liveBucketCountUnderestimate.set(owningBucketOrd, Math.toIntExact(this.bucketOrds.bucketsInOrd(owningBucketOrd)));
                }
                this.merge(mergeMap, this.bucketOrds.size());
            }
        }

        @Override
        public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
            this.rebucket();
            return this.buildAggregations(this.bucketOrds, this::roundingIndexFor, owningBucketOrds);
        }

        @Override
        public void collectDebugInfo(BiConsumer<String, Object> add) {
            super.collectDebugInfo(add);
            add.accept("surviving_buckets", this.bucketOrds.size());
            add.accept("wasted_buckets_overestimate", this.wastedBucketsOverestimate);
            add.accept("next_rebucket_at", this.nextRebucketAt);
            add.accept("rebucket_count", this.rebucketCount);
            add.accept("skiplist_collectors_used", this.skiplistCollectorCount);
        }

        private void setRounding(long owningBucketOrd, int newRounding) {
            this.roundingIndices = this.context.bigArrays().grow(this.roundingIndices, owningBucketOrd + 1L);
            this.roundingIndices.set(owningBucketOrd, (byte)newRounding);
            if (this.preparedRoundings[newRounding] == null) {
                this.preparedRoundings[newRounding] = this.prepareRounding(newRounding);
            }
        }

        private int roundingIndexFor(long owningBucketOrd) {
            return owningBucketOrd < this.roundingIndices.size() ? (int)this.roundingIndices.get(owningBucketOrd) : 0;
        }

        @Override
        public void doClose() {
            Releasables.close((Releasable[])new Releasable[]{this.bucketOrds, this.roundingIndices, this.mins, this.maxes, this.liveBucketCountUnderestimate});
        }
    }
}

