/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.util.BytesRefHash;
import org.opensearch.common.util.SetBackedScalingCuckooFilter;
import org.opensearch.index.fielddata.SortedBinaryDocValues;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.CardinalityUpperBound;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.bucket.terms.AbstractRareTermsAggregator;
import org.opensearch.search.aggregations.bucket.terms.BytesKeyedBucketOrds;
import org.opensearch.search.aggregations.bucket.terms.IncludeExclude;
import org.opensearch.search.aggregations.bucket.terms.LongRareTermsAggregator;
import org.opensearch.search.aggregations.bucket.terms.StringRareTerms;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.internal.SearchContext;

public class StringRareTermsAggregator
extends AbstractRareTermsAggregator {
    private final ValuesSource.Bytes valuesSource;
    private final IncludeExclude.StringFilter filter;
    private Weight weight;
    private final BytesKeyedBucketOrds bucketOrds;
    protected final String fieldName;
    private final ValuesSourceConfig config;

    StringRareTermsAggregator(String name, AggregatorFactories factories, ValuesSource.Bytes valuesSource, DocValueFormat format, IncludeExclude.StringFilter filter, SearchContext context, Aggregator parent, Map<String, Object> metadata, long maxDocCount, double precision, CardinalityUpperBound cardinality, ValuesSourceConfig config) throws IOException {
        super(name, factories, context, parent, metadata, maxDocCount, precision, format);
        this.valuesSource = valuesSource;
        this.filter = filter;
        this.bucketOrds = BytesKeyedBucketOrds.build(context.bigArrays(), cardinality);
        this.fieldName = valuesSource.getIndexFieldName();
        this.config = config;
    }

    public void setWeight(Weight weight) {
        this.weight = weight;
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        final SortedBinaryDocValues values = this.valuesSource.bytesValues(ctx);
        return new LeafBucketCollectorBase(this, sub, values){
            final BytesRefBuilder previous;
            final /* synthetic */ StringRareTermsAggregator this$0;
            {
                this.this$0 = this$0;
                super(sub2, values2);
                this.previous = new BytesRefBuilder();
            }

            @Override
            public void collect(int docId, long owningBucketOrd) throws IOException {
                if (!values.advanceExact(docId)) {
                    return;
                }
                int valuesCount = values.docValueCount();
                this.previous.clear();
                for (int i = 0; i < valuesCount; ++i) {
                    BytesRef bytes = values.nextValue();
                    if (this.this$0.filter != null && !this.this$0.filter.accept(bytes) || i > 0 && this.previous.get().equals((Object)bytes)) continue;
                    this.previous.copyBytes(bytes);
                    long bucketOrdinal = this.this$0.bucketOrds.add(owningBucketOrd, bytes);
                    if (bucketOrdinal < 0L) {
                        bucketOrdinal = -1L - bucketOrdinal;
                        this.this$0.collectExistingBucket(sub, docId, bucketOrdinal);
                        continue;
                    }
                    this.this$0.collectBucket(sub, docId, bucketOrdinal);
                }
            }
        };
    }

    @Override
    protected boolean tryPrecomputeAggregationForLeaf(LeafReaderContext ctx) throws IOException {
        if (this.weight == null) {
            return false;
        }
        if (this.weight.count(ctx) == 0) {
            return true;
        }
        if (this.weight.count(ctx) != ctx.reader().maxDoc()) {
            return false;
        }
        if (this.subAggregators.length > 0) {
            return false;
        }
        Terms stringTerms = ctx.reader().terms(this.fieldName);
        if (stringTerms == null) {
            return false;
        }
        NumericDocValues docCountValues = DocValues.getNumeric((LeafReader)ctx.reader(), (String)"_doc_count");
        if (docCountValues.nextDoc() != Integer.MAX_VALUE) {
            return false;
        }
        TermsEnum stringTermsEnum = stringTerms.iterator();
        BytesRef stringTerm = stringTermsEnum.next();
        if (this.config != null && this.config.missing() != null) {
            String missingField = (String)this.config.missing();
            BytesRef missingFieldTerm = new BytesRef((CharSequence)missingField);
            int missingCount = this.weight.count(ctx) - ctx.reader().getDocCount(this.fieldName);
            if (missingCount > 0) {
                long bucketOrdinal = this.bucketOrds.add(0L, missingFieldTerm);
                this.incrementBucketDocCount(bucketOrdinal, missingCount);
            }
        }
        while (stringTerm != null) {
            if (this.filter == null || this.filter.accept(stringTerm)) {
                long bucketOrdinal = this.bucketOrds.add(0L, stringTerm);
                if (bucketOrdinal < 0L) {
                    bucketOrdinal = -1L - bucketOrdinal;
                }
                this.incrementBucketDocCount(bucketOrdinal, stringTermsEnum.docFreq());
            }
            stringTerm = stringTermsEnum.next();
        }
        return true;
    }

    @Override
    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        StringRareTerms.Bucket[][] rarestPerOrd = new StringRareTerms.Bucket[owningBucketOrds.length][];
        SetBackedScalingCuckooFilter[] filters = new SetBackedScalingCuckooFilter[owningBucketOrds.length];
        long keepCount = 0L;
        long[] mergeMap = new long[(int)this.bucketOrds.size()];
        Arrays.fill(mergeMap, -1L);
        long offset = 0L;
        for (int owningOrdIdx = 0; owningOrdIdx < owningBucketOrds.length; ++owningOrdIdx) {
            try (BytesRefHash bucketsInThisOwningBucketToCollect = new BytesRefHash(this.context.bigArrays());){
                this.checkCancelled();
                filters[owningOrdIdx] = this.newFilter();
                ArrayList<StringRareTerms.Bucket> builtBuckets = new ArrayList<StringRareTerms.Bucket>();
                BytesKeyedBucketOrds.BucketOrdsEnum collectedBuckets = this.bucketOrds.ordsEnum(owningBucketOrds[owningOrdIdx]);
                BytesRef scratch = new BytesRef();
                while (collectedBuckets.next()) {
                    collectedBuckets.readValue(scratch);
                    long docCount = this.bucketDocCount(collectedBuckets.ord());
                    if (docCount <= this.maxDocCount) {
                        StringRareTerms.Bucket bucket = new StringRareTerms.Bucket(BytesRef.deepCopyOf((BytesRef)scratch), docCount, null, this.format);
                        mergeMap[(int)collectedBuckets.ord()] = bucket.bucketOrd = offset + bucketsInThisOwningBucketToCollect.add(scratch);
                        builtBuckets.add(bucket);
                        ++keepCount;
                        continue;
                    }
                    filters[owningOrdIdx].add(scratch);
                }
                rarestPerOrd[owningOrdIdx] = builtBuckets.toArray(new StringRareTerms.Bucket[0]);
                offset += bucketsInThisOwningBucketToCollect.size();
                continue;
            }
        }
        if (keepCount != (long)mergeMap.length) {
            this.mergeBuckets(mergeMap, offset);
            if (this.deferringCollector != null) {
                this.deferringCollector.mergeBuckets(mergeMap);
            }
        }
        this.buildSubAggsForAllBuckets(rarestPerOrd, b -> b.bucketOrd, (b, aggs) -> {
            b.aggregations = aggs;
        });
        InternalAggregation[] result = new InternalAggregation[owningBucketOrds.length];
        for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
            Arrays.sort(rarestPerOrd[ordIdx], ORDER.comparator());
            result[ordIdx] = new StringRareTerms(this.name, ORDER, this.metadata(), this.format, Arrays.asList(rarestPerOrd[ordIdx]), this.maxDocCount, filters[ordIdx]);
        }
        return result;
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new StringRareTerms(this.name, LongRareTermsAggregator.ORDER, this.metadata(), this.format, Collections.emptyList(), 0L, this.newFilter());
    }

    @Override
    public void doClose() {
        Releasables.close((Releasable)this.bucketOrds);
    }
}

