/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.model.threatintel;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentLocation;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.securityanalytics.model.threatintel.BaseEntity;
import org.opensearch.securityanalytics.model.threatintel.IocWithFeeds;

public class IocFinding
extends BaseEntity {
    public static final String ID_FIELD = "id";
    public static final String RELATED_DOC_IDS_FIELD = "related_doc_ids";
    public static final String IOC_WITH_FEED_IDS_FIELD = "ioc_feed_ids";
    public static final String MONITOR_ID_FIELD = "monitor_id";
    public static final String MONITOR_NAME_FIELD = "monitor_name";
    public static final String IOC_VALUE_FIELD = "ioc_value";
    public static final String IOC_TYPE_FIELD = "ioc_type";
    public static final String TIMESTAMP_FIELD = "timestamp";
    public static final String EXECUTION_ID_FIELD = "execution_id";
    private final String id;
    private final List<String> relatedDocIds;
    private final List<IocWithFeeds> iocWithFeeds;
    private final String monitorId;
    private final String monitorName;
    private final String iocValue;
    private final String iocType;
    private final Instant timestamp;
    private final String executionId;

    public IocFinding(String id, List<String> relatedDocIds, List<IocWithFeeds> iocWithFeeds, String monitorId, String monitorName, String iocValue, String iocType, Instant timestamp, String executionId) {
        IocFinding.validateIoCMatch(id, monitorId, monitorName, iocValue, timestamp, executionId, relatedDocIds);
        this.id = id;
        this.relatedDocIds = relatedDocIds;
        this.iocWithFeeds = iocWithFeeds;
        this.monitorId = monitorId;
        this.monitorName = monitorName;
        this.iocValue = iocValue;
        this.iocType = iocType;
        this.timestamp = timestamp;
        this.executionId = executionId;
    }

    public IocFinding(StreamInput in) throws IOException {
        this.id = in.readString();
        this.relatedDocIds = in.readStringList();
        this.iocWithFeeds = in.readList(IocWithFeeds::readFrom);
        this.monitorId = in.readString();
        this.monitorName = in.readString();
        this.iocValue = in.readString();
        this.iocType = in.readString();
        this.timestamp = in.readInstant();
        this.executionId = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeStringCollection(this.relatedDocIds);
        out.writeCollection(this.iocWithFeeds);
        out.writeString(this.monitorId);
        out.writeString(this.monitorName);
        out.writeString(this.iocValue);
        out.writeString(this.iocType);
        out.writeInstant(this.timestamp);
        out.writeOptionalString(this.executionId);
    }

    public Map<String, Object> asTemplateArg() {
        return Map.of(ID_FIELD, this.id, RELATED_DOC_IDS_FIELD, this.relatedDocIds, IOC_WITH_FEED_IDS_FIELD, this.iocWithFeeds.stream().map(IocWithFeeds::asTemplateArg).collect(Collectors.toList()), MONITOR_ID_FIELD, this.monitorId, MONITOR_NAME_FIELD, this.monitorName, IOC_VALUE_FIELD, this.iocValue, IOC_TYPE_FIELD, this.iocType, TIMESTAMP_FIELD, this.timestamp, EXECUTION_ID_FIELD, this.executionId);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field(ID_FIELD, this.id).field(RELATED_DOC_IDS_FIELD, this.relatedDocIds).field(IOC_WITH_FEED_IDS_FIELD, this.iocWithFeeds).field(MONITOR_ID_FIELD, this.monitorId).field(MONITOR_NAME_FIELD, this.monitorName).field(IOC_VALUE_FIELD, this.iocValue).field(IOC_TYPE_FIELD, this.iocType).field(TIMESTAMP_FIELD, this.timestamp.toEpochMilli()).field(EXECUTION_ID_FIELD, this.executionId).endObject();
        return builder;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public List<String> getRelatedDocIds() {
        return this.relatedDocIds;
    }

    public List<IocWithFeeds> getFeedIds() {
        return this.iocWithFeeds;
    }

    public String getMonitorId() {
        return this.monitorId;
    }

    public String getMonitorName() {
        return this.monitorName;
    }

    public String getIocValue() {
        return this.iocValue;
    }

    public String getIocType() {
        return this.iocType;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public static IocFinding parse(XContentParser xcp) throws IOException {
        String id = null;
        ArrayList<String> relatedDocIds = new ArrayList<String>();
        ArrayList<IocWithFeeds> feedIds = new ArrayList<IocWithFeeds>();
        String monitorId = null;
        String monitorName = null;
        String iocValue = null;
        String iocType = null;
        Instant timestamp = null;
        String executionId = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block24: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "id": {
                    id = xcp.text();
                    break;
                }
                case "related_doc_ids": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        relatedDocIds.add(xcp.text());
                    }
                    continue block24;
                }
                case "ioc_feed_ids": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        feedIds.add(IocWithFeeds.parse(xcp));
                    }
                    continue block24;
                }
                case "monitor_id": {
                    monitorId = xcp.textOrNull();
                    break;
                }
                case "monitor_name": {
                    monitorName = xcp.textOrNull();
                    break;
                }
                case "ioc_value": {
                    iocValue = xcp.textOrNull();
                    break;
                }
                case "ioc_type": {
                    iocType = xcp.textOrNull();
                    break;
                }
                case "timestamp": {
                    try {
                        if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) {
                            timestamp = null;
                            break;
                        }
                        if (xcp.currentToken().isValue()) {
                            timestamp = Instant.ofEpochMilli(xcp.longValue());
                            break;
                        }
                        XContentParserUtils.throwUnknownToken((XContentParser.Token)xcp.currentToken(), (XContentLocation)xcp.getTokenLocation());
                        timestamp = null;
                        break;
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("failed to parse timestamp in IoC Match object");
                    }
                }
                case "execution_id": {
                    executionId = xcp.textOrNull();
                    break;
                }
                default: {
                    xcp.skipChildren();
                }
            }
        }
        return new IocFinding(id, relatedDocIds, feedIds, monitorId, monitorName, iocValue, iocType, timestamp, executionId);
    }

    public static IocFinding readFrom(StreamInput in) throws IOException {
        return new IocFinding(in);
    }

    private static void validateIoCMatch(String id, String iocScanJobId, String iocScanName, String iocValue, Instant timestamp, String executionId, List<String> relatedDocIds) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("id cannot be empty in IoC_Match Object");
        }
        if (StringUtils.isBlank((CharSequence)iocValue)) {
            throw new IllegalArgumentException("ioc_value cannot be empty in IoC_Match Object");
        }
        if (StringUtils.isBlank((CharSequence)iocValue)) {
            throw new IllegalArgumentException("ioc_value cannot be empty in IoC_Match Object");
        }
        if (StringUtils.isBlank((CharSequence)iocScanJobId)) {
            throw new IllegalArgumentException("monitor_id cannot be empty in IoC_Match Object");
        }
        if (StringUtils.isBlank((CharSequence)iocScanName)) {
            throw new IllegalArgumentException("monitor_name cannot be empty in IoC_Match Object");
        }
        if (StringUtils.isBlank((CharSequence)executionId)) {
            throw new IllegalArgumentException("execution_id cannot be empty in IoC_Match Object");
        }
        if (timestamp == null) {
            throw new IllegalArgumentException("timestamp cannot be null in IoC_Match Object");
        }
        if (relatedDocIds == null || relatedDocIds.isEmpty()) {
            throw new IllegalArgumentException("related_doc_ids cannot be null or empty in IoC_Match Object");
        }
    }
}

