/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.rules.modifiers;

import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.securityanalytics.rules.exceptions.SigmaRegularExpressionError;
import org.opensearch.securityanalytics.rules.modifiers.SigmaModifier;
import org.opensearch.securityanalytics.rules.modifiers.SigmaValueModifier;
import org.opensearch.securityanalytics.rules.objects.SigmaDetectionItem;
import org.opensearch.securityanalytics.rules.types.SigmaRegularExpression;
import org.opensearch.securityanalytics.rules.types.SigmaString;
import org.opensearch.securityanalytics.rules.types.SigmaType;
import org.opensearch.securityanalytics.rules.utils.AnyOneOf;
import org.opensearch.securityanalytics.rules.utils.Either;

public class SigmaContainsModifier
extends SigmaValueModifier {
    public SigmaContainsModifier(SigmaDetectionItem detectionItem, List<Class<? extends SigmaModifier>> appliedModifiers) {
        super(detectionItem, appliedModifiers);
    }

    @Override
    public Pair<Class<?>, Class<?>> getTypeHints() {
        return Pair.of(SigmaString.class, SigmaRegularExpression.class);
    }

    @Override
    public Either<SigmaType, List<SigmaType>> modify(Either<SigmaType, List<SigmaType>> val) throws SigmaRegularExpressionError {
        if (val.isLeft() && val.getLeft() instanceof SigmaString) {
            SigmaString value = (SigmaString)val.getLeft();
            if (!value.startsWith(Either.right(Character.valueOf('*')))) {
                value.prepend(AnyOneOf.middleVal(Character.valueOf('*')));
            }
            if (!value.endsWith(Either.right(Character.valueOf('*')))) {
                value.append(AnyOneOf.middleVal(Character.valueOf('*')));
            }
            val = Either.left(value);
            return val;
        }
        if (val.isLeft() && val.getLeft() instanceof SigmaRegularExpression) {
            SigmaRegularExpression value = (SigmaRegularExpression)val.getLeft();
            if (!value.getRegexp().startsWith(".*") && value.getRegexp().charAt(0) != '^') {
                value.setRegexp(".*" + value.getRegexp());
            }
            if (!value.getRegexp().endsWith(".*") && !value.getRegexp().endsWith("$")) {
                value.setRegexp(value.getRegexp() + ".*");
            }
            value.compile();
            return Either.left(value);
        }
        return null;
    }
}

