/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.model;

import java.io.IOException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.securityanalytics.threatIntel.model.Source;

public class S3Source
extends Source
implements Writeable,
ToXContent {
    public static final String BUCKET_NAME_FIELD = "bucket_name";
    public static final String OBJECT_KEY_FIELD = "object_key";
    public static final String REGION_FIELD = "region";
    public static final String ROLE_ARN_FIELD = "role_arn";
    private String bucketName;
    private String objectKey;
    private String region;
    private String roleArn;

    public S3Source(String bucketName, String objectKey, String region, String roleArn) {
        this.bucketName = bucketName;
        this.objectKey = objectKey;
        this.region = region;
        this.roleArn = roleArn;
    }

    public S3Source(StreamInput sin) throws IOException {
        this(sin.readString(), sin.readString(), sin.readString(), sin.readString());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.bucketName);
        out.writeString(this.objectKey);
        out.writeString(this.region);
        out.writeString(this.roleArn);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field("s3");
        builder.startObject().field(BUCKET_NAME_FIELD, this.bucketName).field(OBJECT_KEY_FIELD, this.objectKey).field(REGION_FIELD, this.region).field(ROLE_ARN_FIELD, this.roleArn);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    @Override
    String name() {
        return "s3";
    }

    public static S3Source parse(XContentParser xcp) throws IOException {
        String bucketName = null;
        String objectKey = null;
        String region = null;
        String roleArn = null;
        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "bucket_name": {
                    bucketName = xcp.text();
                    break;
                }
                case "object_key": {
                    objectKey = xcp.text();
                    break;
                }
                case "region": {
                    region = xcp.text();
                    break;
                }
                case "role_arn": {
                    roleArn = xcp.text();
                    break;
                }
            }
        }
        return new S3Source(bucketName, objectKey, region, roleArn);
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getObjectKey() {
        return this.objectKey;
    }

    public void setObjectKey(String objectKey) {
        this.objectKey = objectKey;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }
}

