/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.SpecialPermission;
import org.opensearch.common.SuppressForbidden;
import org.opensearch.securityanalytics.threatIntel.common.Constants;
import org.opensearch.securityanalytics.threatIntel.model.TIFMetadata;

public class ThreatIntelFeedParser {
    private static final Logger log = LogManager.getLogger(ThreatIntelFeedParser.class);

    @SuppressForbidden(reason="Need to connect to http endpoint to read threat intel feed database file")
    public static CSVParser getThreatIntelFeedReaderCSV(TIFMetadata tifMetadata) {
        SpecialPermission.check();
        return AccessController.doPrivileged(() -> {
            try {
                URL url = new URL(tifMetadata.getUrl());
                URLConnection connection = url.openConnection();
                connection.addRequestProperty("User-Agent", Constants.USER_AGENT_VALUE);
                return new CSVParser((Reader)new BufferedReader(new InputStreamReader(connection.getInputStream())), CSVFormat.RFC4180);
            }
            catch (IOException e) {
                log.error("Exception: failed to read threat intel feed data from {}", (Object)tifMetadata.getUrl(), (Object)e);
                throw new OpenSearchException("failed to read threat intel feed data from {}", new Object[]{tifMetadata.getUrl(), e});
            }
        });
    }

    @SuppressForbidden(reason="Need to connect to http endpoint to read threat intel feed database file")
    public static CSVParser getThreatIntelFeedReaderCSV(URL url) {
        SpecialPermission.check();
        return AccessController.doPrivileged(() -> {
            try {
                URLConnection connection = url.openConnection();
                connection.addRequestProperty("User-Agent", Constants.USER_AGENT_VALUE);
                return new CSVParser((Reader)new BufferedReader(new InputStreamReader(connection.getInputStream())), CSVFormat.RFC4180);
            }
            catch (IOException e) {
                log.error("Exception: failed to read threat intel feed data from {}", (Object)url, (Object)e);
                throw new OpenSearchException("failed to read threat intel feed data from {}", new Object[]{url, e});
            }
        });
    }
}

