/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.AbstractIterator;
import scala.collection.AnyStepper$;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeqView;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.Searching;
import scala.collection.Seq;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.StepperShape$;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StrictOptimizedSeqOps;
import scala.collection.StringOps$;
import scala.collection.convert.impl.RangeStepper;
import scala.collection.generic.CommonErrors$;
import scala.collection.immutable.AbstractSeq;
import scala.collection.immutable.IndexedSeqOps;
import scala.collection.immutable.Range$;
import scala.collection.immutable.Range$Partial$;
import scala.collection.immutable.RangeIterator;
import scala.collection.mutable.Builder;
import scala.math.Numeric;
import scala.math.Numeric$IntIsIntegral$;
import scala.math.Ordering;
import scala.math.Ordering$Int$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.hashing.MurmurHash3$;

public abstract class Range
extends AbstractSeq<Object>
implements scala.collection.immutable.IndexedSeq<Object>,
scala.collection.immutable.StrictOptimizedSeqOps<Object, scala.collection.immutable.IndexedSeq, scala.collection.immutable.IndexedSeq<Object>>,
Serializable {
    private static final long serialVersionUID = 4L;
    private final int start;
    private final int end;
    private final int step;
    private final boolean isEmpty;
    public final int scala$collection$immutable$Range$$numRangeElements;
    public final int scala$collection$immutable$Range$$lastElement;

    @Override
    public /* synthetic */ Object scala$collection$immutable$StrictOptimizedSeqOps$$super$sorted(Ordering ord) {
        return SeqOps.sorted$(this, ord);
    }

    @Override
    public Object distinctBy(Function1 f) {
        return scala.collection.immutable.StrictOptimizedSeqOps.distinctBy$(this, f);
    }

    @Override
    public Object updated(int index, Object elem) {
        return scala.collection.immutable.StrictOptimizedSeqOps.updated$(this, index, elem);
    }

    @Override
    public Object patch(int from, IterableOnce other, int replaced) {
        return scala.collection.immutable.StrictOptimizedSeqOps.patch$(this, from, other, replaced);
    }

    @Override
    public Object prepended(Object elem) {
        return StrictOptimizedSeqOps.prepended$(this, elem);
    }

    @Override
    public Object appended(Object elem) {
        return StrictOptimizedSeqOps.appended$(this, elem);
    }

    @Override
    public Object appendedAll(IterableOnce suffix) {
        return StrictOptimizedSeqOps.appendedAll$(this, suffix);
    }

    @Override
    public Object prependedAll(IterableOnce prefix) {
        return StrictOptimizedSeqOps.prependedAll$(this, prefix);
    }

    @Override
    public Object padTo(int len, Object elem) {
        return StrictOptimizedSeqOps.padTo$(this, len, elem);
    }

    @Override
    public Object diff(Seq that) {
        return StrictOptimizedSeqOps.diff$(this, that);
    }

    @Override
    public Object intersect(Seq that) {
        return StrictOptimizedSeqOps.intersect$(this, that);
    }

    @Override
    public Tuple2<scala.collection.immutable.IndexedSeq<Object>, scala.collection.immutable.IndexedSeq<Object>> partition(Function1<Object, Object> p) {
        return StrictOptimizedIterableOps.partition$(this, p);
    }

    @Override
    public <A1, A2> Tuple2<scala.collection.immutable.IndexedSeq<A1>, scala.collection.immutable.IndexedSeq<A2>> unzip(Function1<Object, Tuple2<A1, A2>> asPair) {
        return StrictOptimizedIterableOps.unzip$(this, asPair);
    }

    @Override
    public <A1, A2, A3> Tuple3<scala.collection.immutable.IndexedSeq<A1>, scala.collection.immutable.IndexedSeq<A2>, scala.collection.immutable.IndexedSeq<A3>> unzip3(Function1<Object, Tuple3<A1, A2, A3>> asTriple) {
        return StrictOptimizedIterableOps.unzip3$(this, asTriple);
    }

    @Override
    public final <B, C2> C2 strictOptimizedMap(Builder<B, C2> b, Function1<Object, B> f) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedMap$(this, b, f);
    }

    @Override
    public Object flatMap(Function1 f) {
        return StrictOptimizedIterableOps.flatMap$(this, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedFlatMap(Builder<B, C2> b, Function1<Object, IterableOnce<B>> f) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedFlatMap$(this, b, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedConcat(IterableOnce<B> that, Builder<B, C2> b) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedConcat$(this, that, b);
    }

    @Override
    public Object collect(PartialFunction pf) {
        return StrictOptimizedIterableOps.collect$(this, pf);
    }

    @Override
    public final <B, C2> C2 strictOptimizedCollect(Builder<B, C2> b, PartialFunction<Object, B> pf) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedCollect$(this, b, pf);
    }

    @Override
    public Object flatten(Function1 toIterableOnce) {
        return StrictOptimizedIterableOps.flatten$(this, toIterableOnce);
    }

    @Override
    public final <B, C2> C2 strictOptimizedFlatten(Builder<B, C2> b, Function1<Object, IterableOnce<B>> toIterableOnce) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedFlatten$(this, b, toIterableOnce);
    }

    @Override
    public Object zip(IterableOnce that) {
        return StrictOptimizedIterableOps.zip$(this, that);
    }

    @Override
    public final <B, C2> C2 strictOptimizedZip(IterableOnce<B> that, Builder<Tuple2<Object, B>, C2> b) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedZip$(this, that, b);
    }

    @Override
    public Object zipWithIndex() {
        return StrictOptimizedIterableOps.zipWithIndex$(this);
    }

    @Override
    public Object scanLeft(Object z, Function2 op) {
        return StrictOptimizedIterableOps.scanLeft$(this, z, op);
    }

    @Override
    public Object filter(Function1 pred) {
        return StrictOptimizedIterableOps.filter$(this, pred);
    }

    @Override
    public Object filterNot(Function1 pred) {
        return StrictOptimizedIterableOps.filterNot$(this, pred);
    }

    @Override
    public Object filterImpl(Function1 pred, boolean isFlipped) {
        return StrictOptimizedIterableOps.filterImpl$(this, pred, isFlipped);
    }

    @Override
    public <A1, A2> Tuple2<scala.collection.immutable.IndexedSeq<A1>, scala.collection.immutable.IndexedSeq<A2>> partitionMap(Function1<Object, Either<A1, A2>> f) {
        return StrictOptimizedIterableOps.partitionMap$(this, f);
    }

    @Override
    public Object tapEach(Function1 f) {
        return StrictOptimizedIterableOps.tapEach$(this, f);
    }

    @Override
    public /* synthetic */ boolean scala$collection$immutable$IndexedSeq$$super$canEqual(Object that) {
        return Seq.canEqual$(this, that);
    }

    @Override
    public /* synthetic */ boolean scala$collection$immutable$IndexedSeq$$super$sameElements(IterableOnce that) {
        return SeqOps.sameElements$(this, that);
    }

    @Override
    public final scala.collection.immutable.IndexedSeq<Object> toIndexedSeq() {
        return scala.collection.immutable.IndexedSeq.toIndexedSeq$(this);
    }

    @Override
    public boolean canEqual(Object that) {
        return scala.collection.immutable.IndexedSeq.canEqual$(this, that);
    }

    @Override
    public SeqFactory<scala.collection.immutable.IndexedSeq> iterableFactory() {
        return scala.collection.immutable.IndexedSeq.iterableFactory$(this);
    }

    @Override
    public /* synthetic */ Object scala$collection$immutable$IndexedSeqOps$$super$slice(int from, int until) {
        return scala.collection.IndexedSeqOps.slice$(this, from, until);
    }

    @Override
    public String stringPrefix() {
        return IndexedSeq.stringPrefix$(this);
    }

    @Override
    public Iterator<Object> reverseIterator() {
        return scala.collection.IndexedSeqOps.reverseIterator$(this);
    }

    @Override
    public <B$> B$ foldRight(B$ z, Function2<Object, B$, B$> op) {
        return (B$)scala.collection.IndexedSeqOps.foldRight$(this, z, op);
    }

    @Override
    public IndexedSeqView<Object> view() {
        return scala.collection.IndexedSeqOps.view$(this);
    }

    @Override
    public IndexedSeqView<Object> view(int from, int until) {
        return scala.collection.IndexedSeqOps.view$(this, from, until);
    }

    @Override
    public Iterable<Object> reversed() {
        return scala.collection.IndexedSeqOps.reversed$(this);
    }

    @Override
    public Iterator<scala.collection.immutable.IndexedSeq<Object>> sliding(int size, int step) {
        return scala.collection.IndexedSeqOps.sliding$(this, size, step);
    }

    @Override
    public Option<Object> headOption() {
        return scala.collection.IndexedSeqOps.headOption$(this);
    }

    @Override
    public final int lengthCompare(int len) {
        return scala.collection.IndexedSeqOps.lengthCompare$((scala.collection.IndexedSeqOps)this, len);
    }

    @Override
    public int knownSize() {
        return scala.collection.IndexedSeqOps.knownSize$(this);
    }

    @Override
    public final int lengthCompare(Iterable<?> that) {
        return scala.collection.IndexedSeqOps.lengthCompare$((scala.collection.IndexedSeqOps)this, that);
    }

    @Override
    public <B> Searching.SearchResult search(B elem, Ordering<B> ord) {
        return scala.collection.IndexedSeqOps.search$(this, elem, ord);
    }

    @Override
    public <B> Searching.SearchResult search(B elem, int from, int to, Ordering<B> ord) {
        return scala.collection.IndexedSeqOps.search$(this, elem, from, to, ord);
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    public int step() {
        return this.step;
    }

    @Override
    public final Iterator<Object> iterator() {
        return new RangeIterator(this.start(), this.step(), this.scala$collection$immutable$Range$$lastElement, this.isEmpty());
    }

    @Override
    public final <S extends Stepper<?>> S stepper(StepperShape<Object, S> shape) {
        RangeStepper st = new RangeStepper(this.start(), this.step(), 0, this.length());
        if (shape.shape() == StepperShape$.MODULE$.IntShape()) {
            return (S)st;
        }
        Predef$.MODULE$.assert(shape.shape() == StepperShape$.MODULE$.ReferenceShape(), (Function0<Object>)(Function0<String> & Serializable)() -> "unexpected StepperShape: " + shape);
        return (S)AnyStepper$.MODULE$.ofParIntStepper(st);
    }

    public abstract boolean isInclusive();

    @Override
    public final boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    public final int length() {
        if (this.isEmpty()) {
            return 0;
        }
        if (this.scala$collection$immutable$Range$$numRangeElements > 0) {
            return this.scala$collection$immutable$Range$$numRangeElements;
        }
        throw this.fail();
    }

    public int scala$collection$immutable$Range$$locationAfterN(int n) {
        return this.start() + this.step() * n;
    }

    @Override
    public final int last() {
        if (this.isEmpty()) {
            throw Range$.MODULE$.scala$collection$immutable$Range$$emptyRangeError("last");
        }
        return this.scala$collection$immutable$Range$$lastElement;
    }

    @Override
    public final int head() {
        if (this.isEmpty()) {
            throw Range$.MODULE$.scala$collection$immutable$Range$$emptyRangeError("head");
        }
        return this.start();
    }

    @Override
    public final Range init() {
        if (this.isEmpty()) {
            throw Range$.MODULE$.scala$collection$immutable$Range$$emptyRangeError("init");
        }
        return this.dropRight(1);
    }

    @Override
    public final Range tail() {
        if (this.isEmpty()) {
            throw Range$.MODULE$.scala$collection$immutable$Range$$emptyRangeError("tail");
        }
        if (this.scala$collection$immutable$Range$$numRangeElements == 1) {
            return this.newEmptyRange(this.end());
        }
        if (this.isInclusive()) {
            return new Inclusive(this.start() + this.step(), this.end(), this.step());
        }
        return new Exclusive(this.start() + this.step(), this.end(), this.step());
    }

    @Override
    public <B> scala.collection.immutable.IndexedSeq<B> map(Function1<Object, B> f) {
        this.scala$collection$immutable$Range$$validateMaxLength();
        return (scala.collection.immutable.IndexedSeq)StrictOptimizedIterableOps.map$(this, f);
    }

    public final Range copy(int start, int end, int step, boolean isInclusive) {
        if (isInclusive) {
            return new Inclusive(start, end, step);
        }
        return new Exclusive(start, end, step);
    }

    public final int copy$default$1() {
        return this.start();
    }

    public final int copy$default$2() {
        return this.end();
    }

    public final int copy$default$3() {
        return this.step();
    }

    public final boolean copy$default$4() {
        return this.isInclusive();
    }

    public final Range by(int step) {
        return this.copy(this.start(), this.end(), step, this.copy$default$4());
    }

    public void scala$collection$immutable$Range$$validateMaxLength() {
        if (this.scala$collection$immutable$Range$$numRangeElements <= 0 && !this.isEmpty()) {
            throw this.fail();
        }
    }

    private String description() {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%d %s %d by %s"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.start()), this.isInclusive() ? "to" : "until", BoxesRunTime.boxToInteger(this.end()), BoxesRunTime.boxToInteger(this.step())}));
    }

    private Nothing$ fail() {
        throw new IllegalArgumentException(this.description() + ": seqs cannot contain more than Int.MaxValue elements.");
    }

    @Override
    public final int apply(int idx) throws IndexOutOfBoundsException {
        return this.apply$mcII$sp(idx);
    }

    @Override
    public final <U> void foreach(Function1<Object, U> f) {
        if (!this.isEmpty()) {
            int i = this.start();
            while (true) {
                f.apply(BoxesRunTime.boxToInteger(i));
                if (i == this.scala$collection$immutable$Range$$lastElement) {
                    return;
                }
                i += this.step();
            }
        }
    }

    @Override
    public final <B> int indexOf(B elem, int from) {
        if (elem instanceof Integer) {
            int n = BoxesRunTime.unboxToInt(elem);
            int pos = this.scala$collection$immutable$Range$$posOf(n);
            if (pos >= from) {
                return pos;
            }
            return -1;
        }
        return SeqOps.indexOf$(this, elem, from);
    }

    public final <B> int indexOf$default$2() {
        return 0;
    }

    @Override
    public final <B> int lastIndexOf(B elem, int end) {
        if (elem instanceof Integer) {
            int n = BoxesRunTime.unboxToInt(elem);
            int pos = this.scala$collection$immutable$Range$$posOf(n);
            if (pos <= end) {
                return pos;
            }
            return -1;
        }
        return SeqOps.lastIndexOf$(this, elem, end);
    }

    @Override
    public final <B> int lastIndexOf$default$2() {
        return this.length() - 1;
    }

    public int scala$collection$immutable$Range$$posOf(int i) {
        if (this.contains(i)) {
            return (i - this.start()) / this.step();
        }
        return -1;
    }

    @Override
    public <B> boolean sameElements(IterableOnce<B> that) {
        if (that instanceof Range) {
            Range range = (Range)that;
            int n = this.length();
            switch (n) {
                case 0: {
                    return range.isEmpty();
                }
                case 1: {
                    return range.length() == 1 && this.start() == range.start();
                }
            }
            return range.length() == n && this.start() == range.start() && this.step() == range.step();
        }
        return scala.collection.immutable.IndexedSeq.sameElements$(this, that);
    }

    private boolean greaterEqualNumRangeElements(int n) {
        return (n ^ Integer.MIN_VALUE) > (this.scala$collection$immutable$Range$$numRangeElements - 1 ^ Integer.MIN_VALUE);
    }

    @Override
    public final Range take(int n) {
        if (n <= 0 || this.isEmpty()) {
            return this.newEmptyRange(this.start());
        }
        if (this.greaterEqualNumRangeElements(n)) {
            return this;
        }
        return new Inclusive(this.start(), this.scala$collection$immutable$Range$$locationAfterN(n - 1), this.step());
    }

    @Override
    public final Range drop(int n) {
        if (n <= 0 || this.isEmpty()) {
            return this;
        }
        if (this.greaterEqualNumRangeElements(n)) {
            return this.newEmptyRange(this.end());
        }
        return this.copy(this.scala$collection$immutable$Range$$locationAfterN(n), this.end(), this.step(), this.copy$default$4());
    }

    @Override
    public final Range takeRight(int n) {
        if (n <= 0 || this.isEmpty()) {
            return this.newEmptyRange(this.start());
        }
        if (this.greaterEqualNumRangeElements(n)) {
            return this;
        }
        return this.copy(this.scala$collection$immutable$Range$$locationAfterN(this.scala$collection$immutable$Range$$numRangeElements - n), this.end(), this.step(), this.copy$default$4());
    }

    @Override
    public final Range dropRight(int n) {
        if (n <= 0 || this.isEmpty()) {
            return this;
        }
        if (this.greaterEqualNumRangeElements(n)) {
            return this.newEmptyRange(this.end());
        }
        return Range$.MODULE$.inclusive(this.start(), this.scala$collection$immutable$Range$$locationAfterN(this.scala$collection$immutable$Range$$numRangeElements - 1 - n), this.step());
    }

    private long argTakeWhile(Function1<Object, Object> p) {
        int current;
        if (this.isEmpty()) {
            return this.start();
        }
        int stop = this.last();
        for (current = this.start(); current != stop && p.apply$mcZI$sp(current); current += this.step()) {
        }
        if (current != stop || !p.apply$mcZI$sp(current)) {
            return current;
        }
        return (long)current + (long)this.step();
    }

    @Override
    public final Range takeWhile(Function1<Object, Object> p) {
        long stop = this.argTakeWhile(p);
        if (stop == (long)this.start()) {
            return this.newEmptyRange(this.start());
        }
        int x = (int)(stop - (long)this.step());
        if (x == this.last()) {
            return this;
        }
        return Range$.MODULE$.inclusive(this.start(), x, this.step());
    }

    @Override
    public final Range dropWhile(Function1<Object, Object> p) {
        long stop = this.argTakeWhile(p);
        if (stop == (long)this.start()) {
            return this;
        }
        int x = (int)(stop - (long)this.step());
        if (x == this.last()) {
            return this.newEmptyRange(this.last());
        }
        return Range$.MODULE$.inclusive(x + this.step(), this.last(), this.step());
    }

    @Override
    public final Tuple2<Range, Range> span(Function1<Object, Object> p) {
        long border = this.argTakeWhile(p);
        if (border == (long)this.start()) {
            return new Tuple2<Range, Range>(this.newEmptyRange(this.start()), this);
        }
        int x = (int)(border - (long)this.step());
        if (x == this.last()) {
            return new Tuple2<Range, Range>(this, this.newEmptyRange(this.last()));
        }
        return new Tuple2<Range, Range>(Range$.MODULE$.inclusive(this.start(), x, this.step()), Range$.MODULE$.inclusive(x + this.step(), this.last(), this.step()));
    }

    @Override
    public final Range slice(int from, int until) {
        if (this.isEmpty()) {
            return this;
        }
        if (from <= 0) {
            return this.take(until);
        }
        if (this.greaterEqualNumRangeElements(until) && until >= 0) {
            return this.drop(from);
        }
        int fromValue = this.scala$collection$immutable$Range$$locationAfterN(from);
        if (from >= until) {
            return this.newEmptyRange(fromValue);
        }
        return Range$.MODULE$.inclusive(fromValue, this.scala$collection$immutable$Range$$locationAfterN(until - 1), this.step());
    }

    @Override
    public final Tuple2<Range, Range> splitAt(int n) {
        return new Tuple2<Range, Range>(this.take(n), this.drop(n));
    }

    private Exclusive newEmptyRange(int value) {
        return new Exclusive(value, value, this.step());
    }

    @Override
    public final Range reverse() {
        if (this.isEmpty()) {
            return this;
        }
        return new Inclusive(this.last(), this.start(), -this.step());
    }

    public final Range inclusive() {
        if (this.isInclusive()) {
            return this;
        }
        return new Inclusive(this.start(), this.end(), this.step());
    }

    @Override
    public final boolean contains(int x) {
        if (this.isEmpty()) {
            return false;
        }
        if (this.step() > 0) {
            if (x < this.start() || x > this.scala$collection$immutable$Range$$lastElement) {
                return false;
            }
            return this.step() == 1 || Integer.remainderUnsigned(x - this.start(), this.step()) == 0;
        }
        if (x > this.start() || x < this.scala$collection$immutable$Range$$lastElement) {
            return false;
        }
        return this.step() == -1 || Integer.remainderUnsigned(this.start() - x, -this.step()) == 0;
    }

    @Override
    public final <B> boolean contains(B elem) {
        if (elem instanceof Integer) {
            int n = BoxesRunTime.unboxToInt(elem);
            return this.contains(n);
        }
        return SeqOps.contains$(this, elem);
    }

    @Override
    public final <B> int sum(Numeric<B> num) {
        if (num == Numeric$IntIsIntegral$.MODULE$) {
            if (this.isEmpty()) {
                return 0;
            }
            if (this.size() == 1) {
                return this.head();
            }
            return (int)((long)this.size() * ((long)this.head() + (long)this.last()) / 2L);
        }
        if (this.isEmpty()) {
            return num.toInt(num.zero());
        }
        Object acc = num.zero();
        int i = this.head();
        while (true) {
            acc = num.plus(acc, BoxesRunTime.boxToInteger(i));
            if (i == this.scala$collection$immutable$Range$$lastElement) {
                return num.toInt(acc);
            }
            i += this.step();
        }
    }

    @Override
    public final <A1> int min(Ordering<A1> ord) {
        if (ord == Ordering$Int$.MODULE$) {
            if (this.step() > 0) {
                return this.head();
            }
            return this.last();
        }
        if (Ordering$Int$.MODULE$.isReverseOf(ord)) {
            if (this.step() > 0) {
                return this.last();
            }
            return this.head();
        }
        return BoxesRunTime.unboxToInt(IterableOnceOps.min$(this, ord));
    }

    @Override
    public final <A1> int max(Ordering<A1> ord) {
        if (ord == Ordering$Int$.MODULE$) {
            if (this.step() > 0) {
                return this.last();
            }
            return this.head();
        }
        if (Ordering$Int$.MODULE$.isReverseOf(ord)) {
            if (this.step() > 0) {
                return this.head();
            }
            return this.last();
        }
        return BoxesRunTime.unboxToInt(IterableOnceOps.max$(this, ord));
    }

    @Override
    public Iterator<Range> tails() {
        return new AbstractIterator<Range>(this){
            private int i;
            private final /* synthetic */ Range $outer;

            public boolean hasNext() {
                return this.i <= this.$outer.length();
            }

            public Range next() {
                if (this.hasNext()) {
                    Range res = this.$outer.drop(this.i);
                    ++this.i;
                    return res;
                }
                return (Range)Iterator$.MODULE$.empty().next();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.i = 0;
            }
        };
    }

    @Override
    public Iterator<Range> inits() {
        return new AbstractIterator<Range>(this){
            private int i;
            private final /* synthetic */ Range $outer;

            public boolean hasNext() {
                return this.i <= this.$outer.length();
            }

            public Range next() {
                if (this.hasNext()) {
                    Range res = this.$outer.dropRight(this.i);
                    ++this.i;
                    return res;
                }
                return (Range)Iterator$.MODULE$.empty().next();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.i = 0;
            }
        };
    }

    @Override
    public final int applyPreferredMaxLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    public final boolean equals(Object other) {
        if (other instanceof Range) {
            int l0;
            Range range = (Range)other;
            if (this.isEmpty()) {
                return range.isEmpty();
            }
            return range.nonEmpty() && this.start() == range.start() && (l0 = this.last()) == range.last() && (this.start() == l0 || this.step() == range.step());
        }
        return Seq.equals$(this, other);
    }

    @Override
    public final int hashCode() {
        if (this.length() >= 2) {
            return MurmurHash3$.MODULE$.rangeHash(this.start(), this.step(), this.scala$collection$immutable$Range$$lastElement);
        }
        return Seq.hashCode$(this);
    }

    @Override
    public final String toString() {
        String stepped;
        String preposition = this.isInclusive() ? "to" : "until";
        String string2 = stepped = this.step() == 1 ? "" : " by " + this.step();
        return (this.isEmpty() ? "empty " : (this.isInexact$1() ? "inexact " : "")) + "Range " + this.start() + " " + preposition + " " + this.end() + stepped;
    }

    @Override
    public String className() {
        return "Range";
    }

    @Override
    public Range distinct() {
        return this;
    }

    @Override
    public Iterator<Range> grouped(int size) {
        Predef$.MODULE$.require(size >= 1, (Function0<Object>)(Function0<String> & Serializable)() -> StringOps$.MODULE$.format$extension("size=%d, but size must be positive", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(size)})));
        if (this.isEmpty()) {
            return Iterator$.MODULE$.empty();
        }
        return new AbstractIterator<Range>(this, size){
            private int i;
            private final /* synthetic */ Range $outer;
            private final int s$1;

            public boolean hasNext() {
                return this.$outer.length() > this.i;
            }

            public Range next() {
                if (this.hasNext()) {
                    Range x = this.$outer.slice(this.i, this.i + this.s$1);
                    this.i += this.s$1;
                    return x;
                }
                return (Range)Iterator$.MODULE$.empty().next();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.s$1 = s$1;
                this.i = 0;
            }
        };
    }

    @Override
    public <B> scala.collection.immutable.IndexedSeq<Object> sorted(Ordering<B> ord) {
        if (ord == Ordering$Int$.MODULE$) {
            if (this.step() > 0) {
                return this;
            }
            return this.reverse();
        }
        return (scala.collection.immutable.IndexedSeq)scala.collection.immutable.StrictOptimizedSeqOps.sorted$(this, ord);
    }

    public final void foreach$mVc$sp(Function1<Object, BoxedUnit> f) {
        if (!this.isEmpty()) {
            int i = this.start();
            while (true) {
                f.apply$mcVI$sp(i);
                if (i == this.scala$collection$immutable$Range$$lastElement) {
                    return;
                }
                i += this.step();
            }
        }
    }

    public final int indexOf$mIc$sp(int elem, int from) {
        int pos = this.scala$collection$immutable$Range$$posOf(elem);
        if (pos >= from) {
            return pos;
        }
        return -1;
    }

    public final int lastIndexOf$mIc$sp(int elem, int end) {
        int pos = this.scala$collection$immutable$Range$$posOf(elem);
        if (pos <= end) {
            return pos;
        }
        return -1;
    }

    @Override
    public final int apply$mcII$sp(int idx) throws IndexOutOfBoundsException {
        if (idx < 0 || idx >= this.scala$collection$immutable$Range$$numRangeElements || this.isEmpty()) {
            this.scala$collection$immutable$Range$$validateMaxLength();
            int max = this.isEmpty() ? -1 : this.scala$collection$immutable$Range$$numRangeElements - 1;
            throw CommonErrors$.MODULE$.indexOutOfBounds(idx, max);
        }
        return this.scala$collection$immutable$Range$$locationAfterN(idx);
    }

    private final boolean isInexact$1() {
        if (this.isInclusive()) {
            return this.scala$collection$immutable$Range$$lastElement != this.end();
        }
        return this.scala$collection$immutable$Range$$lastElement + this.step() != this.end();
    }

    public Range(int start, int end, int step) {
        this.start = start;
        this.end = end;
        this.step = step;
        scala.collection.IndexedSeqOps.$init$(this);
        IndexedSeq.$init$(this);
        IndexedSeqOps.$init$(this);
        scala.collection.immutable.IndexedSeq.$init$(this);
        StrictOptimizedIterableOps.$init$(this);
        StrictOptimizedSeqOps.$init$(this);
        scala.collection.immutable.StrictOptimizedSeqOps.$init$(this);
        boolean bl = this.isInclusive() ? (step >= 0 ? start > end : start < end) : (step >= 0 ? start >= end : (this.isEmpty = start <= end));
        if (step == 0) {
            throw new IllegalArgumentException("step cannot be 0.");
        }
        int stepSign = step >> 31;
        int gap = (end - start ^ stepSign) - stepSign;
        int absStep = (step ^ stepSign) - stepSign;
        int div = Integer.divideUnsigned(gap, absStep);
        int n = this.scala$collection$immutable$Range$$numRangeElements = this.isInclusive() || absStep * div != gap ? div + 1 : div;
        this.scala$collection$immutable$Range$$lastElement = (step + 1 & 0xFFFFFFFD) == 0 ? (this.isInclusive() ? end : end - step) : this.scala$collection$immutable$Range$$locationAfterN(this.scala$collection$immutable$Range$$numRangeElements - 1);
    }

    public static final class Exclusive
    extends Range {
        private static final long serialVersionUID = 4L;

        @Override
        public boolean isInclusive() {
            return false;
        }

        public Exclusive(int start, int end, int step) {
            super(start, end, step);
        }
    }

    public static final class Inclusive
    extends Range {
        private static final long serialVersionUID = 4L;

        @Override
        public boolean isInclusive() {
            return true;
        }

        public Inclusive(int start, int end, int step) {
            super(start, end, step);
        }
    }

    public static final class Partial<T, U> {
        private final Function1<T, U> scala$collection$immutable$Range$Partial$$f;

        public Function1<T, U> scala$collection$immutable$Range$Partial$$f() {
            return this.scala$collection$immutable$Range$Partial$$f;
        }

        public U by(T x) {
            return Range$Partial$.MODULE$.by$extension(this.scala$collection$immutable$Range$Partial$$f(), x);
        }

        public String toString() {
            return Range$Partial$.MODULE$.toString$extension(this.scala$collection$immutable$Range$Partial$$f());
        }

        public int hashCode() {
            return Range$Partial$.MODULE$.hashCode$extension(this.scala$collection$immutable$Range$Partial$$f());
        }

        public boolean equals(Object x$1) {
            return Range$Partial$.MODULE$.equals$extension(this.scala$collection$immutable$Range$Partial$$f(), x$1);
        }

        public Partial(Function1<T, U> f) {
            this.scala$collection$immutable$Range$Partial$$f = f;
        }
    }
}

