/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.builders;

import java.net.URI;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Connection;
import redis.clients.jedis.DefaultJedisClientConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.builders.AbstractClientBuilder;
import redis.clients.jedis.providers.ConnectionProvider;
import redis.clients.jedis.providers.PooledConnectionProvider;
import redis.clients.jedis.util.JedisURIHelper;

public abstract class StandaloneClientBuilder<C>
extends AbstractClientBuilder<StandaloneClientBuilder<C>, C> {
    private HostAndPort hostAndPort = new HostAndPort("127.0.0.1", 6379);

    public StandaloneClientBuilder<C> hostAndPort(String host, int port) {
        this.hostAndPort = new HostAndPort(host, port);
        return this;
    }

    public StandaloneClientBuilder<C> hostAndPort(HostAndPort hostAndPort) {
        this.hostAndPort = hostAndPort;
        return this;
    }

    @Override
    protected StandaloneClientBuilder<C> self() {
        return this;
    }

    @Override
    protected ConnectionProvider createDefaultConnectionProvider() {
        return new PooledConnectionProvider(this.hostAndPort, this.clientConfig, this.cache, (GenericObjectPoolConfig<Connection>)this.poolConfig);
    }

    @Override
    protected void validateSpecificConfiguration() {
        this.validateCommonConfiguration();
        if (this.hostAndPort == null) {
            throw new IllegalArgumentException("Either URI or host/port must be specified");
        }
    }

    public StandaloneClientBuilder<C> fromURI(String uriString) {
        return this.fromURI(URI.create(uriString));
    }

    public StandaloneClientBuilder<C> fromURI(URI uri) {
        this.clientConfig = DefaultJedisClientConfig.builder().user(JedisURIHelper.getUser(uri)).password(JedisURIHelper.getPassword(uri)).database(JedisURIHelper.getDBIndex(uri)).protocol(JedisURIHelper.getRedisProtocol(uri)).ssl(JedisURIHelper.isRedisSSLScheme(uri)).build();
        return this.hostAndPort(JedisURIHelper.getHostAndPort(uri));
    }
}

