/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler.events;

import jakarta.inject.Inject;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.handler.events.BaseEventHandler;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Event;
import org.traccar.model.Position;
import org.traccar.session.cache.CacheManager;

public class BehaviorEventHandler
extends BaseEventHandler {
    private final double accelerationThreshold;
    private final double brakingThreshold;
    private final CacheManager cacheManager;

    @Inject
    public BehaviorEventHandler(Config config, CacheManager cacheManager) {
        this.accelerationThreshold = config.getDouble(Keys.EVENT_BEHAVIOR_ACCELERATION_THRESHOLD);
        this.brakingThreshold = config.getDouble(Keys.EVENT_BEHAVIOR_BRAKING_THRESHOLD);
        this.cacheManager = cacheManager;
    }

    @Override
    public void onPosition(Position position, BaseEventHandler.Callback callback) {
        Position lastPosition = this.cacheManager.getPosition(position.getDeviceId());
        if (lastPosition != null && !position.getFixTime().equals(lastPosition.getFixTime())) {
            double acceleration = UnitsConverter.mpsFromKnots(position.getSpeed() - lastPosition.getSpeed()) * 1000.0 / (double)(position.getFixTime().getTime() - lastPosition.getFixTime().getTime());
            if (this.accelerationThreshold != 0.0 && acceleration >= this.accelerationThreshold) {
                Event event = new Event("alarm", position);
                event.set("alarm", "hardAcceleration");
                callback.eventDetected(event);
            } else if (this.brakingThreshold != 0.0 && acceleration <= -this.brakingThreshold) {
                Event event = new Event("alarm", position);
                event.set("alarm", "hardBraking");
                callback.eventDetected(event);
            }
        }
    }
}

