/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.notification;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.util.Locale;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.generic.DateTool;
import org.apache.velocity.tools.generic.NumberTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.api.signature.TokenManager;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.database.LocaleManager;
import org.traccar.helper.model.UserUtil;
import org.traccar.model.Server;
import org.traccar.model.User;
import org.traccar.notification.NotificationMessage;
import org.traccar.storage.StorageException;

@Singleton
public class TextTemplateFormatter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TextTemplateFormatter.class);
    private final VelocityEngine velocityEngine;
    private final TokenManager tokenManager;
    private final LocaleManager localeManager;
    private final String templatesRoot;

    @Inject
    public TextTemplateFormatter(VelocityEngine velocityEngine, TokenManager tokenManager, LocaleManager localeManager, Config config) {
        this.velocityEngine = velocityEngine;
        this.tokenManager = tokenManager;
        this.localeManager = localeManager;
        this.templatesRoot = config.getString(Keys.TEMPLATES_ROOT);
    }

    public VelocityContext prepareContext(Server server, User user) {
        VelocityContext velocityContext = new VelocityContext();
        if (user != null) {
            velocityContext.put("user", (Object)user);
            velocityContext.put("timezone", (Object)UserUtil.getTimezone(server, user));
            try {
                velocityContext.put("token", (Object)this.tokenManager.generateToken(user.getId()));
            }
            catch (IOException | GeneralSecurityException | StorageException e) {
                LOGGER.warn("Token generation failed", (Throwable)e);
            }
        }
        velocityContext.put("webUrl", this.velocityEngine.getProperty("web.url"));
        velocityContext.put("dateTool", (Object)new DateTool());
        velocityContext.put("numberTool", (Object)new NumberTool());
        velocityContext.put("locale", (Object)Locale.getDefault());
        velocityContext.put("language", (Object)UserUtil.getLanguage(server, user));
        return velocityContext;
    }

    public NotificationMessage formatMessage(VelocityContext velocityContext, String name, boolean priority) {
        StringWriter writer = new StringWriter();
        String language = (String)velocityContext.get("language");
        Path filePath = this.localeManager.getTemplateFile(this.templatesRoot, "notifications", language, name + ".vm");
        if (filePath != null) {
            Template template = this.velocityEngine.getTemplate(filePath.toString(), StandardCharsets.UTF_8.name());
            template.merge((Context)velocityContext, (Writer)writer);
            return new NotificationMessage((String)velocityContext.get("subject"), (String)velocityContext.get("digest"), writer.toString(), priority);
        }
        return new NotificationMessage(name, name, name, priority);
    }
}

