/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.images.StaticImages;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Iconkit {
    private Hashtable fMap = new Hashtable(53);
    private Vector fRegisteredImages = new Vector(10);
    private Component fComponent;
    private static final int ID = 123;
    private static Iconkit fgIconkit = null;
    private static boolean fgDebug = false;

    public Iconkit(Component component) {
        this.fComponent = component;
        fgIconkit = this;
    }

    public static Iconkit instance() {
        return fgIconkit;
    }

    public void loadRegisteredImages(Component component) {
        if (this.fRegisteredImages.size() == 0) {
            return;
        }
        MediaTracker mediaTracker = new MediaTracker(component);
        Enumeration enumeration = this.fRegisteredImages.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.basicGetImage(string) != null) continue;
            mediaTracker.addImage(this.loadImage(string), 123);
        }
        this.fRegisteredImages.removeAllElements();
        try {
            mediaTracker.waitForAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void registerImage(String string) {
        this.fRegisteredImages.addElement(string);
    }

    public Image registerAndLoadImage(Component component, String string) {
        this.registerImage(string);
        this.loadRegisteredImages(component);
        return this.getImage(string);
    }

    public Image loadImage(String string) {
        if (this.fMap.containsKey(string)) {
            return (Image)this.fMap.get(string);
        }
        Image image = this.loadImageResource(string);
        if (image != null) {
            this.fMap.put(string, image);
        }
        return image;
    }

    public Image loadImageResource(String string) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            if (fgDebug) {
                System.out.println(string);
            }
            byte[] byArray = StaticImages.getImage(string);
            return toolkit.createImage(byArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Image getImage(String string) {
        Image image = this.basicGetImage(string);
        if (image != null) {
            return image;
        }
        this.loadRegisteredImages(this.fComponent);
        return this.basicGetImage(string);
    }

    private Image basicGetImage(String string) {
        if (this.fMap.containsKey(string)) {
            return (Image)this.fMap.get(string);
        }
        return null;
    }
}

