/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import jde.debugger.Debugger;
import jde.debugger.JDE;
import jde.debugger.JDEException;
import jde.debugger.Protocol;

public class DebuggeeSIO
implements Protocol {
    Integer procID;
    Socket m_sioSocket = null;
    Thread standardIOConnectThread;
    StandardInputProcessor standardInputProcessor;
    StandardOutputProcessor standardOutputProcessor;
    StandardErrorProcessor standardErrorProcessor;
    StandardOutputWriter standardOutputWriter;
    private Debugger m_debugger;

    public DebuggeeSIO(Debugger debugger) {
        this.m_debugger = debugger;
        this.procID = debugger.getProcID();
    }

    public int initConnect(final Integer cmdId) throws JDEException {
        JDE.signal(this.procID, "message", "initSIOConnect: starting standard I/O handshake.", true);
        ServerSocket ss = null;
        try {
            ss = new ServerSocket(0);
        }
        catch (IOException ex) {
            throw new JDEException("Unable to create a server socket");
        }
        final ServerSocket sstmp = ss;
        final int port = ss.getLocalPort();
        this.standardIOConnectThread = new Thread("Standard I/O Thread for App #" + this.procID){

            public void run() {
                try {
                    sstmp.setSoTimeout(15000);
                    JDE.commandResult(cmdId, String.valueOf(port), true, false);
                    JDE.signal(DebuggeeSIO.this.procID, "message", "Debugger waiting for Emacs to connect to app SIO port " + port + ".", true);
                    DebuggeeSIO.this.m_sioSocket = sstmp.accept();
                    sstmp.close();
                    DebuggeeSIO.this.initTransport();
                }
                catch (IOException ex) {
                    JDE.signal(DebuggeeSIO.this.procID, "error", "Gave up waiting for Emacs to connect to SIO port: " + port, true);
                }
                catch (SecurityException ex1) {
                    JDE.signal(DebuggeeSIO.this.procID, "error", "Security exception occurred while connecting to app SIO port " + port, true);
                }
            }
        };
        JDE.signal(this.procID, "message", "initSIOConnect: starting SIO connect thread.", true);
        this.standardIOConnectThread.start();
        return port;
    }

    public void initTransport() {
        JDE.signal(this.procID, "message", "Debugger connected to standard I/O socket.", true);
        Process process = this.m_debugger.getVM().process();
        this.standardInputProcessor = new StandardInputProcessor(process.getOutputStream());
        this.standardInputProcessor.start();
        this.standardOutputWriter = new StandardOutputWriter(this.m_sioSocket);
        this.standardOutputWriter.println("*** Process Standard I/O ***");
        this.standardOutputProcessor = new StandardOutputProcessor(process.getInputStream());
        this.standardOutputProcessor.start();
        this.standardErrorProcessor = new StandardErrorProcessor(process.getErrorStream());
        this.standardErrorProcessor.start();
    }

    public void shutdown() {
        try {
            if (this.m_sioSocket != null) {
                this.m_sioSocket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class StandardErrorProcessor
    extends Thread {
        BufferedReader fromVM;

        public StandardErrorProcessor(InputStream fromVMStream) {
            super("Standard Error Processor for App #" + DebuggeeSIO.this.procID);
            this.fromVM = new BufferedReader(new InputStreamReader(fromVMStream));
            this.setPriority(9);
        }

        /*
         * WARNING - void declaration
         */
        public void run() {
            try {
                int len;
                char[] cbuf = new char[256];
                while ((len = this.fromVM.read(cbuf, 0, 256)) != -1) {
                    StandardOutputWriter standardOutputWriter = DebuggeeSIO.this.standardOutputWriter;
                    synchronized (standardOutputWriter) {
                        if (DebuggeeSIO.this.standardOutputWriter != null) {
                            void var3_3;
                            DebuggeeSIO.this.standardOutputWriter.write(cbuf, (int)var3_3);
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class StandardOutputProcessor
    extends Thread {
        BufferedReader fromVM;

        public StandardOutputProcessor(InputStream fromVMStream) {
            this.fromVM = new BufferedReader(new InputStreamReader(fromVMStream));
            this.setPriority(9);
        }

        /*
         * WARNING - void declaration
         */
        public void run() {
            try {
                int len;
                char[] cbuf = new char[256];
                while ((len = this.fromVM.read(cbuf, 0, 256)) != -1) {
                    StandardOutputWriter standardOutputWriter = DebuggeeSIO.this.standardOutputWriter;
                    synchronized (standardOutputWriter) {
                        if (DebuggeeSIO.this.standardOutputWriter != null) {
                            void var3_3;
                            DebuggeeSIO.this.standardOutputWriter.write(cbuf, (int)var3_3);
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class StandardOutputWriter {
        BufferedWriter toEmacs;

        public StandardOutputWriter(Socket m_sioSocket) {
            OutputStream toEmacsStream;
            if (m_sioSocket == null) {
                JDE.signal(DebuggeeSIO.this.procID, "error", "Could not transport app output. Transport socket does not exist.", true);
                return;
            }
            try {
                toEmacsStream = m_sioSocket.getOutputStream();
                if (toEmacsStream == null) {
                    JDE.signal(DebuggeeSIO.this.procID, "error", "Could not transport app output. Transport socket closed.", true);
                    return;
                }
            }
            catch (IOException ex1) {
                JDE.signal(DebuggeeSIO.this.procID, "error", "Could not transport app output. Transport socket closed.", true);
                return;
            }
            this.toEmacs = new BufferedWriter(new OutputStreamWriter(toEmacsStream));
        }

        public void write(char[] cbuf, int len) {
            if (this.toEmacs != null) {
                try {
                    this.toEmacs.write(cbuf, 0, len);
                    this.toEmacs.flush();
                }
                catch (IOException ex1) {
                    JDE.signal(DebuggeeSIO.this.procID, "error", "I/O error: cannot write process output to Emacs.", true);
                }
            }
        }

        public void println(String line) {
            try {
                this.toEmacs.write(line);
                this.toEmacs.newLine();
            }
            catch (IOException e) {
                JDE.signal(DebuggeeSIO.this.procID, "error", "I/O error: cannot write process output to Emacs.", true);
            }
        }
    }

    private class StandardInputProcessor
    extends Thread {
        PrintStream toVM;
        BufferedReader fromEmacs;

        public StandardInputProcessor(OutputStream toVmStream) {
            super("Input Processor for App #" + DebuggeeSIO.this.m_debugger.getProcID());
            this.toVM = new PrintStream(toVmStream, true);
            try {
                this.fromEmacs = new BufferedReader(new InputStreamReader(DebuggeeSIO.this.m_sioSocket.getInputStream()));
            }
            catch (IOException ex1) {
                JDE.signal(DebuggeeSIO.this.procID, "error", "Could not get standard input stream from Emacs.", true);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void run() {
            if (this.fromEmacs == null) {
                return;
            }
            try {
                String line;
                while ((line = this.fromEmacs.readLine()) != null) {
                    void var1_1;
                    this.toVM.println((String)var1_1);
                    this.toVM.flush();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

