"""Generated client library for source version v1."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.generated_clients.apis.source.v1 import source_v1_messages as messages


class SourceV1(base_api.BaseApiClient):
  """Generated client library for service source version v1."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://source.googleapis.com/'
  MTLS_BASE_URL = ''

  _PACKAGE = 'source'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform']
  _VERSION = 'v1'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'SourceV1'
  _URL_VERSION = 'v1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new source handle."""
    url = url or self.BASE_URL
    super(SourceV1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_repos_aliases_files = self.ProjectsReposAliasesFilesService(self)
    self.projects_repos_aliases = self.ProjectsReposAliasesService(self)
    self.projects_repos_files = self.ProjectsReposFilesService(self)
    self.projects_repos_revisions_files = self.ProjectsReposRevisionsFilesService(self)
    self.projects_repos_revisions = self.ProjectsReposRevisionsService(self)
    self.projects_repos_workspaces_files = self.ProjectsReposWorkspacesFilesService(self)
    self.projects_repos_workspaces_snapshots_files = self.ProjectsReposWorkspacesSnapshotsFilesService(self)
    self.projects_repos_workspaces_snapshots = self.ProjectsReposWorkspacesSnapshotsService(self)
    self.projects_repos_workspaces = self.ProjectsReposWorkspacesService(self)
    self.projects_repos = self.ProjectsReposService(self)
    self.projects = self.ProjectsService(self)
    self.v1 = self.V1Service(self)

  class ProjectsReposAliasesFilesService(base_api.BaseApiService):
    """Service class for the projects_repos_aliases_files resource."""

    _NAME = 'projects_repos_aliases_files'

    def __init__(self, client):
      super(SourceV1.ProjectsReposAliasesFilesService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Read is given a SourceContext and path, and returns.
file or directory information about that path.

      Args:
        request: (SourceProjectsReposAliasesFilesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ReadResponse) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectId}/repos/{repoName}/aliases/{kind}/{name}/files/{filesId}',
        http_method='GET',
        method_id='source.projects.repos.aliases.files.get',
        ordered_params=['projectId', 'repoName', 'kind', 'name', 'path'],
        path_params=['kind', 'name', 'path', 'projectId', 'repoName'],
        query_params=['pageSize', 'pageToken', 'sourceContext_cloudRepo_aliasName', 'sourceContext_cloudRepo_repoId_uid', 'sourceContext_cloudRepo_revisionId', 'sourceContext_cloudWorkspace_snapshotId', 'sourceContext_cloudWorkspace_workspaceId_name', 'sourceContext_cloudWorkspace_workspaceId_repoId_projectRepoId_projectId', 'sourceContext_cloudWorkspace_workspaceId_repoId_projectRepoId_repoName', 'sourceContext_cloudWorkspace_workspaceId_repoId_uid', 'sourceContext_gerrit_aliasContext_kind', 'sourceContext_gerrit_aliasContext_name', 'sourceContext_gerrit_aliasName', 'sourceContext_gerrit_gerritProject', 'sourceContext_gerrit_hostUri', 'sourceContext_gerrit_revisionId', 'sourceContext_git_revisionId', 'sourceContext_git_url', 'startPosition'],
        relative_path='v1/projects/{projectId}/repos/{repoName}/aliases/{kind}/{name}/files/{+path}',
        request_field='',
        request_type_name='SourceProjectsReposAliasesFilesGetRequest',
        response_type_name='ReadResponse',
        supports_download=False,
    )

  class ProjectsReposAliasesService(base_api.BaseApiService):
    """Service class for the projects_repos_aliases resource."""

    _NAME = 'projects_repos_aliases'

    def __init__(self, client):
      super(SourceV1.ProjectsReposAliasesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new alias. It is an ALREADY_EXISTS error if an alias with that.
name and kind already exists.

      Args:
        request: (SourceProjectsReposAliasesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Alias) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='source.projects.repos.aliases.create',
        ordered_params=['projectId', 'repoName'],
        path_params=['projectId', 'repoName'],
        query_params=['repoId_uid'],
        relative_path='v1/projects/{projectId}/repos/{repoName}/aliases',
        request_field='alias',
        request_type_name='SourceProjectsReposAliasesCreateRequest',
        response_type_name='Alias',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the alias with the given name and kind. Kind cannot be ANY.  If.
the alias does not exist, NOT_FOUND is returned.  If the request provides
a revision ID and the alias does not refer to that revision, ABORTED is
returned.

      Args:
        request: (SourceProjectsReposAliasesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='source.projects.repos.aliases.delete',
        ordered_params=['projectId', 'repoName', 'kind', 'name'],
        path_params=['kind', 'name', 'projectId', 'repoName'],
        query_params=['repoId_uid', 'revisionId'],
        relative_path='v1/projects/{projectId}/repos/{repoName}/aliases/{kind}/{name}',
        request_field='',
        request_type_name='SourceProjectsReposAliasesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns information about an alias. Kind ANY returns a FIXED or.
MOVABLE alias, in that order, and ignores all other kinds.

      Args:
        request: (SourceProjectsReposAliasesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Alias) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='source.projects.repos.aliases.get',
        ordered_params=['projectId', 'repoName', 'kind', 'name'],
        path_params=['kind', 'name', 'projectId', 'repoName'],
        query_params=['repoId_uid'],
        relative_path='v1/projects/{projectId}/repos/{repoName}/aliases/{kind}/{name}',
        request_field='',
        request_type_name='SourceProjectsReposAliasesGetRequest',
        response_type_name='Alias',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Returns a list of aliases of the given kind. Kind ANY returns all aliases.
in the repo. The order in which the aliases are returned is undefined.

      Args:
        request: (SourceProjectsReposAliasesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListAliasesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='source.projects.repos.aliases.list',
        ordered_params=['projectId', 'repoName'],
        path_params=['projectId', 'repoName'],
        query_params=['kind', 'pageSize', 'pageToken', 'repoId_uid'],
        relative_path='v1/projects/{projectId}/repos/{repoName}/aliases',
        request_field='',
        request_type_name='SourceProjectsReposAliasesListRequest',
        response_type_name='ListAliasesResponse',
        supports_download=False,
    )

    def ListFiles(self, request, global_params=None):
      r"""ListFiles returns a list of all files in a SourceContext. The.
information about each file includes its path and its hash.
The result is ordered by path. Pagination is supported.

      Args:
        request: (SourceProjectsReposAliasesListFilesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListFilesResponse) The response message.
      """
      config = self.GetMethodConfig('ListFiles')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListFiles.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='source.projects.repos.aliases.listFiles',
        ordered_params=['projectId', 'repoName', 'kind', 'name'],
        path_params=['kind', 'name', 'projectId', 'repoName'],
        query_params=['pageSize', 'pageToken', 'sourceContext_cloudRepo_aliasName', 'sourceContext_cloudRepo_repoId_uid', 'sourceContext_cloudRepo_revisionId', 'sourceContext_cloudWorkspace_snapshotId', 'sourceContext_cloudWorkspace_workspaceId_name', 'sourceContext_cloudWorkspace_workspaceId_repoId_projectRepoId_projectId', 'sourceContext_cloudWorkspace_workspaceId_repoId_projectRepoId_repoName', 'sourceContext_cloudWorkspace_workspaceId_repoId_uid', 'sourceContext_gerrit_aliasContext_kind', 'sourceContext_gerrit_aliasContext_name', 'sourceContext_gerrit_aliasName', 'sourceContext_gerrit_gerritProject', 'sourceContext_gerrit_hostUri', 'sourceContext_gerrit_revisionId', 'sourceContext_git_revisionId', 'sourceContext_git_url'],
        relative_path='v1/projects/{projectId}/repos/{repoName}/aliases/{kind}/{name}:listFiles',
        request_field='',
        request_type_name='SourceProjectsReposAliasesListFilesRequest',
        response_type_name='ListFilesResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates the alias with the given name and kind. Kind cannot be ANY.  If.
the alias does not exist, NOT_FOUND is returned. If the request provides
an old revision ID and the alias does not refer to that revision, ABORTED
is returned.

      Args:
        request: (SourceProjectsReposAliasesUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Alias) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='source.projects.repos.aliases.update',
        ordered_params=['projectId', 'repoName', 'aliasesId'],
        path_params=['aliasesId', 'projectId', 'repoName'],
        query_params=['oldRevisionId', 'repoId_uid'],
        relative_path='v1/projects/{projectId}/repos/{repoName}/aliases/{aliasesId}',
        request_field='alias',
        request_type_name='SourceProjectsReposAliasesUpdateRequest',
        response_type_name='Alias',
        supports_download=False,
    )

  class ProjectsReposFilesService(base_api.BaseApiService):
    """Service class for the projects_repos_files resource."""

    _NAME = 'projects_repos_files'

    def __init__(self, client):
      super(SourceV1.ProjectsReposFilesService, self).__init__(client)
      self._upload_configs = {
          }

    def ReadFromWorkspaceOrAlias(self, request, global_params=None):
      r"""ReadFromWorkspaceOrAlias performs a Read using either the most recent.
snapshot of the given workspace, if the workspace exists, or the
revision referred to by the given alias if the workspace does not exist.

      Args:
        request: (SourceProjectsReposFilesReadFromWorkspaceOrAliasRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ReadResponse) The response message.
      """
      config = self.GetMethodConfig('ReadFromWorkspaceOrAlias')
      return self._RunMethod(
          config, request, global_params=global_params)

    ReadFromWorkspaceOrAlias.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectId}/repos/{repoName}/files/{filesId}:readFromWorkspaceOrAlias',
        http_method='GET',
        method_id='source.projects.repos.files.readFromWorkspaceOrAlias',
        ordered_params=['projectId', 'repoName', 'path'],
        path_params=['path', 'projectId', 'repoName'],
        query_params=['alias', 'pageSize', 'pageToken', 'repoId_uid', 'startPosition', 'workspaceName'],
        relative_path='v1/projects/{projectId}/repos/{repoName}/files/{+path}:readFromWorkspaceOrAlias',
        request_field='',
        request_type_name='SourceProjectsReposFilesReadFromWorkspaceOrAliasRequest',
        response_type_name='ReadResponse',
        supports_download=False,
    )

  class ProjectsReposRevisionsFilesService(base_api.BaseApiService):
    """Service class for the projects_repos_revisions_files resource."""

    _NAME = 'projects_repos_revisions_files'

    def __init__(self, client):
      super(SourceV1.ProjectsReposRevisionsFilesService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Read is given a SourceContext and path, and returns.
file or directory information about that path.

      Args:
        request: (SourceProjectsReposRevisionsFilesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ReadResponse) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectId}/repos/{repoName}/revisions/{revisionId}/files/{filesId}',
        http_method='GET',
        method_id='source.projects.repos.revisions.files.get',
        ordered_params=['projectId', 'repoName', 'revisionId', 'path'],
        path_params=['path', 'projectId', 'repoName', 'revisionId'],
        query_params=['pageSize', 'pageToken', 'sourceContext_cloudRepo_aliasContext_kind', 'sourceContext_cloudRepo_aliasContext_name', 'sourceContext_cloudRepo_aliasName', 'sourceContext_cloudRepo_repoId_uid', 'sourceContext_cloudWorkspace_snapshotId', 'sourceContext_cloudWorkspace_workspaceId_name', 'sourceContext_cloudWorkspace_workspaceId_repoId_projectRepoId_projectId', 'sourceContext_cloudWorkspace_workspaceId_repoId_projectRepoId_repoName', 'sourceContext_cloudWorkspace_workspaceId_repoId_uid', 'sourceContext_gerrit_aliasContext_kind', 'sourceContext_gerrit_aliasContext_name', 'sourceContext_gerrit_aliasName', 'sourceContext_gerrit_gerritProject', 'sourceContext_gerrit_hostUri', 'sourceContext_gerrit_revisionId', 'sourceContext_git_revisionId', 'sourceContext_git_url', 'startPosition'],
        relative_path='v1/projects/{projectId}/repos/{repoName}/revisions/{revisionId}/files/{+path}',
        request_field='',
        request_type_name='SourceProjectsReposRevisionsFilesGetRequest',
        response_type_name='ReadResponse',
        supports_download=False,
    )

  class ProjectsReposRevisionsService(base_api.BaseApiService):
    """Service class for the projects_repos_revisions resource."""

    _NAME = 'projects_repos_revisions'

    def __init__(self, client):
      super(SourceV1.ProjectsReposRevisionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Retrieves revision metadata for a single revision.

      Args:
        request: (SourceProjectsReposRevisionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Revision) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='source.projects.repos.revisions.get',
        ordered_params=['projectId', 'repoName', 'revisionId'],
        path_params=['projectId', 'repoName', 'revisionId'],
        query_params=['repoId_uid'],
        relative_path='v1/projects/{projectId}/repos/{repoName}/revisions/{revisionId}',
        request_field='',
        request_type_name='SourceProjectsReposRevisionsGetRequest',
        response_type_name='Revision',
        supports_download=False,
    )

    def GetBatchGet(self, request, global_params=None):
      r"""Retrieves revision metadata for several revisions at once. It returns an.
error if any retrieval fails.

      Args:
        request: (SourceProjectsReposRevisionsGetBatchGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GetRevisionsResponse) The response message.
      """
      config = self.GetMethodConfig('GetBatchGet')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetBatchGet.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='source.projects.repos.revisions.getBatchGet',
        ordered_params=['projectId', 'repoName'],
        path_params=['projectId', 'repoName'],
        query_params=['repoId_uid', 'revisionIds'],
        relative_path='v1/projects/{projectId}/repos/{repoName}/revisions:batchGet',
        request_field='',
        request_type_name='SourceProjectsReposRevisionsGetBatchGetRequest',
        response_type_name='GetRevisionsResponse',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves all revisions topologically between the starts and ends.
Uses the commit date to break ties in the topology (e.g. when a revision
has two parents).

      Args:
        request: (SourceProjectsReposRevisionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListRevisionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='source.projects.repos.revisions.list',
        ordered_params=['projectId', 'repoName'],
        path_params=['projectId', 'repoName'],
        query_params=['ends', 'pageSize', 'pageToken', 'path', 'repoId_uid', 'starts', 'walkDirection'],
        relative_path='v1/projects/{projectId}/repos/{repoName}/revisions',
        request_field='',
        request_type_name='SourceProjectsReposRevisionsListRequest',
        response_type_name='ListRevisionsResponse',
        supports_download=False,
    )

    def ListFiles(self, request, global_params=None):
      r"""ListFiles returns a list of all files in a SourceContext. The.
information about each file includes its path and its hash.
The result is ordered by path. Pagination is supported.

      Args:
        request: (SourceProjectsReposRevisionsListFilesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListFilesResponse) The response message.
      """
      config = self.GetMethodConfig('ListFiles')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListFiles.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='source.projects.repos.revisions.listFiles',
        ordered_params=['projectId', 'repoName', 'revisionId'],
        path_params=['projectId', 'repoName', 'revisionId'],
        query_params=['pageSize', 'pageToken', 'sourceContext_cloudRepo_aliasContext_kind', 'sourceContext_cloudRepo_aliasContext_name', 'sourceContext_cloudRepo_aliasName', 'sourceContext_cloudRepo_repoId_uid', 'sourceContext_cloudWorkspace_snapshotId', 'sourceContext_cloudWorkspace_workspaceId_name', 'sourceContext_cloudWorkspace_workspaceId_repoId_projectRepoId_projectId', 'sourceContext_cloudWorkspace_workspaceId_repoId_projectRepoId_repoName', 'sourceContext_cloudWorkspace_workspaceId_repoId_uid', 'sourceContext_gerrit_aliasContext_kind', 'sourceContext_gerrit_aliasContext_name', 'sourceContext_gerrit_aliasName', 'sourceContext_gerrit_gerritProject', 'sourceContext_gerrit_hostUri', 'sourceContext_gerrit_revisionId', 'sourceContext_git_revisionId', 'sourceContext_git_url'],
        relative_path='v1/projects/{projectId}/repos/{repoName}/revisions/{revisionId}:listFiles',
        request_field='',
        request_type_name='SourceProjectsReposRevisionsListFilesRequest',
        response_type_name='ListFilesResponse',
        supports_download=False,
    )

  class ProjectsReposWorkspacesFilesService(base_api.BaseApiService):
    """Service class for the projects_repos_workspaces_files resource."""

    _NAME = 'projects_repos_workspaces_files'

    def __init__(self, client):
      super(SourceV1.ProjectsReposWorkspacesFilesService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Read is given a SourceContext and path, and returns.
file or directory information about that path.

      Args:
        request: (SourceProjectsReposWorkspacesFilesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ReadResponse) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectId}/repos/{repoName}/workspaces/{name}/files/{filesId}',
        http_method='GET',
        method_id='source.projects.repos.workspaces.files.get',
        ordered_params=['projectId', 'repoName', 'name', 'path'],
        path_params=['name', 'path', 'projectId', 'repoName'],
        query_params=['pageSize', 'pageToken', 'sourceContext_cloudRepo_aliasContext_kind', 'sourceContext_cloudRepo_aliasContext_name', 'sourceContext_cloudRepo_aliasName', 'sourceContext_cloudRepo_repoId_projectRepoId_projectId', 'sourceContext_cloudRepo_repoId_projectRepoId_repoName', 'sourceContext_cloudRepo_repoId_uid', 'sourceContext_cloudRepo_revisionId', 'sourceContext_cloudWorkspace_snapshotId', 'sourceContext_cloudWorkspace_workspaceId_repoId_uid', 'sourceContext_gerrit_aliasContext_kind', 'sourceContext_gerrit_aliasContext_name', 'sourceContext_gerrit_aliasName', 'sourceContext_gerrit_gerritProject', 'sourceContext_gerrit_hostUri', 'sourceContext_gerrit_revisionId', 'sourceContext_git_revisionId', 'sourceContext_git_url', 'startPosition'],
        relative_path='v1/projects/{projectId}/repos/{repoName}/workspaces/{name}/files/{+path}',
        request_field='',
        request_type_name='SourceProjectsReposWorkspacesFilesGetRequest',
        response_type_name='ReadResponse',
        supports_download=False,
    )

  class ProjectsReposWorkspacesSnapshotsFilesService(base_api.BaseApiService):
    """Service class for the projects_repos_workspaces_snapshots_files resource."""

    _NAME = 'projects_repos_workspaces_snapshots_files'

    def __init__(self, client):
      super(SourceV1.ProjectsReposWorkspacesSnapshotsFilesService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Read is given a SourceContext and path, and returns.
file or directory information about that path.

      Args:
        request: (SourceProjectsReposWorkspacesSnapshotsFilesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ReadResponse) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectId}/repos/{repoName}/workspaces/{name}/snapshots/{snapshotId}/files/{filesId}',
        http_method='GET',
        method_id='source.projects.repos.workspaces.snapshots.files.get',
        ordered_params=['projectId', 'repoName', 'name', 'snapshotId', 'path'],
        path_params=['name', 'path', 'projectId', 'repoName', 'snapshotId'],
        query_params=['pageSize', 'pageToken', 'sourceContext_cloudRepo_aliasContext_kind', 'sourceContext_cloudRepo_aliasContext_name', 'sourceContext_cloudRepo_aliasName', 'sourceContext_cloudRepo_repoId_projectRepoId_projectId', 'sourceContext_cloudRepo_repoId_projectRepoId_repoName', 'sourceContext_cloudRepo_repoId_uid', 'sourceContext_cloudRepo_revisionId', 'sourceContext_cloudWorkspace_workspaceId_repoId_uid', 'sourceContext_gerrit_aliasContext_kind', 'sourceContext_gerrit_aliasContext_name', 'sourceContext_gerrit_aliasName', 'sourceContext_gerrit_gerritProject', 'sourceContext_gerrit_hostUri', 'sourceContext_gerrit_revisionId', 'sourceContext_git_revisionId', 'sourceContext_git_url', 'startPosition'],
        relative_path='v1/projects/{projectId}/repos/{repoName}/workspaces/{name}/snapshots/{snapshotId}/files/{+path}',
        request_field='',
        request_type_name='SourceProjectsReposWorkspacesSnapshotsFilesGetRequest',
        response_type_name='ReadResponse',
        supports_download=False,
    )

  class ProjectsReposWorkspacesSnapshotsService(base_api.BaseApiService):
    """Service class for the projects_repos_workspaces_snapshots resource."""

    _NAME = 'projects_repos_workspaces_snapshots'

    def __init__(self, client):
      super(SourceV1.ProjectsReposWorkspacesSnapshotsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets a workspace snapshot.

      Args:
        request: (SourceProjectsReposWorkspacesSnapshotsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Snapshot) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='source.projects.repos.workspaces.snapshots.get',
        ordered_params=['projectId', 'repoName', 'name', 'snapshotId'],
        path_params=['name', 'projectId', 'repoName', 'snapshotId'],
        query_params=['workspaceId_repoId_uid'],
        relative_path='v1/projects/{projectId}/repos/{repoName}/workspaces/{name}/snapshots/{snapshotId}',
        request_field='',
        request_type_name='SourceProjectsReposWorkspacesSnapshotsGetRequest',
        response_type_name='Snapshot',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all the snapshots made to a workspace, sorted from most recent to.
least recent.

      Args:
        request: (SourceProjectsReposWorkspacesSnapshotsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListSnapshotsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='source.projects.repos.workspaces.snapshots.list',
        ordered_params=['projectId', 'repoName', 'name'],
        path_params=['name', 'projectId', 'repoName'],
        query_params=['pageSize', 'pageToken', 'workspaceId_repoId_uid'],
        relative_path='v1/projects/{projectId}/repos/{repoName}/workspaces/{name}/snapshots',
        request_field='',
        request_type_name='SourceProjectsReposWorkspacesSnapshotsListRequest',
        response_type_name='ListSnapshotsResponse',
        supports_download=False,
    )

    def ListFiles(self, request, global_params=None):
      r"""ListFiles returns a list of all files in a SourceContext. The.
information about each file includes its path and its hash.
The result is ordered by path. Pagination is supported.

      Args:
        request: (SourceProjectsReposWorkspacesSnapshotsListFilesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListFilesResponse) The response message.
      """
      config = self.GetMethodConfig('ListFiles')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListFiles.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='source.projects.repos.workspaces.snapshots.listFiles',
        ordered_params=['projectId', 'repoName', 'name', 'snapshotId'],
        path_params=['name', 'projectId', 'repoName', 'snapshotId'],
        query_params=['pageSize', 'pageToken', 'sourceContext_cloudRepo_aliasContext_kind', 'sourceContext_cloudRepo_aliasContext_name', 'sourceContext_cloudRepo_aliasName', 'sourceContext_cloudRepo_repoId_projectRepoId_projectId', 'sourceContext_cloudRepo_repoId_projectRepoId_repoName', 'sourceContext_cloudRepo_repoId_uid', 'sourceContext_cloudRepo_revisionId', 'sourceContext_cloudWorkspace_workspaceId_repoId_uid', 'sourceContext_gerrit_aliasContext_kind', 'sourceContext_gerrit_aliasContext_name', 'sourceContext_gerrit_aliasName', 'sourceContext_gerrit_gerritProject', 'sourceContext_gerrit_hostUri', 'sourceContext_gerrit_revisionId', 'sourceContext_git_revisionId', 'sourceContext_git_url'],
        relative_path='v1/projects/{projectId}/repos/{repoName}/workspaces/{name}/snapshots/{snapshotId}:listFiles',
        request_field='',
        request_type_name='SourceProjectsReposWorkspacesSnapshotsListFilesRequest',
        response_type_name='ListFilesResponse',
        supports_download=False,
    )

  class ProjectsReposWorkspacesService(base_api.BaseApiService):
    """Service class for the projects_repos_workspaces resource."""

    _NAME = 'projects_repos_workspaces'

    def __init__(self, client):
      super(SourceV1.ProjectsReposWorkspacesService, self).__init__(client)
      self._upload_configs = {
          }

    def CommitWorkspace(self, request, global_params=None):
      r"""Commits some or all of the modified files in a workspace. This creates a.
new revision in the repo with the workspace's contents. Returns ABORTED if the workspace ID
in the request contains a snapshot ID and it is not the same as the
workspace's current snapshot ID or if the workspace is simultaneously
modified by another client.

      Args:
        request: (SourceProjectsReposWorkspacesCommitWorkspaceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Workspace) The response message.
      """
      config = self.GetMethodConfig('CommitWorkspace')
      return self._RunMethod(
          config, request, global_params=global_params)

    CommitWorkspace.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='source.projects.repos.workspaces.commitWorkspace',
        ordered_params=['projectId', 'repoName', 'name'],
        path_params=['name', 'projectId', 'repoName'],
        query_params=[],
        relative_path='v1/projects/{projectId}/repos/{repoName}/workspaces/{name}:commitWorkspace',
        request_field='commitWorkspaceRequest',
        request_type_name='SourceProjectsReposWorkspacesCommitWorkspaceRequest',
        response_type_name='Workspace',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Creates a workspace.

      Args:
        request: (SourceProjectsReposWorkspacesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Workspace) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='source.projects.repos.workspaces.create',
        ordered_params=['projectId', 'repoName'],
        path_params=['projectId', 'repoName'],
        query_params=[],
        relative_path='v1/projects/{projectId}/repos/{repoName}/workspaces',
        request_field='createWorkspaceRequest',
        request_type_name='SourceProjectsReposWorkspacesCreateRequest',
        response_type_name='Workspace',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a workspace. Uncommitted changes are lost. If the workspace does.
not exist, NOT_FOUND is returned. Returns ABORTED when the workspace is
simultaneously modified by another client.

      Args:
        request: (SourceProjectsReposWorkspacesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='source.projects.repos.workspaces.delete',
        ordered_params=['projectId', 'repoName', 'name'],
        path_params=['name', 'projectId', 'repoName'],
        query_params=['currentSnapshotId', 'workspaceId_repoId_uid'],
        relative_path='v1/projects/{projectId}/repos/{repoName}/workspaces/{name}',
        request_field='',
        request_type_name='SourceProjectsReposWorkspacesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns workspace metadata.

      Args:
        request: (SourceProjectsReposWorkspacesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Workspace) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='source.projects.repos.workspaces.get',
        ordered_params=['projectId', 'repoName', 'name'],
        path_params=['name', 'projectId', 'repoName'],
        query_params=['workspaceId_repoId_uid'],
        relative_path='v1/projects/{projectId}/repos/{repoName}/workspaces/{name}',
        request_field='',
        request_type_name='SourceProjectsReposWorkspacesGetRequest',
        response_type_name='Workspace',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Returns all workspaces belonging to a repo.

      Args:
        request: (SourceProjectsReposWorkspacesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListWorkspacesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='source.projects.repos.workspaces.list',
        ordered_params=['projectId', 'repoName'],
        path_params=['projectId', 'repoName'],
        query_params=['repoId_uid', 'view'],
        relative_path='v1/projects/{projectId}/repos/{repoName}/workspaces',
        request_field='',
        request_type_name='SourceProjectsReposWorkspacesListRequest',
        response_type_name='ListWorkspacesResponse',
        supports_download=False,
    )

    def ListFiles(self, request, global_params=None):
      r"""ListFiles returns a list of all files in a SourceContext. The.
information about each file includes its path and its hash.
The result is ordered by path. Pagination is supported.

      Args:
        request: (SourceProjectsReposWorkspacesListFilesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListFilesResponse) The response message.
      """
      config = self.GetMethodConfig('ListFiles')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListFiles.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='source.projects.repos.workspaces.listFiles',
        ordered_params=['projectId', 'repoName', 'name'],
        path_params=['name', 'projectId', 'repoName'],
        query_params=['pageSize', 'pageToken', 'sourceContext_cloudRepo_aliasContext_kind', 'sourceContext_cloudRepo_aliasContext_name', 'sourceContext_cloudRepo_aliasName', 'sourceContext_cloudRepo_repoId_projectRepoId_projectId', 'sourceContext_cloudRepo_repoId_projectRepoId_repoName', 'sourceContext_cloudRepo_repoId_uid', 'sourceContext_cloudRepo_revisionId', 'sourceContext_cloudWorkspace_snapshotId', 'sourceContext_cloudWorkspace_workspaceId_repoId_uid', 'sourceContext_gerrit_aliasContext_kind', 'sourceContext_gerrit_aliasContext_name', 'sourceContext_gerrit_aliasName', 'sourceContext_gerrit_gerritProject', 'sourceContext_gerrit_hostUri', 'sourceContext_gerrit_revisionId', 'sourceContext_git_revisionId', 'sourceContext_git_url'],
        relative_path='v1/projects/{projectId}/repos/{repoName}/workspaces/{name}:listFiles',
        request_field='',
        request_type_name='SourceProjectsReposWorkspacesListFilesRequest',
        response_type_name='ListFilesResponse',
        supports_download=False,
    )

    def ModifyWorkspace(self, request, global_params=None):
      r"""Applies an ordered sequence of file modification actions to a workspace.
Returns ABORTED if current_snapshot_id in the request does not refer to
the most recent update to the workspace or if the workspace is
simultaneously modified by another client.

      Args:
        request: (SourceProjectsReposWorkspacesModifyWorkspaceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Workspace) The response message.
      """
      config = self.GetMethodConfig('ModifyWorkspace')
      return self._RunMethod(
          config, request, global_params=global_params)

    ModifyWorkspace.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='source.projects.repos.workspaces.modifyWorkspace',
        ordered_params=['projectId', 'repoName', 'name'],
        path_params=['name', 'projectId', 'repoName'],
        query_params=[],
        relative_path='v1/projects/{projectId}/repos/{repoName}/workspaces/{name}:modifyWorkspace',
        request_field='modifyWorkspaceRequest',
        request_type_name='SourceProjectsReposWorkspacesModifyWorkspaceRequest',
        response_type_name='Workspace',
        supports_download=False,
    )

    def RefreshWorkspace(self, request, global_params=None):
      r"""Brings a workspace up to date by merging in the changes made between its.
baseline and the revision to which its alias currently refers.
FAILED_PRECONDITION is returned if the alias refers to a revision that is
not a descendant of the workspace baseline, or if the workspace has no
baseline. Returns ABORTED when the workspace is simultaneously modified by
another client.

A refresh may involve merging files in the workspace with files in the
current alias revision. If this merge results in conflicts, then the
workspace is in a merge state: the merge_info field of Workspace will be
populated, and conflicting files in the workspace will contain conflict
markers.

      Args:
        request: (SourceProjectsReposWorkspacesRefreshWorkspaceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Workspace) The response message.
      """
      config = self.GetMethodConfig('RefreshWorkspace')
      return self._RunMethod(
          config, request, global_params=global_params)

    RefreshWorkspace.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='source.projects.repos.workspaces.refreshWorkspace',
        ordered_params=['projectId', 'repoName', 'name'],
        path_params=['name', 'projectId', 'repoName'],
        query_params=[],
        relative_path='v1/projects/{projectId}/repos/{repoName}/workspaces/{name}:refreshWorkspace',
        request_field='refreshWorkspaceRequest',
        request_type_name='SourceProjectsReposWorkspacesRefreshWorkspaceRequest',
        response_type_name='Workspace',
        supports_download=False,
    )

    def ResolveFiles(self, request, global_params=None):
      r"""Marks files modified as part of a merge as having been resolved. Returns.
ABORTED when the workspace is simultaneously modified by another client.

      Args:
        request: (SourceProjectsReposWorkspacesResolveFilesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Workspace) The response message.
      """
      config = self.GetMethodConfig('ResolveFiles')
      return self._RunMethod(
          config, request, global_params=global_params)

    ResolveFiles.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='source.projects.repos.workspaces.resolveFiles',
        ordered_params=['projectId', 'repoName', 'name'],
        path_params=['name', 'projectId', 'repoName'],
        query_params=[],
        relative_path='v1/projects/{projectId}/repos/{repoName}/workspaces/{name}:resolveFiles',
        request_field='resolveFilesRequest',
        request_type_name='SourceProjectsReposWorkspacesResolveFilesRequest',
        response_type_name='Workspace',
        supports_download=False,
    )

    def RevertRefresh(self, request, global_params=None):
      r"""If a call to RefreshWorkspace results in conflicts, use RevertRefresh to.
restore the workspace to the state it was in before the refresh.  Returns
FAILED_PRECONDITION if not preceded by a call to RefreshWorkspace, or if
there are no unresolved conflicts remaining. Returns ABORTED when the
workspace is simultaneously modified by another client.

      Args:
        request: (SourceProjectsReposWorkspacesRevertRefreshRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Workspace) The response message.
      """
      config = self.GetMethodConfig('RevertRefresh')
      return self._RunMethod(
          config, request, global_params=global_params)

    RevertRefresh.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='source.projects.repos.workspaces.revertRefresh',
        ordered_params=['projectId', 'repoName', 'name'],
        path_params=['name', 'projectId', 'repoName'],
        query_params=[],
        relative_path='v1/projects/{projectId}/repos/{repoName}/workspaces/{name}:revertRefresh',
        request_field='revertRefreshRequest',
        request_type_name='SourceProjectsReposWorkspacesRevertRefreshRequest',
        response_type_name='Workspace',
        supports_download=False,
    )

  class ProjectsReposService(base_api.BaseApiService):
    """Service class for the projects_repos resource."""

    _NAME = 'projects_repos'

    def __init__(self, client):
      super(SourceV1.ProjectsReposService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a repo in the given project. The provided repo message should have.
its name field set to the desired repo name. No other repo fields should
be set. Omitting the name is the same as specifying "default"

Repo names must satisfy the regular expression
`a-z{1,61}[a-z0-9]`. (Note that repo names must contain at
least three characters and may not contain underscores.) The special name
"default" is the default repo for the project; this is the repo shown when
visiting the Cloud Developers Console, and can be accessed via git's HTTP
protocol at `https://source.developers.google.com/p/PROJECT_ID`. You may
create other repos with this API and access them at
`https://source.developers.google.com/p/PROJECT_ID/r/NAME`.

      Args:
        request: (Repo) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Repo) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='source.projects.repos.create',
        ordered_params=['projectId'],
        path_params=['projectId'],
        query_params=[],
        relative_path='v1/projects/{projectId}/repos',
        request_field='<request>',
        request_type_name='Repo',
        response_type_name='Repo',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a repo.

      Args:
        request: (SourceProjectsReposDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='source.projects.repos.delete',
        ordered_params=['projectId', 'repoName'],
        path_params=['projectId', 'repoName'],
        query_params=['repoId_uid'],
        relative_path='v1/projects/{projectId}/repos/{repoName}',
        request_field='',
        request_type_name='SourceProjectsReposDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns information about a repo.

      Args:
        request: (SourceProjectsReposGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Repo) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='source.projects.repos.get',
        ordered_params=['projectId', 'repoName'],
        path_params=['projectId', 'repoName'],
        query_params=['repoId_uid'],
        relative_path='v1/projects/{projectId}/repos/{repoName}',
        request_field='',
        request_type_name='SourceProjectsReposGetRequest',
        response_type_name='Repo',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Returns all repos belonging to a project, specified by its project ID. The.
response list is sorted by name with the default repo listed first.

      Args:
        request: (SourceProjectsReposListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListReposResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='source.projects.repos.list',
        ordered_params=['projectId'],
        path_params=['projectId'],
        query_params=[],
        relative_path='v1/projects/{projectId}/repos',
        request_field='',
        request_type_name='SourceProjectsReposListRequest',
        response_type_name='ListReposResponse',
        supports_download=False,
    )

    def Merge(self, request, global_params=None):
      r"""Merges a revision into a movable alias, using a workspace associated with.
that alias to store modified files. The workspace must not have any
modified files. Note that Merge neither creates the workspace nor commits
it; those actions must be done separately. Returns ABORTED when the
workspace is simultaneously modified by another client.

      Args:
        request: (SourceProjectsReposMergeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Workspace) The response message.
      """
      config = self.GetMethodConfig('Merge')
      return self._RunMethod(
          config, request, global_params=global_params)

    Merge.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='source.projects.repos.merge',
        ordered_params=['projectId', 'repoName'],
        path_params=['projectId', 'repoName'],
        query_params=[],
        relative_path='v1/projects/{projectId}/repos/{repoName}:merge',
        request_field='mergeRequest',
        request_type_name='SourceProjectsReposMergeRequest',
        response_type_name='Workspace',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates an existing repo. The only things you can change about a repo are:.
  1) its repo_sync_config (and then only to add one that is not present);
  2) its last-updated time; and
  3) its name (deprecated and going away b/32283418).

      Args:
        request: (SourceProjectsReposUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Repo) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='source.projects.repos.update',
        ordered_params=['projectId', 'repoName'],
        path_params=['projectId', 'repoName'],
        query_params=[],
        relative_path='v1/projects/{projectId}/repos/{repoName}',
        request_field='updateRepoRequest',
        request_type_name='SourceProjectsReposUpdateRequest',
        response_type_name='Repo',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(SourceV1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }

  class V1Service(base_api.BaseApiService):
    """Service class for the v1 resource."""

    _NAME = 'v1'

    def __init__(self, client):
      super(SourceV1.V1Service, self).__init__(client)
      self._upload_configs = {
          }

    def ListChangedFiles(self, request, global_params=None):
      r"""ListChangedFiles computes the files that have changed between two revisions.
or workspace snapshots in the same repo. It returns a list of
ChangeFileInfos.

ListChangedFiles does not perform copy/rename detection, so the from_path of
ChangeFileInfo is unset. Examine the changed_files field of the Revision
resource to determine copy/rename information.

The result is ordered by path. Pagination is supported.

      Args:
        request: (ListChangedFilesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListChangedFilesResponse) The response message.
      """
      config = self.GetMethodConfig('ListChangedFiles')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListChangedFiles.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='source.listChangedFiles',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path='v1:listChangedFiles',
        request_field='<request>',
        request_type_name='ListChangedFilesRequest',
        response_type_name='ListChangedFilesResponse',
        supports_download=False,
    )
