/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.InputStream;
import org.armedbear.lisp.ControlTransfer;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.Function;
import org.armedbear.lisp.JavaClassLoader;
import org.armedbear.lisp.JavaObject;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Pathname;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Symbol;

public class FaslClassLoader
extends JavaClassLoader {
    private final String baseName;
    private final JavaObject boxedThis = new JavaObject(this);
    private static final Primitive MAKE_FASL_CLASS_LOADER = new pf_make_fasl_class_loader();
    private static final Primitive GET_FASL_FUNCTION = new pf_get_fasl_function();

    public FaslClassLoader(String baseName) {
        this.baseName = baseName;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name.startsWith(this.baseName + "_")) {
            Class<?> c;
            Object internalName = name.replace(".", "/");
            if (!((String)internalName).contains("/")) {
                internalName = "org/armedbear/lisp/" + (String)internalName;
            }
            if ((c = this.findLoadedClass((String)internalName)) == null && checkPreCompiledClassLoader && (c = this.findPrecompiledClassOrNull(name)) != null) {
                return c;
            }
            if (c == null) {
                c = this.findClass(name);
            }
            if (c != null) {
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
        }
        return super.loadClass(name, resolve);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            Class<?> c;
            if (checkPreCompiledClassLoader && (c = this.findPrecompiledClassOrNull(name)) != null) {
                return c;
            }
            byte[] b = this.getFunctionClassBytes(name);
            return this.defineLispClass(name, b, 0, b.length);
        }
        catch (Throwable e) {
            e.printStackTrace();
            if (e instanceof ControlTransfer) {
                throw (ControlTransfer)e;
            }
            throw new ClassNotFoundException("Function class not found: " + name, e);
        }
    }

    @Override
    public InputStream getResourceAsStream(String resourceName) {
        LispThread thread = LispThread.currentThread();
        Pathname name = Pathname.create(resourceName.substring("org/armedbear/lisp/".length()));
        LispObject truenameFasl = Symbol.LOAD_TRUENAME_FASL.symbolValue(thread);
        LispObject truename = Symbol.LOAD_TRUENAME.symbolValue(thread);
        if (truenameFasl instanceof Pathname) {
            return Pathname.mergePathnames(name, (Pathname)truenameFasl, Keyword.NEWEST).getInputStream();
        }
        if (truename instanceof Pathname) {
            return Pathname.mergePathnames(name, (Pathname)truename, Keyword.NEWEST).getInputStream();
        }
        if (!Symbol.PROBE_FILE.execute(name).equals(Lisp.NIL)) {
            return name.getInputStream();
        }
        return null;
    }

    public LispObject loadFunction(int fnNumber) {
        String name = this.baseName + "_" + (fnNumber + 1);
        try {
            Class<?> clz = this.loadClass(name);
            Function f = (Function)clz.newInstance();
            if (clz.getClassLoader() instanceof JavaClassLoader) {
                f.setClassBytes(this.getFunctionClassBytes(name));
            }
            return f;
        }
        catch (Throwable e) {
            if (e instanceof ControlTransfer) {
                throw (ControlTransfer)e;
            }
            Debug.trace(e);
            return Lisp.error(new LispError("Compiled function can't be loaded: " + name + " from " + String.valueOf(Symbol.LOAD_TRUENAME.symbolValue())));
        }
    }

    private static final class pf_get_fasl_function
    extends Primitive {
        pf_get_fasl_function() {
            super("get-fasl-function", Lisp.PACKAGE_SYS, false, "loader function-number");
        }

        @Override
        public LispObject execute(LispObject loader, LispObject fnNumber) {
            FaslClassLoader l = (FaslClassLoader)loader.javaInstance(FaslClassLoader.class);
            return l.loadFunction(fnNumber.intValue());
        }
    }

    private static final class pf_make_fasl_class_loader
    extends Primitive {
        pf_make_fasl_class_loader() {
            super("make-fasl-class-loader", Lisp.PACKAGE_SYS, false, "base-name");
        }

        @Override
        public LispObject execute(LispObject baseName) {
            return new FaslClassLoader((String)baseName.getStringValue()).boxedThis;
        }
    }
}

