/*
 * Decompiled with CFR 0.152.
 */
package brut.directory;

import brut.directory.AbstractDirectory$ParsedPath;
import brut.directory.AbstractDirectory$SubPath;
import brut.directory.DirUtils;
import brut.directory.PathAlreadyExists;
import brut.directory.PathNotExist;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractDirectory {
    public LinkedHashSet mFiles;
    public LinkedHashSet mFilesRecursive;
    public LinkedHashMap mDirs;

    public final Set getFiles(boolean bl) {
        if (this.mFiles == null) {
            this.loadFiles();
        }
        if (!bl) {
            return this.mFiles;
        }
        if (this.mFilesRecursive == null) {
            this.mFilesRecursive = new LinkedHashSet(this.mFiles);
            for (Map.Entry entry : this.getAbstractDirs(false).entrySet()) {
                for (String string : ((AbstractDirectory)entry.getValue()).getFiles(true)) {
                    this.mFilesRecursive.add((String)entry.getKey() + '/' + string);
                }
            }
        }
        return this.mFilesRecursive;
    }

    public final boolean containsFile(String object) {
        try {
            object = this.getSubPath((String)object);
            AbstractDirectory abstractDirectory = ((AbstractDirectory$SubPath)object).dir;
            if (abstractDirectory != null) {
                return abstractDirectory.containsFile(((AbstractDirectory$SubPath)object).path);
            }
            return this.getFiles(false).contains(((AbstractDirectory$SubPath)object).path);
        }
        catch (PathNotExist pathNotExist) {
            return false;
        }
    }

    public final boolean containsDir(String object) {
        try {
            object = this.getSubPath((String)object);
            AbstractDirectory abstractDirectory = ((AbstractDirectory$SubPath)object).dir;
            if (abstractDirectory != null) {
                return abstractDirectory.containsDir(((AbstractDirectory$SubPath)object).path);
            }
            return this.getAbstractDirs(false).containsKey(((AbstractDirectory$SubPath)object).path);
        }
        catch (PathNotExist pathNotExist) {
            return false;
        }
    }

    public final InputStream getFileInput(String string) {
        AbstractDirectory$SubPath abstractDirectory$SubPath = this.getSubPath(string);
        AbstractDirectory abstractDirectory = abstractDirectory$SubPath.dir;
        if (abstractDirectory != null) {
            return abstractDirectory.getFileInput(abstractDirectory$SubPath.path);
        }
        if (this.getFiles(false).contains(abstractDirectory$SubPath.path)) {
            return this.getFileInputLocal(abstractDirectory$SubPath.path);
        }
        throw new PathNotExist(string);
    }

    public final OutputStream getFileOutput(String string) {
        AbstractDirectory abstractDirectory;
        AbstractDirectory$ParsedPath abstractDirectory$ParsedPath;
        int n = string.indexOf(47);
        if (n == -1) {
            AbstractDirectory$ParsedPath abstractDirectory$ParsedPath2;
            abstractDirectory$ParsedPath = abstractDirectory$ParsedPath2;
            abstractDirectory$ParsedPath2 = new AbstractDirectory$ParsedPath(null, string);
        } else {
            AbstractDirectory$ParsedPath abstractDirectory$ParsedPath3;
            AbstractDirectory$ParsedPath abstractDirectory$ParsedPath4 = abstractDirectory$ParsedPath3;
            String string2 = string;
            string = string.substring(0, n);
            abstractDirectory$ParsedPath3 = new AbstractDirectory$ParsedPath(string, string2.substring(n + 1));
            abstractDirectory$ParsedPath = abstractDirectory$ParsedPath4;
        }
        string = abstractDirectory$ParsedPath.dir;
        if (string == null) {
            abstractDirectory.getFiles(false).add(abstractDirectory$ParsedPath.subpath);
            return abstractDirectory.getFileOutputLocal(abstractDirectory$ParsedPath.subpath);
        }
        try {
            abstractDirectory = abstractDirectory.createDir(string);
        }
        catch (PathAlreadyExists pathAlreadyExists) {
            abstractDirectory = (AbstractDirectory)abstractDirectory.getAbstractDirs(false).get(abstractDirectory$ParsedPath.dir);
        }
        return abstractDirectory.getFileOutput(abstractDirectory$ParsedPath.subpath);
    }

    public final AbstractDirectory getDir(String string) {
        AbstractDirectory$SubPath abstractDirectory$SubPath = this.getSubPath(string);
        AbstractDirectory abstractDirectory = abstractDirectory$SubPath.dir;
        if (abstractDirectory != null) {
            return abstractDirectory.getDir(abstractDirectory$SubPath.path);
        }
        if (this.getAbstractDirs(false).containsKey(abstractDirectory$SubPath.path)) {
            return (AbstractDirectory)this.getAbstractDirs(false).get(abstractDirectory$SubPath.path);
        }
        throw new PathNotExist(string);
    }

    public final AbstractDirectory createDir(String object) {
        AbstractDirectory abstractDirectory;
        Object object2;
        int n = ((String)object).indexOf(47);
        if (n == -1) {
            AbstractDirectory$ParsedPath abstractDirectory$ParsedPath;
            object2 = abstractDirectory$ParsedPath;
            abstractDirectory$ParsedPath = new AbstractDirectory$ParsedPath(null, (String)object);
        } else {
            AbstractDirectory$ParsedPath abstractDirectory$ParsedPath;
            AbstractDirectory$ParsedPath abstractDirectory$ParsedPath2 = abstractDirectory$ParsedPath;
            object2 = ((String)object).substring(0, n);
            abstractDirectory$ParsedPath = new AbstractDirectory$ParsedPath((String)object2, ((String)object).substring(n + 1));
            object2 = abstractDirectory$ParsedPath2;
        }
        if (((AbstractDirectory$ParsedPath)object2).dir == null) {
            if (!abstractDirectory.getAbstractDirs(false).containsKey(((AbstractDirectory$ParsedPath)object2).subpath)) {
                object = abstractDirectory.createDirLocal(((AbstractDirectory$ParsedPath)object2).subpath);
                abstractDirectory.getAbstractDirs(false).put(((AbstractDirectory$ParsedPath)object2).subpath, object);
                return object;
            }
            throw new PathAlreadyExists((String)object);
        }
        if (abstractDirectory.getAbstractDirs(false).containsKey(((AbstractDirectory$ParsedPath)object2).dir)) {
            abstractDirectory = (AbstractDirectory)abstractDirectory.getAbstractDirs(false).get(((AbstractDirectory$ParsedPath)object2).dir);
        } else {
            AbstractDirectory abstractDirectory2 = abstractDirectory;
            abstractDirectory = abstractDirectory2.createDirLocal(((AbstractDirectory$ParsedPath)object2).dir);
            abstractDirectory2.getAbstractDirs(false).put(((AbstractDirectory$ParsedPath)object2).dir, abstractDirectory);
        }
        return abstractDirectory.createDir(((AbstractDirectory$ParsedPath)object2).subpath);
    }

    public final boolean removeFile(String object) {
        try {
            object = this.getSubPath((String)object);
            AbstractDirectory abstractDirectory = ((AbstractDirectory$SubPath)object).dir;
            if (abstractDirectory != null) {
                return abstractDirectory.removeFile(((AbstractDirectory$SubPath)object).path);
            }
            if (!this.getFiles(false).contains(((AbstractDirectory$SubPath)object).path)) {
                return false;
            }
            AbstractDirectory abstractDirectory2 = this;
            abstractDirectory2.removeFileLocal(((AbstractDirectory$SubPath)object).path);
            abstractDirectory2.getFiles(false).remove(((AbstractDirectory$SubPath)object).path);
        }
        catch (PathNotExist pathNotExist) {
            return false;
        }
        return true;
    }

    public final void copyToDir(File file) {
        for (String string : this.getFiles(true)) {
            DirUtils.copyToDir(this, file, string, string);
        }
    }

    public int getCompressionLevel(String string) {
        return -1;
    }

    public final LinkedHashMap getAbstractDirs(boolean bl) {
        LinkedHashMap<String, AbstractDirectory> linkedHashMap;
        if (((AbstractDirectory)this).mDirs == null) {
            ((AbstractDirectory)this).loadDirs();
        }
        if (!bl) {
            return ((AbstractDirectory)this).mDirs;
        }
        LinkedHashMap<String, AbstractDirectory> linkedHashMap2 = linkedHashMap;
        linkedHashMap = new LinkedHashMap<String, AbstractDirectory>(((AbstractDirectory)this).mDirs);
        for (Map.Entry entry : ((AbstractDirectory)this).mDirs.entrySet()) {
            for (Map.Entry entry2 : ((AbstractDirectory)entry.getValue()).getAbstractDirs(true).entrySet()) {
                linkedHashMap2.put((String)entry.getKey() + '/' + (String)entry2.getKey(), (AbstractDirectory)entry2.getValue());
            }
        }
        return linkedHashMap2;
    }

    public void close() {
    }

    public abstract void loadFiles();

    public abstract void loadDirs();

    public abstract InputStream getFileInputLocal(String var1);

    public abstract OutputStream getFileOutputLocal(String var1);

    public abstract AbstractDirectory createDirLocal(String var1);

    public abstract void removeFileLocal(String var1);

    public final AbstractDirectory$SubPath getSubPath(String string) {
        Object object;
        int n = string.indexOf(47);
        if (n == -1) {
            AbstractDirectory$ParsedPath abstractDirectory$ParsedPath;
            object = abstractDirectory$ParsedPath;
            abstractDirectory$ParsedPath = new AbstractDirectory$ParsedPath(null, string);
        } else {
            AbstractDirectory$ParsedPath abstractDirectory$ParsedPath;
            AbstractDirectory$ParsedPath abstractDirectory$ParsedPath2 = abstractDirectory$ParsedPath;
            object = string.substring(0, n);
            abstractDirectory$ParsedPath = new AbstractDirectory$ParsedPath((String)object, string.substring(n + 1));
            object = abstractDirectory$ParsedPath2;
        }
        if (((AbstractDirectory$ParsedPath)object).dir == null) {
            return new AbstractDirectory$SubPath(null, ((AbstractDirectory$ParsedPath)object).subpath);
        }
        if (abstractDirectory.getAbstractDirs(false).containsKey(((AbstractDirectory$ParsedPath)object).dir)) {
            AbstractDirectory abstractDirectory = (AbstractDirectory)abstractDirectory.getAbstractDirs(false).get(((AbstractDirectory$ParsedPath)object).dir);
            return new AbstractDirectory$SubPath(abstractDirectory, ((AbstractDirectory$ParsedPath)object).subpath);
        }
        throw new PathNotExist(string);
    }

    public abstract long getSize(String var1);
}

