/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.universe;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.impl.ProvisioningUtil;
import org.jboss.galleon.repo.RepositoryArtifactResolver;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseFactoryLoader;
import org.jboss.galleon.universe.UniverseResolver;

public abstract class UniverseResolverBuilder<T extends UniverseResolverBuilder<?>> {
    protected UniverseFactoryLoader ufl;
    protected Map<FeaturePackLocation.FPID, Path> localFeaturePacks = new HashMap<FeaturePackLocation.FPID, Path>();

    public T setUniverseFactoryLoader(UniverseFactoryLoader ufl) throws ProvisioningException {
        if (this.ufl != null) {
            throw new ProvisioningException("Universe factory loader has already been initialized");
        }
        this.ufl = ufl;
        return (T)this;
    }

    public T addArtifactResolver(RepositoryArtifactResolver artifactResolver) throws ProvisioningException {
        return this.addArtifactResolver(artifactResolver.getRepositoryId(), artifactResolver);
    }

    public T addArtifactResolver(String repoId, RepositoryArtifactResolver artifactResolver) throws ProvisioningException {
        this.getUfl().addArtifactResolver(repoId, artifactResolver);
        return (T)this;
    }

    protected UniverseResolver buildUniverseResolver() throws ProvisioningException {
        return new UniverseResolver(this);
    }

    protected UniverseFactoryLoader getUfl() throws ProvisioningException {
        if (this.ufl == null) {
            this.ufl = UniverseFactoryLoader.getInstance();
        }
        return this.ufl;
    }

    public T addLocalFeaturePack(Path path) throws ProvisioningException {
        if (path == null) {
            return (T)this;
        }
        try {
            this.getLocalFeaturePacks().put(ProvisioningUtil.getFeaturePackProducer(path), path);
            return (T)this;
        }
        catch (Exception e) {
            throw new ProvisioningException(e);
        }
    }

    protected Map<FeaturePackLocation.FPID, Path> getLocalFeaturePacks() {
        return this.localFeaturePacks;
    }
}

