/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.EllipseIterator;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;

public abstract class Ellipse2D
extends RectangularShape {
    protected Ellipse2D() {
    }

    public boolean contains(double d, double d2) {
        double d3 = this.getWidth();
        if (d3 <= 0.0) {
            return false;
        }
        double d4 = (d - this.getX()) / d3 - 0.5;
        double d5 = this.getHeight();
        if (d5 <= 0.0) {
            return false;
        }
        double d6 = (d2 - this.getY()) / d5 - 0.5;
        return d4 * d4 + d6 * d6 < 0.25;
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        if (d3 <= 0.0 || d4 <= 0.0) {
            return false;
        }
        double d5 = this.getWidth();
        if (d5 <= 0.0) {
            return false;
        }
        double d6 = (d - this.getX()) / d5 - 0.5;
        double d7 = d6 + d3 / d5;
        double d8 = this.getHeight();
        if (d8 <= 0.0) {
            return false;
        }
        double d9 = (d2 - this.getY()) / d8 - 0.5;
        double d10 = d9 + d4 / d8;
        double d11 = d6 > 0.0 ? d6 : (d7 < 0.0 ? d7 : 0.0);
        double d12 = d9 > 0.0 ? d9 : (d10 < 0.0 ? d10 : 0.0);
        return d11 * d11 + d12 * d12 < 0.25;
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        return this.contains(d, d2) && this.contains(d + d3, d2) && this.contains(d, d2 + d4) && this.contains(d + d3, d2 + d4);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new EllipseIterator(this, affineTransform);
    }

    public int hashCode() {
        long l = java.lang.Double.doubleToLongBits(this.getX());
        l += java.lang.Double.doubleToLongBits(this.getY()) * 37L;
        l += java.lang.Double.doubleToLongBits(this.getWidth()) * 43L;
        return (int)(l += java.lang.Double.doubleToLongBits(this.getHeight()) * 47L) ^ (int)(l >> 32);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Ellipse2D) {
            Ellipse2D ellipse2D = (Ellipse2D)object;
            return this.getX() == ellipse2D.getX() && this.getY() == ellipse2D.getY() && this.getWidth() == ellipse2D.getWidth() && this.getHeight() == ellipse2D.getHeight();
        }
        return false;
    }

    public static class Double
    extends Ellipse2D
    implements Serializable {
        public double x;
        public double y;
        public double width;
        public double height;
        private static final long serialVersionUID = 5555464816372320683L;

        public Double() {
        }

        public Double(double d, double d2, double d3, double d4) {
            this.setFrame(d, d2, d3, d4);
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean isEmpty() {
            return this.width <= 0.0 || this.height <= 0.0;
        }

        public void setFrame(double d, double d2, double d3, double d4) {
            this.x = d;
            this.y = d2;
            this.width = d3;
            this.height = d4;
        }

        public Rectangle2D getBounds2D() {
            return new Rectangle2D.Double(this.x, this.y, this.width, this.height);
        }
    }

    public static class Float
    extends Ellipse2D
    implements Serializable {
        public float x;
        public float y;
        public float width;
        public float height;
        private static final long serialVersionUID = -6633761252372475977L;

        public Float() {
        }

        public Float(float f, float f2, float f3, float f4) {
            this.setFrame(f, f2, f3, f4);
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean isEmpty() {
            return (double)this.width <= 0.0 || (double)this.height <= 0.0;
        }

        public void setFrame(float f, float f2, float f3, float f4) {
            this.x = f;
            this.y = f2;
            this.width = f3;
            this.height = f4;
        }

        public void setFrame(double d, double d2, double d3, double d4) {
            this.x = (float)d;
            this.y = (float)d2;
            this.width = (float)d3;
            this.height = (float)d4;
        }

        public Rectangle2D getBounds2D() {
            return new Rectangle2D.Float(this.x, this.y, this.width, this.height);
        }
    }
}

