/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.log;

import java.io.IOException;
import java.io.InputStream;

public class LogInputStream
extends InputStream {
    private InputStream in;
    private int length;

    public LogInputStream(InputStream inputStream, int n) throws IOException {
        this.in = inputStream;
        this.length = n;
    }

    public int read() throws IOException {
        if (this.length == 0) {
            return -1;
        }
        int n = this.in.read();
        this.length = n != -1 ? this.length - 1 : 0;
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.length == 0) {
            return -1;
        }
        n2 = this.length < n2 ? this.length : n2;
        int n3 = this.in.read(byArray, n, n2);
        this.length = n3 != -1 ? this.length - n3 : 0;
        return n3;
    }

    public long skip(long l) throws IOException {
        if (l > Integer.MAX_VALUE) {
            throw new IOException("Too many bytes to skip - " + l);
        }
        if (this.length == 0) {
            return 0L;
        }
        l = (long)this.length < l ? (long)this.length : l;
        l = this.in.skip(l);
        this.length = (int)((long)this.length - l);
        return l;
    }

    public int available() throws IOException {
        int n = this.in.available();
        return this.length < n ? this.length : n;
    }

    public void close() {
        this.length = 0;
    }

    protected void finalize() throws IOException {
        this.close();
    }
}

