/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.fastinfoset.util;

import com.sun.xml.internal.fastinfoset.CommonResourceBundle;
import com.sun.xml.internal.fastinfoset.util.KeyIntMap;
import com.sun.xml.internal.fastinfoset.util.ValueArray;
import com.sun.xml.internal.fastinfoset.util.ValueArrayResourceException;
import com.sun.xml.internal.org.jvnet.fastinfoset.FastInfosetException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PrefixArray
extends ValueArray {
    public static final int PREFIX_MAP_SIZE = 64;
    private int _initialCapacity;
    public String[] _array;
    private PrefixArray _readOnlyArray;
    private PrefixEntry[] _prefixMap = new PrefixEntry[64];
    private PrefixEntry _prefixPool;
    private NamespaceEntry _namespacePool;
    private NamespaceEntry[] _inScopeNamespaces;
    public int[] _currentInScope;
    public int _declarationId;

    public PrefixArray(int n, int n2) {
        this._initialCapacity = n;
        this._maximumCapacity = n2;
        this._array = new String[n];
        this._inScopeNamespaces = new NamespaceEntry[n + 2];
        this._currentInScope = new int[n + 2];
        this.increaseNamespacePool(n);
        this.increasePrefixPool(n);
        this.initializeEntries();
    }

    public PrefixArray() {
        this(10, Integer.MAX_VALUE);
    }

    private final void initializeEntries() {
        this._inScopeNamespaces[0] = this._namespacePool;
        this._namespacePool = this._namespacePool.next;
        this._inScopeNamespaces[0].next = null;
        this._inScopeNamespaces[0].prefix = "";
        this._inScopeNamespaces[0].namespaceName = "";
        this._currentInScope[0] = 0;
        this._inScopeNamespaces[0].namespaceIndex = 0;
        int n = KeyIntMap.indexFor(KeyIntMap.hashHash(this._inScopeNamespaces[0].prefix.hashCode()), this._prefixMap.length);
        this._prefixMap[n] = this._prefixPool;
        this._prefixPool = this._prefixPool.next;
        this._prefixMap[n].next = null;
        this._prefixMap[n].prefixId = 0;
        this._inScopeNamespaces[1] = this._namespacePool;
        this._namespacePool = this._namespacePool.next;
        this._inScopeNamespaces[1].next = null;
        this._inScopeNamespaces[1].prefix = "xml";
        this._inScopeNamespaces[1].namespaceName = "http://www.w3.org/XML/1998/namespace";
        this._currentInScope[1] = 1;
        this._inScopeNamespaces[1].namespaceIndex = 1;
        n = KeyIntMap.indexFor(KeyIntMap.hashHash(this._inScopeNamespaces[1].prefix.hashCode()), this._prefixMap.length);
        if (this._prefixMap[n] == null) {
            this._prefixMap[n] = this._prefixPool;
            this._prefixPool = this._prefixPool.next;
            this._prefixMap[n].next = null;
        } else {
            PrefixEntry prefixEntry = this._prefixMap[n];
            this._prefixMap[n] = this._prefixPool;
            this._prefixPool = this._prefixPool.next;
            this._prefixMap[n].next = prefixEntry;
        }
        this._prefixMap[n].prefixId = 1;
    }

    private final void increaseNamespacePool(int n) {
        if (this._namespacePool == null) {
            this._namespacePool = new NamespaceEntry();
        }
        for (int i = 0; i < n; ++i) {
            NamespaceEntry namespaceEntry = new NamespaceEntry();
            namespaceEntry.next = this._namespacePool;
            this._namespacePool = namespaceEntry;
        }
    }

    private final void increasePrefixPool(int n) {
        if (this._prefixPool == null) {
            this._prefixPool = new PrefixEntry();
        }
        for (int i = 0; i < n; ++i) {
            PrefixEntry prefixEntry = new PrefixEntry();
            prefixEntry.next = this._prefixPool;
            this._prefixPool = prefixEntry;
        }
    }

    public int countNamespacePool() {
        int n = 0;
        NamespaceEntry namespaceEntry = this._namespacePool;
        while (namespaceEntry != null) {
            ++n;
            namespaceEntry = namespaceEntry.next;
        }
        return n;
    }

    public int countPrefixPool() {
        int n = 0;
        PrefixEntry prefixEntry = this._prefixPool;
        while (prefixEntry != null) {
            ++n;
            prefixEntry = prefixEntry.next;
        }
        return n;
    }

    public final void clear() {
        for (int i = this._readOnlyArraySize; i < this._size; ++i) {
            this._array[i] = null;
        }
        this._size = this._readOnlyArraySize;
    }

    public final void clearCompletely() {
        int n;
        this._prefixPool = null;
        this._namespacePool = null;
        for (n = 0; n < this._size + 2; ++n) {
            this._currentInScope[n] = 0;
            this._inScopeNamespaces[n] = null;
        }
        for (n = 0; n < this._prefixMap.length; ++n) {
            this._prefixMap[n] = null;
        }
        this.increaseNamespacePool(this._initialCapacity);
        this.increasePrefixPool(this._initialCapacity);
        this.initializeEntries();
        this._declarationId = 0;
        this.clear();
    }

    public final String[] getArray() {
        return this._array;
    }

    public final void setReadOnlyArray(ValueArray valueArray, boolean bl) {
        if (!(valueArray instanceof PrefixArray)) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.illegalClass", new Object[]{valueArray}));
        }
        this.setReadOnlyArray((PrefixArray)valueArray, bl);
    }

    public final void setReadOnlyArray(PrefixArray prefixArray, boolean bl) {
        if (prefixArray != null) {
            this._readOnlyArray = prefixArray;
            this._readOnlyArraySize = prefixArray.getSize();
            this.clearCompletely();
            this._inScopeNamespaces = new NamespaceEntry[this._readOnlyArraySize + this._inScopeNamespaces.length];
            this._currentInScope = new int[this._readOnlyArraySize + this._currentInScope.length];
            this.initializeEntries();
            if (bl) {
                this.clear();
            }
            this._array = this.getCompleteArray();
            this._size = this._readOnlyArraySize;
        }
    }

    public final String[] getCompleteArray() {
        if (this._readOnlyArray == null) {
            return this._array;
        }
        String[] stringArray = this._readOnlyArray.getCompleteArray();
        String[] stringArray2 = new String[this._readOnlyArraySize + this._array.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, this._readOnlyArraySize);
        return stringArray2;
    }

    public final String get(int n) {
        return this._array[n];
    }

    public final int add(String string) {
        if (this._size == this._array.length) {
            this.resize();
        }
        this._array[this._size++] = string;
        return this._size;
    }

    protected final void resize() {
        if (this._size == this._maximumCapacity) {
            throw new ValueArrayResourceException(CommonResourceBundle.getInstance().getString("message.arrayMaxCapacity"));
        }
        int n = this._size * 3 / 2 + 1;
        if (n > this._maximumCapacity) {
            n = this._maximumCapacity;
        }
        String[] stringArray = new String[n];
        System.arraycopy(this._array, 0, stringArray, 0, this._size);
        this._array = stringArray;
        NamespaceEntry[] namespaceEntryArray = new NamespaceEntry[n += 2];
        System.arraycopy(this._inScopeNamespaces, 0, namespaceEntryArray, 0, this._inScopeNamespaces.length);
        this._inScopeNamespaces = namespaceEntryArray;
        int[] nArray = new int[n];
        System.arraycopy(this._currentInScope, 0, nArray, 0, this._currentInScope.length);
        this._currentInScope = nArray;
    }

    public final void clearDeclarationIds() {
        for (int i = 0; i < this._size; ++i) {
            NamespaceEntry namespaceEntry = this._inScopeNamespaces[i];
            if (namespaceEntry == null) continue;
            namespaceEntry.declarationId = 0;
        }
        this._declarationId = 1;
    }

    public final void pushScope(int n, int n2) throws FastInfosetException {
        NamespaceEntry namespaceEntry;
        if (this._namespacePool == null) {
            this.increaseNamespacePool(16);
        }
        NamespaceEntry namespaceEntry2 = this._namespacePool;
        this._namespacePool = namespaceEntry2.next;
        if ((namespaceEntry = this._inScopeNamespaces[++n]) == null) {
            namespaceEntry2.declarationId = this._declarationId;
            this._currentInScope[n] = ++n2;
            namespaceEntry2.namespaceIndex = this._currentInScope[n];
            namespaceEntry2.next = null;
            this._inScopeNamespaces[n] = namespaceEntry2;
        } else if (namespaceEntry.declarationId < this._declarationId) {
            namespaceEntry2.declarationId = this._declarationId;
            this._currentInScope[n] = ++n2;
            namespaceEntry2.namespaceIndex = this._currentInScope[n];
            namespaceEntry2.next = namespaceEntry;
            namespaceEntry.declarationId = 0;
            this._inScopeNamespaces[n] = namespaceEntry2;
        } else {
            throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.duplicateNamespaceAttribute"));
        }
    }

    public final void pushScopeWithPrefixEntry(String string, String string2, int n, int n2) throws FastInfosetException {
        NamespaceEntry namespaceEntry;
        if (this._namespacePool == null) {
            this.increaseNamespacePool(16);
        }
        if (this._prefixPool == null) {
            this.increasePrefixPool(16);
        }
        NamespaceEntry namespaceEntry2 = this._namespacePool;
        this._namespacePool = namespaceEntry2.next;
        if ((namespaceEntry = this._inScopeNamespaces[++n]) == null) {
            namespaceEntry2.declarationId = this._declarationId;
            this._currentInScope[n] = ++n2;
            namespaceEntry2.namespaceIndex = this._currentInScope[n];
            namespaceEntry2.next = null;
            this._inScopeNamespaces[n] = namespaceEntry2;
        } else if (namespaceEntry.declarationId < this._declarationId) {
            namespaceEntry2.declarationId = this._declarationId;
            this._currentInScope[n] = ++n2;
            namespaceEntry2.namespaceIndex = this._currentInScope[n];
            namespaceEntry2.next = namespaceEntry;
            namespaceEntry.declarationId = 0;
            this._inScopeNamespaces[n] = namespaceEntry2;
        } else {
            throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.duplicateNamespaceAttribute"));
        }
        PrefixEntry prefixEntry = this._prefixPool;
        this._prefixPool = this._prefixPool.next;
        prefixEntry.prefixId = n;
        namespaceEntry2.prefix = string;
        namespaceEntry2.namespaceName = string2;
        namespaceEntry2.prefixEntryIndex = KeyIntMap.indexFor(KeyIntMap.hashHash(string.hashCode()), this._prefixMap.length);
        PrefixEntry prefixEntry2 = this._prefixMap[namespaceEntry2.prefixEntryIndex];
        prefixEntry.next = prefixEntry2;
        this._prefixMap[((NamespaceEntry)namespaceEntry2).prefixEntryIndex] = prefixEntry;
    }

    public final void popScope(int n) {
        NamespaceEntry namespaceEntry = this._inScopeNamespaces[++n];
        this._inScopeNamespaces[n] = namespaceEntry.next;
        this._currentInScope[n] = namespaceEntry.next != null ? namespaceEntry.next.namespaceIndex : 0;
        namespaceEntry.next = this._namespacePool;
        this._namespacePool = namespaceEntry;
    }

    public final void popScopeWithPrefixEntry(int n) {
        NamespaceEntry namespaceEntry = this._inScopeNamespaces[++n];
        this._inScopeNamespaces[n] = namespaceEntry.next;
        this._currentInScope[n] = namespaceEntry.next != null ? namespaceEntry.next.namespaceIndex : 0;
        namespaceEntry.prefix = (namespaceEntry.namespaceName = null);
        namespaceEntry.next = this._namespacePool;
        this._namespacePool = namespaceEntry;
        PrefixEntry prefixEntry = this._prefixMap[namespaceEntry.prefixEntryIndex];
        if (prefixEntry.prefixId == n) {
            this._prefixMap[((NamespaceEntry)namespaceEntry).prefixEntryIndex] = prefixEntry.next;
            prefixEntry.next = this._prefixPool;
            this._prefixPool = prefixEntry;
        } else {
            PrefixEntry prefixEntry2 = prefixEntry;
            prefixEntry = prefixEntry.next;
            while (prefixEntry != null) {
                if (prefixEntry.prefixId == n) {
                    prefixEntry2.next = prefixEntry.next;
                    prefixEntry.next = this._prefixPool;
                    this._prefixPool = prefixEntry;
                    break;
                }
                prefixEntry2 = prefixEntry;
                prefixEntry = prefixEntry.next;
            }
        }
    }

    public final String getNamespaceFromPrefix(String string) {
        int n = KeyIntMap.indexFor(KeyIntMap.hashHash(string.hashCode()), this._prefixMap.length);
        PrefixEntry prefixEntry = this._prefixMap[n];
        while (prefixEntry != null) {
            NamespaceEntry namespaceEntry = this._inScopeNamespaces[prefixEntry.prefixId];
            if (string == namespaceEntry.prefix || string.equals(namespaceEntry.prefix)) {
                return namespaceEntry.namespaceName;
            }
            prefixEntry = prefixEntry.next;
        }
        return null;
    }

    public final String getPrefixFromNamespace(String string) {
        int n = 0;
        while (++n < this._size + 2) {
            NamespaceEntry namespaceEntry = this._inScopeNamespaces[n];
            if (namespaceEntry == null || !string.equals(namespaceEntry.namespaceName)) continue;
            return namespaceEntry.prefix;
        }
        return null;
    }

    public final Iterator getPrefixes() {
        return new Iterator(){
            int _position = 1;
            NamespaceEntry _ne = PrefixArray.access$1000(PrefixArray.this)[this._position];

            public boolean hasNext() {
                return this._ne != null;
            }

            public Object next() {
                if (this._position == PrefixArray.this._size + 2) {
                    throw new NoSuchElementException();
                }
                String string = this._ne.prefix;
                this.moveToNext();
                return string;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            private final void moveToNext() {
                while (++this._position < PrefixArray.this._size + 2) {
                    this._ne = PrefixArray.this._inScopeNamespaces[this._position];
                    if (this._ne == null) continue;
                    return;
                }
                this._ne = null;
            }
        };
    }

    public final Iterator getPrefixesFromNamespace(final String string) {
        return new Iterator(){
            String _namespaceName;
            int _position;
            NamespaceEntry _ne;
            {
                this._namespaceName = string;
                this._position = 0;
                this.moveToNext();
            }

            public boolean hasNext() {
                return this._ne != null;
            }

            public Object next() {
                if (this._position == PrefixArray.this._size + 2) {
                    throw new NoSuchElementException();
                }
                String string2 = this._ne.prefix;
                this.moveToNext();
                return string2;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            private final void moveToNext() {
                while (++this._position < PrefixArray.this._size + 2) {
                    this._ne = PrefixArray.this._inScopeNamespaces[this._position];
                    if (this._ne == null || !this._namespaceName.equals(this._ne.namespaceName)) continue;
                    return;
                }
                this._ne = null;
            }
        };
    }

    private static class NamespaceEntry {
        private NamespaceEntry next;
        private int declarationId;
        private int namespaceIndex;
        private String prefix;
        private String namespaceName;
        private int prefixEntryIndex;

        private NamespaceEntry() {
        }
    }

    private static class PrefixEntry {
        private PrefixEntry next;
        private int prefixId;

        private PrefixEntry() {
        }
    }
}

