/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.setup;

import java.io.File;
import java.util.HashMap;
import java.util.Vector;
import org.openoffice.setup.ResourceManager;
import org.openoffice.setup.SetupData.PackageDescription;
import org.openoffice.setup.Util.Controller;
import org.openoffice.setup.Util.SystemManager;

public class InstallData {
    public static final String ACTION_TYPICAL = "ActionTypical";
    public static final String ACTION_CUSTOM = "ActionCustom";
    private static InstallData instance = null;
    private static boolean isUserInstallation;
    private static boolean isRootInstallation;
    private static boolean isInstallationMode;
    private static boolean isUninstallationMode;
    private static boolean isCustomInstallation;
    private static boolean isTypicalInstallation;
    private static boolean isSolarisUserInstallation;
    private static boolean isChangeInstallation;
    private static boolean stillRunning;
    private static boolean stillAnalyzing;
    private static boolean databaseAnalyzed;
    private static boolean moduleSizeSet;
    private static boolean preInstallDone;
    private static boolean isAbortedInstallation;
    private static boolean isErrorInstallation;
    private static boolean logModuleStates;
    private static boolean visibleModulesChecked;
    private static boolean isMaskedCompleteUninstallation;
    private static boolean typicalSelectionStateSaved;
    private static boolean customSelectionStateSaved;
    private static boolean startSelectionStateSaved;
    private static boolean olderVersionExists;
    private static boolean sameVersionExists;
    private static boolean newerVersionExists;
    private static String installType;
    private static String osType;
    private static String installDir;
    private static String installRoot;
    private static String defaultDir;
    private static String packageFormat;
    private static String architecture;
    private static String packagePath;
    private static String packageSubdir;
    private static String adminFileNameReloc;
    private static String adminFileNameNoReloc;
    private static String databasePath;
    private static String getUidPath;
    private static String installationPrivileges;
    private static String storedInstallationPrivileges;
    private static String localTempPath;
    private static String installDirName;
    private static String uninstallDirName;
    private static int availableDiscSpace;
    private static File jarFilePath;
    private static File resourceRoot;
    private static File infoRoot;
    private static HashMap shellEnvironment;
    private static PackageDescription updatePackage;
    private static Vector removeFiles;
    private static Vector installPackages;

    public static InstallData getInstance() {
        if (instance == null) {
            instance = new InstallData();
        }
        return instance;
    }

    private InstallData() {
        installType = ACTION_TYPICAL;
        isUserInstallation = SystemManager.isUserInstallation();
        isRootInstallation = !isUserInstallation;
        this.setInstallationPrivileges(isUserInstallation);
        osType = SystemManager.getOSType();
        resourceRoot = SystemManager.getResourceRoot();
        this.setInstallationMode();
        this.setSolarisUserInstall();
        this.setHtmlFileExistence();
    }

    public void setInstallationType(String installationtype) {
        installType = installationtype;
        if (installType.equals(this.getCustomActionCommand())) {
            isCustomInstallation = true;
            isTypicalInstallation = false;
        }
        if (installType.equals(this.getTypicalActionCommand())) {
            isCustomInstallation = false;
            isTypicalInstallation = true;
        }
    }

    private void setInstallationMode() {
        File uninstallDir = new File(resourceRoot, uninstallDirName);
        File installDir = new File(resourceRoot, installDirName);
        if (SystemManager.exists_directory(uninstallDir.getPath())) {
            isInstallationMode = false;
            isUninstallationMode = true;
            infoRoot = uninstallDir;
            System.err.println("Mode: uninstallation");
        } else if (SystemManager.exists_directory(installDir.getPath())) {
            isInstallationMode = true;
            isUninstallationMode = false;
            infoRoot = installDir;
            System.err.println("Mode: installation");
        } else {
            infoRoot = null;
            System.err.println("Error: Did not find info path");
            System.err.println("Error: No info about installation or uninstallation");
            System.exit(1);
        }
    }

    private void setSolarisUserInstall() {
        if (isUserInstallation && osType.equalsIgnoreCase("SunOS")) {
            isSolarisUserInstallation = true;
            if (isInstallationMode) {
                Controller.checkForUidFile(this);
            }
        }
    }

    private void setHtmlFileExistence() {
        File htmlDirectory = this.getInfoRoot("html");
        ResourceManager.checkFileExistence(htmlDirectory);
    }

    private void setInstallationPrivileges(boolean isUserInstallation) {
        installationPrivileges = isUserInstallation ? "user" : "root";
    }

    public String getInstallationType() {
        return installType;
    }

    public String getCustomActionCommand() {
        return ACTION_CUSTOM;
    }

    public String getTypicalActionCommand() {
        return ACTION_TYPICAL;
    }

    public String getInstallationPrivileges() {
        return installationPrivileges;
    }

    public String getOSType() {
        return osType;
    }

    public File getResourceRoot() {
        return resourceRoot;
    }

    public File getResourceRoot(String subDirectory) {
        File dir = this.getResourceRoot();
        if (dir != null && !(dir = new File(dir, subDirectory)).exists()) {
            dir = null;
        }
        return dir;
    }

    public File getInfoRoot() {
        return infoRoot;
    }

    public File getInfoRoot(String subDirectory) {
        File dir = new File(infoRoot, subDirectory);
        if (!dir.exists()) {
            dir = null;
        }
        return dir;
    }

    public boolean isUserInstallation() {
        return isUserInstallation;
    }

    public boolean isRootInstallation() {
        return isRootInstallation;
    }

    public boolean isInstallationMode() {
        return isInstallationMode;
    }

    public boolean isUninstallationMode() {
        return isUninstallationMode;
    }

    public boolean isSolarisUserInstallation() {
        return isSolarisUserInstallation;
    }

    public String getDefaultDir() {
        return defaultDir;
    }

    public void setDefaultDir(String dir) {
        defaultDir = dir;
    }

    public String getInstallDirName() {
        return installDirName;
    }

    public String getUninstallDirName() {
        return uninstallDirName;
    }

    public String getInstallDir() {
        return installDir;
    }

    public void setInstallDir(String dir) {
        installDir = dir;
    }

    public String getInstallRoot() {
        return installRoot;
    }

    public void setInstallRoot(String dir) {
        installRoot = dir;
    }

    public String getDatabasePath() {
        return databasePath;
    }

    public void setDatabasePath(String path) {
        databasePath = path;
    }

    public String getPackagePath() {
        if (packagePath == null) {
            packagePath = SystemManager.getPackagePath(packageSubdir);
        }
        return packagePath;
    }

    public void setPackagePath(String path) {
        packagePath = path;
    }

    public String getPackageSubdir() {
        return packageSubdir;
    }

    public void setPackageSubdir(String dir) {
        packageSubdir = dir;
    }

    public String getPackageFormat() {
        return packageFormat;
    }

    public void setPackageFormat(String format) {
        packageFormat = format;
    }

    public String getArchitecture() {
        return architecture;
    }

    public void setArchitecture(String arch) {
        architecture = arch;
    }

    public String getLocalTempPath() {
        return localTempPath;
    }

    public void setLocalTempPath(String path) {
        localTempPath = path;
    }

    public int getAvailableDiscSpace() {
        return availableDiscSpace;
    }

    public void setAvailableDiscSpace(int space) {
        availableDiscSpace = space;
    }

    public String getAdminFileNameReloc() {
        return adminFileNameReloc;
    }

    public void setAdminFileNameReloc(String fileName) {
        adminFileNameReloc = fileName;
    }

    public String getAdminFileNameNoReloc() {
        return adminFileNameNoReloc;
    }

    public void setAdminFileNameNoReloc(String fileName) {
        adminFileNameNoReloc = fileName;
    }

    public String getGetUidPath() {
        return getUidPath;
    }

    public void setGetUidPath(String filePath) {
        getUidPath = filePath;
    }

    public String getStoredInstallationPrivileges() {
        return storedInstallationPrivileges;
    }

    public void setStoredInstallationPrivileges(String privileges) {
        storedInstallationPrivileges = privileges;
    }

    public void setStillRunning(boolean running) {
        stillRunning = running;
    }

    public boolean stillRunning() {
        return stillRunning;
    }

    public void setStillAnalyzing(boolean running) {
        stillAnalyzing = running;
    }

    public boolean stillAnalyzing() {
        return stillAnalyzing;
    }

    public void setDatabaseAnalyzed(boolean analyzed) {
        databaseAnalyzed = analyzed;
    }

    public boolean databaseAnalyzed() {
        return databaseAnalyzed;
    }

    public void setModuleSizeSet(boolean set) {
        moduleSizeSet = set;
    }

    public boolean moduleSizeSet() {
        return moduleSizeSet;
    }

    public void setPreInstallDone(boolean done) {
        preInstallDone = done;
    }

    public boolean preInstallDone() {
        return preInstallDone;
    }

    public boolean isChangeInstallation() {
        return isChangeInstallation;
    }

    public void setIsChangeInstallation(boolean changeInstallation) {
        isChangeInstallation = changeInstallation;
    }

    public boolean isTypicalInstallation() {
        return isTypicalInstallation;
    }

    public boolean isCustomInstallation() {
        return isCustomInstallation;
    }

    public boolean isAbortedInstallation() {
        return isAbortedInstallation;
    }

    public void setIsAbortedInstallation(boolean abortedInstallation) {
        isAbortedInstallation = abortedInstallation;
    }

    public boolean isErrorInstallation() {
        return isErrorInstallation;
    }

    public void setIsErrorInstallation(boolean errorInstallation) {
        isErrorInstallation = errorInstallation;
    }

    public boolean logModuleStates() {
        return logModuleStates;
    }

    public void setLogModuleStates(boolean log) {
        logModuleStates = log;
    }

    public boolean visibleModulesChecked() {
        return visibleModulesChecked;
    }

    public void setVisibleModulesChecked(boolean checked) {
        visibleModulesChecked = checked;
    }

    public boolean isMaskedCompleteUninstallation() {
        return isMaskedCompleteUninstallation;
    }

    public void setMaskedCompleteUninstallation(boolean masked) {
        isMaskedCompleteUninstallation = masked;
    }

    public boolean typicalSelectionStateSaved() {
        return typicalSelectionStateSaved;
    }

    public void setTypicalSelectionStateSaved(boolean saved) {
        typicalSelectionStateSaved = saved;
    }

    public boolean customSelectionStateSaved() {
        return customSelectionStateSaved;
    }

    public void setCustomSelectionStateSaved(boolean saved) {
        customSelectionStateSaved = saved;
    }

    public boolean startSelectionStateSaved() {
        return startSelectionStateSaved;
    }

    public void setStartSelectionStateSaved(boolean saved) {
        startSelectionStateSaved = saved;
    }

    public boolean olderVersionExists() {
        return olderVersionExists;
    }

    public void setOlderVersionExists(boolean exists) {
        olderVersionExists = exists;
    }

    public boolean sameVersionExists() {
        return sameVersionExists;
    }

    public void setSameVersionExists(boolean exists) {
        sameVersionExists = exists;
    }

    public boolean newerVersionExists() {
        return newerVersionExists;
    }

    public void setNewerVersionExists(boolean exists) {
        newerVersionExists = exists;
    }

    public PackageDescription getUpdatePackage() {
        return updatePackage;
    }

    public void setUpdatePackage(PackageDescription onePackage) {
        updatePackage = onePackage;
    }

    public HashMap getShellEnvironment() {
        return shellEnvironment;
    }

    public Vector getRemoveFiles() {
        return removeFiles;
    }

    public Vector getInstallPackages() {
        return installPackages;
    }

    public void setInstallPackages(Vector packages) {
        installPackages = packages;
    }

    public void setShellEnvironment(HashMap environment) {
        shellEnvironment = environment;
    }

    public File getJarFilePath() {
        if (jarFilePath == null) {
            jarFilePath = SystemManager.getJarFilePath();
        }
        return jarFilePath;
    }

    static {
        isCustomInstallation = false;
        isTypicalInstallation = true;
        isSolarisUserInstallation = false;
        isChangeInstallation = false;
        stillRunning = false;
        stillAnalyzing = true;
        databaseAnalyzed = false;
        moduleSizeSet = false;
        preInstallDone = false;
        isAbortedInstallation = false;
        isErrorInstallation = false;
        logModuleStates = false;
        visibleModulesChecked = false;
        isMaskedCompleteUninstallation = false;
        typicalSelectionStateSaved = false;
        customSelectionStateSaved = false;
        startSelectionStateSaved = false;
        olderVersionExists = false;
        sameVersionExists = false;
        newerVersionExists = false;
        installDir = null;
        installRoot = null;
        defaultDir = "/opt/OpenOffice.org";
        packageFormat = null;
        architecture = null;
        packagePath = null;
        packageSubdir = "packages";
        adminFileNameReloc = null;
        adminFileNameNoReloc = null;
        databasePath = null;
        getUidPath = null;
        installationPrivileges = null;
        storedInstallationPrivileges = null;
        localTempPath = null;
        installDirName = "installdata";
        uninstallDirName = "uninstalldata";
        availableDiscSpace = 0;
        jarFilePath = null;
        shellEnvironment = null;
        updatePackage = null;
        removeFiles = new Vector();
        installPackages = new Vector();
    }
}

