/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.activation;

import com.sun.corba.se.impl.activation.CommandHandler;
import com.sun.corba.se.impl.orbutil.CorbaResourceUtil;
import com.sun.corba.se.spi.activation.Repository;
import com.sun.corba.se.spi.activation.RepositoryHelper;
import com.sun.corba.se.spi.activation.RepositoryPackage.ServerDef;
import com.sun.corba.se.spi.activation.ServerNotRegistered;
import java.io.PrintStream;
import org.omg.CORBA.ORB;

class ListServers
implements CommandHandler {
    static final int illegalServerId = -1;

    ListServers() {
    }

    public String getCommandName() {
        return "list";
    }

    public void printCommandHelp(PrintStream printStream, boolean bl) {
        if (!bl) {
            printStream.println(CorbaResourceUtil.getText("servertool.list"));
        } else {
            printStream.println(CorbaResourceUtil.getText("servertool.list1"));
        }
    }

    public boolean processCommand(String[] stringArray, ORB oRB, PrintStream printStream) {
        int n = -1;
        boolean bl = false;
        boolean bl2 = bl = stringArray.length != 0;
        if (stringArray.length == 2 && stringArray[0].equals("-serverid")) {
            n = Integer.valueOf(stringArray[1]);
        }
        if (n == -1 && bl) {
            return true;
        }
        try {
            Repository repository = RepositoryHelper.narrow(oRB.resolve_initial_references("ServerRepository"));
            if (bl) {
                try {
                    ServerDef serverDef = repository.getServer(n);
                    printStream.println();
                    ListServers.printServerDef(serverDef, n, printStream);
                    printStream.println();
                }
                catch (ServerNotRegistered serverNotRegistered) {
                    printStream.println(CorbaResourceUtil.getText("servertool.nosuchserver"));
                }
            } else {
                int[] nArray = repository.listRegisteredServers();
                printStream.println(CorbaResourceUtil.getText("servertool.list2"));
                ListServers.sortServers(nArray);
                for (int i = 0; i < nArray.length; ++i) {
                    try {
                        ServerDef serverDef = repository.getServer(nArray[i]);
                        printStream.println("\t   " + nArray[i] + "\t\t" + serverDef.serverName + "\t\t" + serverDef.applicationName);
                        continue;
                    }
                    catch (ServerNotRegistered serverNotRegistered) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    static void printServerDef(ServerDef serverDef, int n, PrintStream printStream) {
        printStream.println(CorbaResourceUtil.getText("servertool.appname", serverDef.applicationName));
        printStream.println(CorbaResourceUtil.getText("servertool.name", serverDef.serverName));
        printStream.println(CorbaResourceUtil.getText("servertool.classpath", serverDef.serverClassPath));
        printStream.println(CorbaResourceUtil.getText("servertool.args", serverDef.serverArgs));
        printStream.println(CorbaResourceUtil.getText("servertool.vmargs", serverDef.serverVmArgs));
        printStream.println(CorbaResourceUtil.getText("servertool.serverid", n));
    }

    static void sortServers(int[] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = i;
            for (n2 = i + 1; n2 < n; ++n2) {
                if (nArray[n2] >= nArray[n3]) continue;
                n3 = n2;
            }
            if (n3 == i) continue;
            n2 = nArray[i];
            nArray[i] = nArray[n3];
            nArray[n3] = n2;
        }
    }
}

