/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JButton;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public class BasicArrowButton
extends JButton
implements SwingConstants {
    protected int direction;
    private Color shadow;
    private Color darkShadow;
    private Color highlight;

    public BasicArrowButton(int n, Color color, Color color2, Color color3, Color color4) {
        this.setRequestFocusEnabled(false);
        this.setDirection(n);
        this.setBackground(color);
        this.shadow = color2;
        this.darkShadow = color3;
        this.highlight = color4;
    }

    public BasicArrowButton(int n) {
        this(n, UIManager.getColor("control"), UIManager.getColor("controlShadow"), UIManager.getColor("controlDkShadow"), UIManager.getColor("controlLtHighlight"));
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int n) {
        this.direction = n;
    }

    public void paint(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        Color color = graphics.getColor();
        boolean bl = this.getModel().isPressed();
        boolean bl2 = this.isEnabled();
        graphics.setColor(this.getBackground());
        graphics.fillRect(1, 1, n - 2, n2 - 2);
        if (this.getBorder() != null && !(this.getBorder() instanceof UIResource)) {
            this.paintBorder(graphics);
        } else if (bl) {
            graphics.setColor(this.shadow);
            graphics.drawRect(0, 0, n - 1, n2 - 1);
        } else {
            graphics.drawLine(0, 0, 0, n2 - 1);
            graphics.drawLine(1, 0, n - 2, 0);
            graphics.setColor(this.highlight);
            graphics.drawLine(1, 1, 1, n2 - 3);
            graphics.drawLine(2, 1, n - 3, 1);
            graphics.setColor(this.shadow);
            graphics.drawLine(1, n2 - 2, n - 2, n2 - 2);
            graphics.drawLine(n - 2, 1, n - 2, n2 - 3);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(0, n2 - 1, n - 1, n2 - 1);
            graphics.drawLine(n - 1, n2 - 1, n - 1, 0);
        }
        if (n2 < 5 || n < 5) {
            graphics.setColor(color);
            return;
        }
        if (bl) {
            graphics.translate(1, 1);
        }
        int n3 = Math.min((n2 - 4) / 3, (n - 4) / 3);
        n3 = Math.max(n3, 2);
        this.paintTriangle(graphics, (n - n3) / 2, (n2 - n3) / 2, n3, this.direction, bl2);
        if (bl) {
            graphics.translate(-1, -1);
        }
        graphics.setColor(color);
    }

    public Dimension getPreferredSize() {
        return new Dimension(16, 16);
    }

    public Dimension getMinimumSize() {
        return new Dimension(5, 5);
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void paintTriangle(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        Color color = graphics.getColor();
        int n5 = 0;
        n3 = Math.max(n3, 2);
        int n6 = n3 / 2 - 1;
        graphics.translate(n, n2);
        if (bl) {
            graphics.setColor(this.darkShadow);
        } else {
            graphics.setColor(this.shadow);
        }
        switch (n4) {
            case 1: {
                int n7;
                for (n7 = 0; n7 < n3; ++n7) {
                    graphics.drawLine(n6 - n7, n7, n6 + n7, n7);
                }
                if (bl) break;
                graphics.setColor(this.highlight);
                graphics.drawLine(n6 - n7 + 2, n7, n6 + n7, n7);
                break;
            }
            case 5: {
                int n8;
                if (!bl) {
                    graphics.translate(1, 1);
                    graphics.setColor(this.highlight);
                    for (n8 = n3 - 1; n8 >= 0; --n8) {
                        graphics.drawLine(n6 - n8, n5, n6 + n8, n5);
                        ++n5;
                    }
                    graphics.translate(-1, -1);
                    graphics.setColor(this.shadow);
                }
                n5 = 0;
                for (n8 = n3 - 1; n8 >= 0; --n8) {
                    graphics.drawLine(n6 - n8, n5, n6 + n8, n5);
                    ++n5;
                }
                break;
            }
            case 7: {
                int n9;
                for (n9 = 0; n9 < n3; ++n9) {
                    graphics.drawLine(n9, n6 - n9, n9, n6 + n9);
                }
                if (bl) break;
                graphics.setColor(this.highlight);
                graphics.drawLine(n9, n6 - n9 + 2, n9, n6 + n9);
                break;
            }
            case 3: {
                int n10;
                if (!bl) {
                    graphics.translate(1, 1);
                    graphics.setColor(this.highlight);
                    for (n10 = n3 - 1; n10 >= 0; --n10) {
                        graphics.drawLine(n5, n6 - n10, n5, n6 + n10);
                        ++n5;
                    }
                    graphics.translate(-1, -1);
                    graphics.setColor(this.shadow);
                }
                n5 = 0;
                for (n10 = n3 - 1; n10 >= 0; --n10) {
                    graphics.drawLine(n5, n6 - n10, n5, n6 + n10);
                    ++n5;
                }
                break;
            }
        }
        graphics.translate(-n, -n2);
        graphics.setColor(color);
    }
}

