// __________ Imports __________

// base classes
import com.sun.star.uno.UnoRuntime;
import com.sun.star.lang.*;


// application specific classes
import com.sun.star.drawing.*;

import com.sun.star.text.*;
import com.sun.star.container.*;

// presentation specific classes

import com.sun.star.beans.XPropertySet;
import com.sun.star.awt.Size;
import com.sun.star.awt.Point;


public class ShapeHelper
{
    // __________ static helper methods __________
	// 
	public static XPropertySet createAndInsertShape( XComponent xDrawDoc,
			XShapes xShapes, Point aPos, Size aSize, String sShapeType )
		throws java.lang.Exception
	{
		XShape xShape = createShape( xDrawDoc, aPos, aSize, sShapeType );
		xShapes.add( xShape );
		XPropertySet xPropSet = (XPropertySet)
			UnoRuntime.queryInterface( XPropertySet.class, xShape );
		return xPropSet;
	}

    /** create a Shape
	*/
	public static XShape createShape( XComponent xDrawDoc,
			Point aPos, Size aSize, String sShapeType )
		throws java.lang.Exception
	{
		XShape xShape = null;
		XMultiServiceFactory xFactory =
			(XMultiServiceFactory )UnoRuntime.queryInterface(
				XMultiServiceFactory.class, xDrawDoc );
		Object xObj = xFactory.createInstance( sShapeType );
		xShape = (XShape)UnoRuntime.queryInterface(
			XShape.class, xObj );
		xShape.setPosition( aPos );
		xShape.setSize( aSize );
		return xShape;
	}

	/**
        add text to a shape. the return value is the PropertySet
        of the text range that has been added
	*/
	public static XPropertySet addPortion( XShape xShape, String sText, boolean bNewParagraph )
		throws com.sun.star.lang.IllegalArgumentException
	{
		XText xText = (XText)
			UnoRuntime.queryInterface( XText.class, xShape );

		XTextCursor xTextCursor = xText.createTextCursor();
		xTextCursor.gotoEnd( false );
		if ( bNewParagraph == true )
		{
			xText.insertControlCharacter( xTextCursor, ControlCharacter.PARAGRAPH_BREAK, false );
			xTextCursor.gotoEnd( false );
		}
		XTextRange xTextRange = (XTextRange)
			UnoRuntime.queryInterface( XTextRange.class, xTextCursor );
		xTextRange.setString( sText );
		xTextCursor.gotoEnd( true );
		XPropertySet xPropSet = (XPropertySet)
			UnoRuntime.queryInterface( XPropertySet.class, xTextRange );
		return xPropSet;
	}

	public static void setPropertyForLastParagraph( XShape xText, String sPropName,
		Object aValue )
			throws com.sun.star.beans.UnknownPropertyException,
				com.sun.star.beans.PropertyVetoException,
					com.sun.star.lang.IllegalArgumentException,
						com.sun.star.lang.WrappedTargetException,
							com.sun.star.container.NoSuchElementException
	{
		XEnumerationAccess xEnumerationAccess = (XEnumerationAccess)
			UnoRuntime.queryInterface( XEnumerationAccess.class, xText );
		if ( xEnumerationAccess.hasElements() )
		{
			XEnumeration xEnumeration = xEnumerationAccess.createEnumeration();
			while( xEnumeration.hasMoreElements () )
			{
				Object xObj = xEnumeration.nextElement();
				if ( xEnumeration.hasMoreElements() == false )
				{
					XTextContent xTextContent = (XTextContent)UnoRuntime.queryInterface(
						XTextContent.class, xObj );
					XPropertySet xParaPropSet = (XPropertySet)
						UnoRuntime.queryInterface( XPropertySet.class, xTextContent );
					xParaPropSet.setPropertyValue( sPropName, aValue );
				}
			}
		}
	}
}
