/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.expr;

import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.NodeIterator;
import com.jclark.xsl.om.XSLException;

class MergeNodeIterator
implements NodeIterator {
    private NodeIterator[] iters;
    private Node[] nodes;
    private int length;

    MergeNodeIterator(NodeIterator[] nodeIteratorArray, int n) throws XSLException {
        this.length = n;
        this.iters = nodeIteratorArray;
        this.nodes = new Node[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            Node node;
            if (n3 != n2) {
                nodeIteratorArray[n2] = nodeIteratorArray[n3];
            }
            if ((node = nodeIteratorArray[n2].next()) != null) {
                this.nodes[n2++] = node;
            }
            ++n3;
        }
        this.length = n2;
        this.buildHeap();
    }

    private void buildHeap() {
        int n = this.length / 2 - 1;
        while (n >= 0) {
            this.heapify(n);
            --n;
        }
    }

    private final int compare(int n, int n2) {
        return this.nodes[n].compareTo(this.nodes[n2]);
    }

    private final void exchange(int n, int n2) {
        Node node = this.nodes[n];
        this.nodes[n] = this.nodes[n2];
        this.nodes[n2] = node;
        NodeIterator nodeIterator = this.iters[n];
        this.iters[n] = this.iters[n2];
        this.iters[n2] = nodeIterator;
    }

    private final void heapify(int n) {
        while (true) {
            int n2;
            int n3;
            if ((n3 = (n2 = n << 1 | 1) + 1) < this.length) {
                if (this.compare(n2, n3) <= 0) {
                    if (this.compare(n2, n) > 0) break;
                    this.exchange(n2, n);
                    n = n2;
                    continue;
                }
                if (this.compare(n3, n) > 0) break;
                this.exchange(n3, n);
                n = n3;
                continue;
            }
            if (n2 >= this.length || this.compare(n2, n) > 0) break;
            this.exchange(n2, n);
            n = n2;
        }
    }

    public Node next() throws XSLException {
        if (this.length == 0) {
            return null;
        }
        Node node = this.nodes[0];
        do {
            Node node2;
            if ((node2 = this.iters[0].next()) == null) {
                if (--this.length == 0) break;
                this.nodes[0] = this.nodes[this.length];
                this.iters[0] = this.iters[this.length];
            } else {
                this.nodes[0] = node2;
            }
            this.heapify(0);
        } while (node.equals(this.nodes[0]));
        return node;
    }
}

