/*************************************************************************
 *
 *  $RCSfile: btndlg.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2000/12/07 13:37:15 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_BTNDLG_HXX
#define _SV_BTNDLG_HXX

#ifndef _SV_SV_H
#include <vcl/sv.h>
#endif
#ifndef _SV_DIALOG_HXX
#include <vcl/dialog.hxx>
#endif

struct ImplBtnDlgItem;
class ImplBtnDlgItemList;
class PushButton;

// ----------------------
// - ButtonDialog-Types -
// ----------------------

#define BUTTONDIALOG_BUTTON_NOTFOUND			((USHORT)0xFFFF)

#define BUTTONDIALOG_DEFBUTTON					((USHORT)0x0001)
#define BUTTONDIALOG_OKBUTTON					((USHORT)0x0002)
#define BUTTONDIALOG_CANCELBUTTON				((USHORT)0x0004)
#define BUTTONDIALOG_HELPBUTTON 				((USHORT)0x0008)
#define BUTTONDIALOG_FOCUSBUTTON				((USHORT)0x0010)

// ----------------
// - ButtonDialog -
// ----------------

class ButtonDialog : public Dialog
{
private:
	ImplBtnDlgItemList* mpItemList;
	Size				maPageSize;
	Size				maCtrlSize;
	long				mnButtonSize;
	USHORT				mnCurButtonId;
	USHORT				mnFocusButtonId;
	BOOL				mbFormat;
	Link				maClickHdl;

#if 0 // _SOLAR__PRIVATE
#ifdef _SV_BTNDLG_CXX
	void				ImplInitData();
	PushButton* 		ImplCreatePushButton( USHORT nBtnFlags );
	ImplBtnDlgItem* 	ImplGetItem( USHORT nId ) const;
						DECL_LINK( ImplClickHdl, PushButton* pBtn );
	void				ImplPosControls();
#endif
protected:
	long				ImplGetButtonSize();
#endif

protected:
						ButtonDialog( WindowType nType );

public:
						ButtonDialog( Window* pParent, WinBits nStyle = WB_STDDIALOG );
						ButtonDialog( Window* pParent, const ResId& rResId );
						~ButtonDialog();

	virtual void		Resize();
	virtual void		StateChanged( StateChangedType nStateChange );

	virtual void		Click();

	void				SetPageSizePixel( const Size& rSize ) { maPageSize = rSize; }
	const Size& 		GetPageSizePixel() const { return maPageSize; }

	USHORT				GetCurButtonId() const { return mnCurButtonId; }

	void				AddButton( const XubString& rText, USHORT nId, USHORT nBtnFlags, long nSepPixel = 0 );
	void				AddButton( StandardButtonType eType, USHORT nId, USHORT nBtnFlags, long nSepPixel = 0 );
	void				AddButton( PushButton* pBtn, USHORT nId, USHORT nBtnFlags, long nSepPixel = 0 );
	void				RemoveButton( USHORT nId );
	void				Clear();
	USHORT				GetButtonCount() const;
	USHORT				GetButtonId( USHORT nButton ) const;
	PushButton* 		GetPushButton( USHORT nId ) const;
	void				SetButtonText( USHORT nId, const XubString& rText );
	XubString			GetButtonText( USHORT nId ) const;
	void				SetButtonHelpText( USHORT nId, const XubString& rText );
	XubString			GetButtonHelpText( USHORT nId ) const;
	void				SetButtonHelpId( USHORT nId, ULONG nHelpId );
	ULONG				GetButtonHelpId( USHORT nId ) const;

	void				SetFocusButton( USHORT nId = BUTTONDIALOG_BUTTON_NOTFOUND ) { mnFocusButtonId = nId; }
	USHORT				GetFocusButton() const { return mnFocusButtonId; }

	void				SetClickHdl( const Link& rLink ) { maClickHdl = rLink; }
	const Link& 		GetClickHdl() const { return maClickHdl; }
};

#endif	// _SV_BTNDLG_HXX
