/*************************************************************************
 *
 *  $RCSfile: fsetvwsh.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2000/12/07 14:33:35 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SFXFSETVIW_HXX
#define _SFXFSETVIW_HXX

#include <sfx2/viewsh.hxx>

class SfxFrameSetDescriptor;
class SfxFrame;
class SfxURLFrame;
struct SfxFrameSet_Impl;
class SplitWindow;

//===========================================================================
// Die SfxFrameSetViewShell ist die zur SfxFrameSetObjectShell geh"orende
// DefaultView. Sie erzeugt ein SfxFrameSet und benutzt dessen SplitWindow
// als EditWindow.
// "Uber die SfxFrameSetViewShell k"onnen alls Slots ausgef"uhrt werden, die
// die splitbare View betreffen.
//===========================================================================

class SfxFrameSetViewShell: public SfxViewShell
{
friend class SfxFrameSetWindow_Impl;
	SfxFrameSetDescriptor*	pDescriptor;
	BOOL					bEditMode;
	SfxFrameSet_Impl*		pImp;

private:
	void            Construct();
	DECL_LINK(		EventHdl_Impl, void*);

protected:
	virtual void    OuterResizePixel( const Point &rOfs, const Size &rSize );
	virtual void    InnerResizePixel( const Point &rOfs, const Size &rSize );
	virtual void    SFX_NOTIFY( SfxBroadcaster& rBC, const TypeId& rBCType,
							const SfxHint& rHint, const TypeId& rHintType );
public:
					TYPEINFO();
					SfxFrameSetViewShell( SfxViewFrame *pFrame,
										  const SfxFrameSetViewShell& rWin,
										  USHORT nFlags = SFX_VIEW_MAXIMIZE_FIRST );
					SfxFrameSetViewShell( SfxViewFrame *pFrame,
										  SfxViewShell *pOld,
										  USHORT nFlags = SFX_VIEW_MAXIMIZE_FIRST );
					~SfxFrameSetViewShell();

					SFX_DECL_INTERFACE( SFX_INTERFACE_SFXFRAMESETVIEWSH );
	virtual void    Activate( BOOL bMDI );
	void			Fill( const SfxFrameSetDescriptor* pSet );
	void			ReFill( const SfxFrameSetDescriptor* pSet );
	void			MakeWindows( const SfxFrameSetDescriptor*,
											SfxFrame*, USHORT );
	SplitWindow*	GetSplitWindow() const;

	BOOL			IsInEditMode() const
					{ return bEditMode; }

	void			SetEditMode( BOOL bSet )
					{ bEditMode = bSet; }

	void 			SetActiveFrame( SfxFrame* );
	SfxFrame*		GetActiveFrame() const;

	const SfxFrameSetDescriptor*
					GetDescriptor() const
					{ return pDescriptor; }

	void 			UpdateFrameBorder( SfxFrameSetDescriptor* pSet=NULL );
	long			GetDefaultSplitSize() const;

	SfxFrameSetViewShell*
					GetParentFrameSet() const;
	void 			SaveUndo( SfxFrameSetDescriptor* pUndo,
							SfxFrameSetDescriptor *pRedo, const String&, BOOL bClose = FALSE );

	BOOL            StartEditing();
	BOOL            EndEditing();
	USHORT          GetItemId( SfxFrame* );
	USHORT          GetCurItemId();
	SfxFrame*   	Split( USHORT, USHORT );
	void            SetFrameContent( USHORT, const String& );
	void            SetFrameName( USHORT, const String& );
	void            ModifyFrame( USHORT, const SfxItemSet& );
	void            DeleteFrame( USHORT );
	void 			SetFrameSpacing( long nValue );
	void			ForceInit( BOOL bWithFrames = TRUE );

#if 0 // _SOLAR__PRIVATE
	SfxFrameSetDescriptor*
					GetDescriptor_Impl()
					{ return pDescriptor; }
	void			FrameFinishedLoading_Impl( SfxFrame *pFrame );
	DECL_LINK(		SplitHdl_Impl, SfxFrameSetWindow_Impl* );
	void			UpdateFrame_Impl( SfxURLFrame* );
#endif
};

#endif

