/*************************************************************************
 *
 *  $RCSfile: tbxmgr.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: cd $ $Date: 2001/08/03 17:32:16 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SFXTBXMGR_HXX
#define _SFXTBXMGR_HXX

#ifndef _TOOLBOX_HXX //autogen
#include <vcl/toolbox.hxx>
#endif

#include <vcl/bitmap.hxx>
#include <framework/toolboxconfiguration.hxx>

#include <sfx2/sfx.hrc>
#include <sfx2/app.hxx>
#include <sfx2/cfgitem.hxx>
#include <sfx2/imgmgr.hxx>

//--------------------------------------------------------------------

class SfxToolBoxControl;
class SfxToolBoxControlArr_Impl;
class SfxViewFrame;
class SfxBindings;
class SfxInterface;

//--------------------------------------------------------------------

class SfxToolBoxManager: public SfxConfigItem
{
friend class SfxToolbox;

	SfxViewFrame*			pFrame;
	Window*                 pParent;
	ToolBox*				pBox;
	SfxToolBoxControlArr_Impl* pControls;
	SfxBindings*			pBindings;
	USHORT					nIteratorPos;
	SfxSymbolSet			eSymbolSet;
	ResMgr* 				pResMgr;
	SfxInterface*			pIFace;
    BOOL                    bInternal : 1;

private:
	void            Construct();
	void			Align();
	void            CreateFromSVToolBox();
	SfxToolBoxControl* FindControl_Impl( USHORT nId ) const;

					// only for internal purposes
					SfxToolBoxManager( SfxConfigManager*, USHORT );

public:
					// ctor f"ur ToolBoxManager, die keine Objectbars sind
					SfxToolBoxManager( Window*, SfxBindings&, const ResId& );

					// ctoren f"ur ObjectBars
					SfxToolBoxManager( Window*, SfxBindings&, const ResId& rId,
						SfxInterface*, USHORT nPos, SfxShell* pTask );
					SfxToolBoxManager( const ResId& rId, SfxInterface*, const String&,
						SfxToolBoxManager*, SfxShell* pTask );
					~SfxToolBoxManager();

	void			SetFrame(SfxViewFrame* pFr) { pFrame = pFr;}
	SfxViewFrame*   GetFrame() const {return pFrame; }
//	void			SetResMgr(ResMgr* pMgr)  {pResMgr = pMgr; }

	SfxBindings&	GetBindings() { return *pBindings; }
	const SfxBindings&	GetBindings() const { return *pBindings; }

	static void		CreateConfiguration( SfxConfigManager*, USHORT );
	static void		RemoveConfiguration( SfxConfigManager*, USHORT );
	static BOOL     Import( SvStream& rInStream, SvStream& rOutStream );
    static BOOL     Export( SvStream& rInStream, SvStream& rOutStream );
    static int      LoadToolBox( SvStream&, ::framework::ToolBoxDescriptor& );
    static BOOL     StoreToolBox( SvStream&, ::framework::ToolBoxDescriptor& );

	virtual int     Load(SotStorage&);
	virtual BOOL    Store(SotStorage&);
	virtual void    UseDefault();
    virtual String  GetStreamName() const;

	DECL_LINK( Activate, ToolBox * );
	DECL_LINK( Deactivate, ToolBox * );
	DECL_LINK( Select, ToolBox * );

					// interface forward to the ToolBox
	Size			CalcWindowSizePixel() const
						{ return pBox->CalcWindowSizePixel(); }
	void            SetPosSizePixel( const Point& rPos, const Size& rSize )
						{ pBox->SetPosSizePixel( rPos, rSize ); }
	void			SetBackground( const Wallpaper& rBackground )
						{ pBox->SetBackground( rBackground ); }

	// reading out the toolbox
	void			Clear();
	BOOL			FirstItem();		 // resets the item iterator, FALSE if none
	BOOL			NextItem(); 		 // skips to the next item, FALSE if no more
	BOOL			IsBinding() const;	 // TRUE if current item is a binding
	BOOL			IsSeparator() const; // TRUE if current item is a separator
	USHORT			GetId() const;		 // id of current binding if IsBinding()

	ToolBox&		GetToolBox() const { return *pBox; }
	SfxSymbolSet    GetSymbolSet() const
					{return eSymbolSet; }
	void			SetSymbolSet(SfxSymbolSet eNewSet);
	ButtonType      GetButtonType() const
					{ return pBox->GetButtonType(); }
	void			SetButtonType( ButtonType eNewType);
	WindowAlign		GetAlign() const { return pBox->GetAlign(); }
	void			SetItemText( USHORT, const String& );

	void            Show();
	void            Hide();
	BOOL			IsVisible() const { return pBox && pBox->IsVisible(); }

	void            SetFloatingModeData (const Point&, USHORT, long);
	void            Customize( const ToolBoxCustomizeEvent& rCEvt );
    virtual BOOL    ReInitialize();
	void			Delete();
	void 			NextToolBox();
    BOOL            IsInternal();

#if 0 // _SOLAR__PRIVATE
	void 			RefreshImages_Impl();
	void            UpdateControls_Impl();
	static BOOL		IsUserDefToolBox_Impl(USHORT nId);
	static USHORT	GetUserDefToolBoxId_Impl();
	void			ReInitControllers_Impl();
	USHORT			GetNextToolBox_Impl( String *pStr = 0 );
	void			Reconfigure_Impl( SfxToolBoxConfig*  );
#endif

#undef C_VERSION
};

#endif // #ifndef _SFXTBXMGR_HXX

