/*************************************************************************
 *
 *  $RCSfile: stringtransfer.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: obr $ $Date: 2001/05/21 09:17:08 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SVTOOLS_STRINGTRANSFER_HXX_
#define _SVTOOLS_STRINGTRANSFER_HXX_

#ifndef _TRANSFER_HXX
#include <svtools/transfer.hxx>
#endif

//........................................................................
namespace svt
{
//........................................................................

	//====================================================================
	//= OStringTransferable
	//====================================================================
	class OStringTransferable : public TransferableHelper
	{
	protected:
		::rtl::OUString		m_sContent;

	public:
		OStringTransferable(const ::rtl::OUString& _rContent);

	protected:
		// TransferableHelper overridables
		virtual void				AddSupportedFormats();
		virtual sal_Bool			GetData( const ::com::sun::star::datatransfer::DataFlavor& _rFlavor );
	};

	//====================================================================
	//= OStringTransfer
	//====================================================================
	class OStringTransfer
	{
	public:
		/** copies the string given into the system clipboard
			<p>Beware: In opposite to the old DragServer::CopyString, this method does not <em>add</em> the string
			to the clipboard, instead the old clipboard content is <em>replaced</em>!</p>
		*/
		static void			CopyString( const ::rtl::OUString& _rContent, Window* _pWindow = NULL );

		/** extracts a string from the system clipboard given
			@return <TRUE/> if the extraction was successfull, i.e. if the clipboard contained a string content
		*/
		static sal_Bool		PasteString( ::rtl::OUString& _rContent, Window* _pWindow = NULL );

		/** starts dragging a simple string
		*/
		static void			StartStringDrag( const ::rtl::OUString& _rContent, Window* _pWindow, sal_Int8 _nDragSourceActions );
	};

//........................................................................
}	// namespace svt
//........................................................................

#endif // _SVTOOLS_STRINGTRANSFER_HXX_

/*************************************************************************
 * history:
 *	$Log: stringtransfer.hxx,v $
 *	Revision 1.3  2001/05/21 09:17:08  obr
 *	#81916# copy and paste only with window
 *	
 *	Revision 1.2  2001/03/28 08:18:09  fs
 *	+StartStringDrag
 *	
 *	Revision 1.1  2001/03/27 14:35:00  fs
 *	initial checkin - helper classes for clipboard handling of strings
 *	
 *
 *	Revision 1.0 27.03.01 14:40:58  fs
 ************************************************************************/

