/*************************************************************************
 *
 *	$RCSfile: solar.h,v $
 *
 *	$Revision: 1.24.2.3 $
 *
 *	last change: $Author: armin $ $Date: 2002/10/29 16:59:31 $
 *
 *	The Contents of this file are made available subject to the terms of
 *	either of the following licenses
 *
 *		   - GNU Lesser General Public License Version 2.1
 *		   - Sun Industry Standards Source License Version 1.1
 *
 *	Sun Microsystems Inc., October, 2000
 *
 *	GNU Lesser General Public License Version 2.1
 *	=============================================
 *	Copyright 2000 by Sun Microsystems, Inc.
 *	901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License version 2.1, as published by the Free Software Foundation.
 *
 *	This library is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	Lesser General Public License for more details.
 *
 *	You should have received a copy of the GNU Lesser General Public
 *	License along with this library; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *	MA	02111-1307	USA
 *
 *
 *	Sun Industry Standards Source License Version 1.1
 *	=================================================
 *	The contents of this file are subject to the Sun Industry Standards
 *	Source License Version 1.1 (the "License"); You may not use this file
 *	except in compliance with the License. You may obtain a copy of the
 *	License at http://www.openoffice.org/license.html.
 *
 *	Software provided under this License is provided on an "AS IS" basis,
 *	WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *	WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *	MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *	See the License for the specific provisions governing your rights and
 *	obligations concerning the Software.
 *
 *	The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *	Copyright: 2000 by Sun Microsystems, Inc.
 *
 *	All Rights Reserved.
 *
 *	Contributor(s): _______________________________________
 *			Michael Rauch (mrauch-openoffice@fs.tum.de)
 *
 *
 ************************************************************************/

#ifndef _SOLAR_H
#define _SOLAR_H

/*** common solar defines ***********************************/

#ifndef TRUE
#define TRUE		1
#endif
#ifndef FALSE
#define FALSE		0
#endif

#undef NULL
#define NULL		0

#ifdef _SOLAR__PRIVATE
#undef _SOLAR__PRIVATE
#endif
#define _SOLAR__PRIVATE 1
#define __REFERENCED	0

/*** common solar types ******************************************/

typedef unsigned char		BOOL;
typedef unsigned char		BYTE;
typedef unsigned short		USHORT;
typedef unsigned long		ULONG;
typedef int 				FASTBOOL;

#ifndef _SOLAR_NOUINT
/* types with exact defined size (not just the minimum size) */
#if defined ALPHA && !defined WNT
typedef long				INT64;
typedef unsigned long		UINT64;
typedef int 				INT32;
typedef unsigned int		UINT32;
typedef short				INT16;
typedef unsigned short		UINT16;
typedef char				INT8;
typedef unsigned char		UINT8;
#else
#if !defined(_MSC_VER) || defined(_MSC_VER) && (_MSC_VER < 1200) || (_MSC_VER >= 1200 ) && !defined(VCL_NEED_BASETSD )
typedef void				INT64;
typedef void				UINT64;
typedef long				INT32;
typedef unsigned long		UINT32;
#endif
typedef short				INT16;
typedef unsigned short		UINT16;
#if defined LINUX || defined SCO || defined IRIX || (defined _MSC_VER && _MSC_VER >1200) || defined FREEBSD || defined NETBSD
typedef signed char 		INT8;
#else

//#if (_MSC_VER < 1300)
typedef char			INT8;
//#endif

#endif
typedef unsigned char		UINT8;
#endif
#endif // _SOLAR_NOUINT

/*** description of platform and compiler properties *******************/

#ifndef _SOLAR_NODESCRIPTION
#if defined UNX
#include <tools/svconf.h>
#else
#if defined WNT // auf PC's
#define __LITTLEENDIAN
#define __ALIGNMENT2		1
#define __ALIGNMENT4		1
#define __ALIGNMENT8		1
#define __STACKALIGNMENT	4
#define __STACKDIRECTION   -1
#define __SIZEOFCHAR		1
#define __SIZEOFSHORT		2
#define __SIZEOFINT 		4
#define __SIZEOFLONG		4
#define __SIZEOFPOINTER 	4
#define __SIZEOFDOUBLE		8
#define __IEEEDOUBLE
#endif
#endif
#endif // _SOLAR_NODESCRIPTION

/*** misc. macros to leverage platform and compiler differences ********/

#if (defined ALPHA && !defined WNT) || defined IRIX || defined SOLARIS || defined HPUX || defined NETBSD || defined FREEBSD
#define __DELETE(n) delete[]
#else
#define __DELETE(n) delete[n]
#endif
#define DELETEZ( p )	( delete p,p = 0 )

#define __FAR_DATA
#define __READONLY_DATA 		const
#define __EXPORT

#ifdef WNT
#if defined (_MSC_VER) && ( _MSC_VER < 1200 )
#define __LOADONCALLAPI _cdecl
#else
#define __LOADONCALLAPI __cdecl
#endif
#else
#define __LOADONCALLAPI
#endif

#if defined UNX
#define ILLEGAL_POINTER ((void*)1)
#elif defined ( MAC )
#define ILLEGAL_POINTER ((void*)0xEFEFEFEF)
#else
#define ILLEGAL_POINTER NULL
#endif

/*** solar binary types **********************************************/

#ifndef _SOLAR_NOSVBT
/* Solar (portable) Binary (exchange) Type; OSI 6 subset
   always little endian;
   not necessarily aligned */

typedef BYTE				SVBT8[1];
typedef BYTE				SVBT16[2];
typedef BYTE				SVBT32[4];
typedef BYTE				SVBT64[8];

#ifdef __cplusplus
#ifndef _SOLAR_NODESCRIPTION
inline BYTE 	SVBT8ToByte  ( const SVBT8	p ) { return p[0]; }
#if defined __LITTLEENDIAN && __ALIGNMENT2 == 1
inline USHORT	SVBT16ToShort( const SVBT16 p ) { return *(USHORT*)p; }
#else
inline USHORT	SVBT16ToShort( const SVBT16 p ) { return (USHORT)p[0]
												   + ((USHORT)p[1] <<  8); }
#endif
#if defined __LITTLEENDIAN && __ALIGNMENT4 == 1
inline ULONG	SVBT32ToLong ( const SVBT32 p ) { return *(ULONG*)p; }
#else
inline ULONG	SVBT32ToLong ( const SVBT32 p ) { return (ULONG)p[0]
												   + ((ULONG)p[1] <<  8)
												   + ((ULONG)p[2] << 16)
												   + ((ULONG)p[3] << 24); }
#endif
#if !defined __IEEEDOUBLE || __SIZEOFDOUBLE != 8
#error sorry, not implemented
#elif defined __LITTLEENDIAN && __ALIGNMENT8 == 1
inline double	SVBT64ToDouble( const SVBT64 p ) { return *(double*)p; }
#elif defined __LITTLEENDIAN
inline double	SVBT64ToDouble( const SVBT64 p ) { double n;
													((BYTE*)&n)[0] = p[0];
													((BYTE*)&n)[1] = p[1];
													((BYTE*)&n)[2] = p[2];
													((BYTE*)&n)[3] = p[3];
													((BYTE*)&n)[4] = p[4];
													((BYTE*)&n)[5] = p[5];
													((BYTE*)&n)[6] = p[6];
													((BYTE*)&n)[7] = p[7];
													return n; }
#else
inline double	SVBT64ToDouble( const SVBT64 p ) { double n;
													((BYTE*)&n)[0] = p[7];
													((BYTE*)&n)[1] = p[6];
													((BYTE*)&n)[2] = p[5];
													((BYTE*)&n)[3] = p[4];
													((BYTE*)&n)[4] = p[3];
													((BYTE*)&n)[5] = p[2];
													((BYTE*)&n)[6] = p[1];
													((BYTE*)&n)[7] = p[0];
													return n; }
#endif

inline void 	ByteToSVBT8  ( BYTE   n, SVBT8	p ) { p[0] = n; }
#if defined __LITTLEENDIAN && __ALIGNMENT2 == 1
inline void 	ShortToSVBT16( USHORT n, SVBT16 p ) { *(USHORT*)p = n; }
#else
inline void 	ShortToSVBT16( USHORT n, SVBT16 p ) { p[0] = (BYTE) n;
													  p[1] = (BYTE)(n >>  8); }
#endif
#if defined __LITTLEENDIAN && __ALIGNMENT4 == 1
inline void 	LongToSVBT32 ( ULONG  n, SVBT32 p ) { *(ULONG*)p = n; }
#else
inline void 	LongToSVBT32 ( ULONG  n, SVBT32 p ) { p[0] = (BYTE) n;
													  p[1] = (BYTE)(n >>  8);
													  p[2] = (BYTE)(n >> 16);
													  p[3] = (BYTE)(n >> 24); }
#endif
#if !defined __IEEEDOUBLE || __SIZEOFDOUBLE != 8
#error sorry, not implemented
#elif defined __LITTLEENDIAN && __ALIGNMENT8 == 1
inline void 	DoubleToSVBT64( double n, SVBT64 p ) { *(double*)p = n; }
#elif defined __LITTLEENDIAN
inline void 	DoubleToSVBT64( double n, SVBT64 p ) { p[0] = ((BYTE*)&n)[0];
													   p[1] = ((BYTE*)&n)[1];
													   p[2] = ((BYTE*)&n)[2];
													   p[3] = ((BYTE*)&n)[3];
													   p[4] = ((BYTE*)&n)[4];
													   p[5] = ((BYTE*)&n)[5];
													   p[6] = ((BYTE*)&n)[6];
													   p[7] = ((BYTE*)&n)[7]; }
#else
inline void 	DoubleToSVBT64( double n, SVBT64 p ) { p[0] = ((BYTE*)&n)[7];
													   p[1] = ((BYTE*)&n)[6];
													   p[2] = ((BYTE*)&n)[5];
													   p[3] = ((BYTE*)&n)[4];
													   p[4] = ((BYTE*)&n)[3];
													   p[5] = ((BYTE*)&n)[2];
													   p[6] = ((BYTE*)&n)[1];
													   p[7] = ((BYTE*)&n)[0]; }
#endif
#endif
#endif
#endif

/*** standard floating point definitions *******************************/

#ifndef F_PI
#define F_PI		3.14159265358979323846
#endif
#ifndef F_PI2
#define F_PI2		1.57079632679489661923
#endif
#ifndef F_PI4
#define F_PI4		0.785398163397448309616
#endif
#ifndef F_PI180
#define F_PI180 	0.01745329251994
#endif
#ifndef F_PI1800
#define F_PI1800	0.001745329251994
#endif
#ifndef F_PI18000
#define F_PI18000	0.0001745329251994
#endif
#ifndef F_2PI
#define F_2PI		6.28318530717958647694
#endif

/*** standard macros *****************************************/

#define SWAPSHORT(x) ((((x) >> 8) & 0x00FF) | (((x) & 0x00FF) << 8))
#define SWAPLONG(x)  ((((x) >> 24) & 0x000000FF) | (((x) & 0x00FF0000) >> 8) | \
					  (((x) & 0x0000FF00) <<  8) | (((x) & 0x000000FF) << 24))

#ifndef __cplusplus
#ifndef min
#define min(a,b)	(((a) < (b)) ? (a) : (b))
#endif
#ifndef max
#define max(a,b)	(((a) > (b)) ? (a) : (b))
#endif
#endif

/*** standard inline functions *****************************************/

#ifdef __cplusplus
inline int		Min( int a, int b ) 		{ return (a<b?a:b); }
inline int		Max( int a, int b ) 		{ return (a>b?a:b); }
inline char 	Min( char a, char b )		{ return (a<b?a:b); }
inline char 	Max( char a, char b )		{ return (a>b?a:b); }
inline BYTE 	Min( BYTE a, BYTE b )		{ return (a<b?a:b); }
inline BYTE 	Max( BYTE a, BYTE b )		{ return (a>b?a:b); }
inline short	Min( short a, short b ) 	{ return (a<b?a:b); }
inline short	Max( short a, short b ) 	{ return (a>b?a:b); }
inline USHORT	Min( USHORT a, USHORT b )	{ return (a<b?a:b); }
inline USHORT	Max( USHORT a, USHORT b )	{ return (a>b?a:b); }
inline long 	Min( long a, long b )		{ return (a<b?a:b); }
inline long 	Max( long a, long b )		{ return (a>b?a:b); }
inline ULONG	Min( ULONG a, ULONG b ) 	{ return (a<b?a:b); }
inline ULONG	Max( ULONG a, ULONG b ) 	{ return (a>b?a:b); }

inline char 	Abs( char a )				{ return (a>=0?a:-a); }
inline int		Abs( int a )				{ return (a>=0?a:-a); }
inline short	Abs( short a )				{ return (a>=0?a:-a); }
inline long 	Abs( long a  )				{ return (a>=0?a:-a); }
#endif

/*** C / C++ - macros **************************************************/

#ifdef __cplusplus
#define BEGIN_C 	extern "C" {
#define END_C		}
#define EXTERN_C	extern "C"
#else
#define BEGIN_C
#define END_C
#define EXTERN_C
#endif

/*** macros ************************************************************/

#ifdef NOHACKS
#define HACK( comment ) #error hack: comment
#else
#define HACK( comment )
#endif

#define _MAKE_NUMSTR( n )			# n
#define MAKE_NUMSTR( n )			_MAKE_NUMSTR( n )

#define _LF 	((char)0x0A)
#define _CR 	((char)0x0D)

/*** pragmas ************************************************************/

#if defined _MSC_VER
/* deletion of pointer to incomplete type '...'; no destructor called
 serious error, memory deleted without call of dtor */
#pragma warning( error: 4150 )
// warning C4002: too many actual parameters for macro
// warning C4003: not enough actual parameters for macro
#pragma warning(error : 4002 4003)
#endif

/* dll file extensions *******************************************************/

/* many of these platforms are historic */
#define SYSTEM_WINMSCI		1
#define SYSTEM_WNTMSCI		2
#define SYSTEM_WNTMSCA		3
#define SYSTEM_WNTMSCP		4
#define SYSTEM_WNTMSCM		5
#define SYSTEM_OS2BLCI		6
#define SYSTEM_OS2ICCI		7
#define SYSTEM_OS2ICCI3 	8
#define SYSTEM_UNXLNXI		9
#define SYSTEM_UNXSOLS		10
#define SYSTEM_UNXBSDI		11
#define SYSTEM_UNXBSDA		12
#define SYSTEM_UNXSCOI		13
#define SYSTEM_UNXAIXP		14
#define SYSTEM_UNXHPXR		15
#define SYSTEM_UNXSNIM		16
#define SYSTEM_UNXMVSG		17
#define SYSTEM_UNXIRXM		18
#define SYSTEM_MACOSP		19
#define SYSTEM_UNXFBSDI 	20
#define SYSTEM_UNXSOLI		21
#define SYSTEM_WINBLCI		22
#define SYSTEM_UNXMACXP 	23
#define SYSTEM_UNXLNXP		24
#define SYSTEM_UNXBSDS		25
#define SYSTEM_UNXLNXR		26
#define SYSTEM_UNXBSDP		27
#define SYSTEM_UNXLNXX		29

#if defined WNT
  #define __DLLEXTENSION "mi"
  #define SYSTEM_ID 		SYSTEM_WNTMSCI
#elif defined UNX
#ifdef AIX
  #define __DLLEXTENSION "ap.so"
  #define SYSTEM_ID 		SYSTEM_UNXAIXP
#elif defined HPUX
  #define __DLLEXTENSION "hr.sl"
  #define SYSTEM_ID 		SYSTEM_UNXHPXR
#elif defined SOLARIS && defined SPARC
  #define __DLLEXTENSION "ss.so"
  #define SYSTEM_ID 		SYSTEM_UNXSOLS
#elif defined SOLARIS && defined INTEL
  #define __DLLEXTENSION "si.so"
  #define SYSTEM_ID 		SYSTEM_UNXSOLI
#elif defined SCO
  #define __DLLEXTENSION "ci.so"
  #define SYSTEM_ID 		SYSTEM_UNXSCOI
#elif defined NETBSD && defined INTEL
  #define __DLLEXTENSION "bi.so"
  #define SYSTEM_ID 		SYSTEM_UNXBSDI
#elif defined NETBSD && defined ARM32
  #define __DLLEXTENSION "ba.so"
  #define SYSTEM_ID 		SYSTEM_UNXBSDA
#elif defined NETBSD && defined SPARC
  #define __DLLEXTENSION "bs.so"
  #define SYSTEM_ID 		SYSTEM_UNXBSDS
#elif defined NETBSD && defined POWERPC
  #define __DLLEXTENSION "bp.so"
  #define SYSTEM_ID 		SYSTEM_UNXBSDP
#elif defined LINUX && defined X86
  #define __DLLEXTENSION "li.so"
  #define SYSTEM_ID 		SYSTEM_UNXLNXI
#elif defined LINUX && defined X86_64
  #define __DLLEXTENSION "lx.so"
  #define SYSTEM_ID 		SYSTEM_UNXLNXX
#elif defined LINUX && defined POWERPC
  #define __DLLEXTENSION "lp.so"
  #define SYSTEM_ID 		SYSTEM_UNXLNXP
#elif defined LINUX && defined ARM32
  #define __DLLEXTENSION "lr.so"
  #define SYSTEM_ID 	SYSTEM_UNXLNXR
#elif defined FREEBSD
  #define __DLLEXTENSION "fi.so"
  #define SYSTEM_ID 		SYSTEM_UNXFBSDI
#elif defined IRIX
  #define __DLLEXTENSION "im.so"
  #define SYSTEM_ID 		SYSTEM_UNXIRXM
#elif defined MACOSX
  #define __DLLEXTENSION "mxp.dylib"
  #define SYSTEM_ID 		SYSTEM_UNXMACXP
#else
  #define __DLLEXTENSION ".so"
#endif
#endif

/* file format versions *************************************************/

#define SOFFICE_FILEFORMAT_31	3450
#define SOFFICE_FILEFORMAT_40	3580
#define SOFFICE_FILEFORMAT_50	5050
#define SOFFICE_FILEFORMAT_60	6200
#define SOFFICE_FILEFORMAT_CURRENT SOFFICE_FILEFORMAT_60

#if SUPD < 537
#define STAROFFICE_SVERSION_KEY 	"?#\"StarOffice 5.1\""
#elif SUPD >= 537 && SUPD < 582
#define STAROFFICE_SVERSION_KEY 	"?#\"StarOffice 5.2\""
#elif SUPD >= 582 && SUPD < 609
#define STAROFFICE_SVERSION_KEY 	"?#\"StarOffice 5.3\""
#else									// >= 609

/* to be removed if final mechanism is available */
#ifdef BUILD_SOSL
#define STAROFFICE_SVERSION_KEY 	"OpenOffice 6.0"
#else
#define STAROFFICE_SVERSION_KEY 	"StarOffice 6.0"
#endif

#endif

/*** hacks **************************************************************/

#ifdef tf4
#define TF4_JAVA
#endif

#ifdef tf5
#define TF5_MAIL_NEWS
#endif

#ifdef tf2334
#define TF2_EXPLORER
#endif

#if SUPD>334
#define TF2_EXPLORER
#endif

#if SUPD>382
#ifdef TF_STARONE
#undef TF_STARONE
#endif
#define TF_STARONE
#endif

// -----------------------------------------------------------------------

#define NOOLDSTRING
#ifndef NOREPLACESTRING
#define UniString		String
#define XubString		String
#else
#define XubString		UniString
#endif
#define xub_Unicode 	sal_Unicode
#define xub_uUnicode	sal_Unicode
#ifdef STRING32
#define xub_StrLen		sal_uInt32
#else
#define xub_StrLen		USHORT
#endif

// -- moved here from libcall.hxx ----------------------------------------

#define LIBRARY_STR(s)		# s
#define LIBRARY_STRING(s)	LIBRARY_STR(s)
#define LIBRARY_SOLARUPD()	LIBRARY_STRING(SUPD)

#define GETFUNCTION( s ) GetFunction( s )
#define LIBRARY_CONCAT3( s1, s2, s3 ) \
	s1 s2 s3
#define LIBRARY_CONCAT4( s1, s2, s3, s4 ) \
	s1 s2 s3 s4

#if defined WIN || defined WNT
#define SVLIBRARY( Base ) \
	LIBRARY_CONCAT4( Base, LIBRARY_SOLARUPD(), __DLLEXTENSION, ".DLL" )
#define SVLIBRARYLANG( Base, Lang ) \
	LIBRARY_CONCAT4( Base, LIBRARY_SOLARUPD(), Lang, ".DLL" )
#elif defined UNX
#define SVLIBRARY( Base ) \
	LIBRARY_CONCAT4( "lib", Base, LIBRARY_SOLARUPD(), __DLLEXTENSION )
#define SVLIBRARYLANG( Base, Lang ) \
	LIBRARY_CONCAT4( "lib", Base, LIBRARY_SOLARUPD(), Lang )
#else
#define SVLIBRARY( Base ) \
	LIBRARY_CONCAT3( Base, LIBRARY_SOLARUPD(), __DLLEXTENSION )
#define SVLIBRARYLANG( Base, Lang ) \
	LIBRARY_CONCAT3( Base, LIBRARY_SOLARUPD(), Lang )
#endif

#if defined MACOSX
#define SV_LIBFILENAME(str) \
	LIBRARYFILENAME_CONCAT3( str, LIBRARY_SOLARUPD(), __DLLEXTENSION )
#elif defined UNX
#define SV_LIBFILENAME(str) \
	LIBRARYFILENAME_CONCAT3( str, LIBRARY_SOLARUPD(), __DLLEXTENSION )
#else
#define SV_LIBFILENAME(str) \
	LIBRARYFILENAME_CONCAT4( str, LIBRARY_SOLARUPD(), __DLLEXTENSION, ".dll" )
#endif

#endif	// _SOLAR_H
