/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.dom;

import com.jclark.xsl.dom.ContainerNode;
import com.jclark.xsl.dom.NullNodeIterator;
import com.jclark.xsl.dom.RootNode;
import com.jclark.xsl.dom.SiblingNodeIterator;
import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.NamespacePrefixMap;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.SafeNodeIterator;
import java.net.URL;

abstract class NodeBase
implements Node {
    final org.w3c.dom.Node domNode;
    int level;
    private int childIndex;
    ContainerNode parent;
    RootNode root;

    NodeBase(org.w3c.dom.Node node) {
        this.domNode = node;
        this.childIndex = 0;
        this.level = 0;
    }

    NodeBase(org.w3c.dom.Node node, ContainerNode containerNode, int n) {
        this.domNode = node;
        this.parent = containerNode;
        this.root = containerNode.root;
        this.childIndex = n;
        this.level = containerNode.level + 1;
    }

    private static final int compare(NodeBase nodeBase, NodeBase nodeBase2) {
        int n = nodeBase.level;
        int n2 = nodeBase2.level;
        int n3 = n - n2;
        while (n > n2) {
            nodeBase = nodeBase.parent;
            --n;
        }
        while (n2 > n) {
            nodeBase2 = nodeBase2.parent;
            --n2;
        }
        int n4 = NodeBase.compareSameLevel(nodeBase, nodeBase2);
        if (n4 != 0) {
            return n4;
        }
        return n3;
    }

    private static final int compareSameLevel(NodeBase nodeBase, NodeBase nodeBase2) {
        if (nodeBase.level == 0) {
            return 0;
        }
        if (nodeBase.domNode.equals(nodeBase2.domNode)) {
            return 0;
        }
        int n = NodeBase.compareSameLevel(nodeBase.parent, nodeBase2.parent);
        if (n != 0) {
            return n;
        }
        return nodeBase.childIndex - nodeBase2.childIndex;
    }

    public int compareTo(Node node) {
        NodeBase nodeBase = (NodeBase)node;
        if (this.root == nodeBase.root) {
            return NodeBase.compare(this, nodeBase);
        }
        return this.root.compareRootTo(nodeBase.root);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof NodeBase)) {
            return false;
        }
        return ((NodeBase)object).domNode.equals(this.domNode);
    }

    public Node getAttribute(Name name) {
        return null;
    }

    public String getAttributeValue(Name name) {
        return null;
    }

    public SafeNodeIterator getAttributes() {
        return NullNodeIterator.getInstance();
    }

    public SafeNodeIterator getChildren() {
        return NullNodeIterator.getInstance();
    }

    public String getData() {
        return null;
    }

    public Node getElementWithId(String string) {
        return this.root.getElementWithId(string);
    }

    public SafeNodeIterator getFollowingSiblings() {
        SiblingNodeIterator siblingNodeIterator = new SiblingNodeIterator(this.parent, this.childIndex, this.domNode);
        siblingNodeIterator.next();
        return siblingNodeIterator;
    }

    public String getGeneratedId() {
        return String.valueOf(this.parent.getGeneratedId()) + "." + Integer.toString(this.childIndex);
    }

    public int getLineNumber() {
        return -1;
    }

    public Name getName() {
        return null;
    }

    public NamespacePrefixMap getNamespacePrefixMap() {
        return this.parent.getNamespacePrefixMap();
    }

    public Node getParent() {
        return this.parent;
    }

    public Node getRoot() {
        return this.root;
    }

    public abstract byte getType();

    public URL getURL() {
        return this.root.getURL();
    }

    public String getUnparsedEntityURI(String string) {
        return this.root.getUnparsedEntityURI(string);
    }

    public boolean isId(String string) {
        return this.root.isId(this.domNode, string);
    }
}

