/*
 * Decompiled with CFR 0.152.
 */
package stardiv.javadep;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class RollCall {
    protected String[] m_classList;
    protected String[] m_excludePackageList;
    protected Vector m_dep = new Vector();
    protected Vector dependencies = new Vector();
    protected Hashtable source = new Hashtable();
    protected int m_level;
    protected String m_archive;
    protected ZipOutputStream m_archiveStream;

    public void setClasses(String[] stringArray) {
        this.m_classList = stringArray;
    }

    public void setExcludes(String[] stringArray) {
        this.m_excludePackageList = stringArray;
    }

    public void setArchive(String string) {
        this.m_archive = string;
    }

    public void start() throws Exception {
        Object object;
        if (this.m_classList == null) {
            throw new Exception("Class list must be specified");
        }
        this.dependencies.removeAllElements();
        this.source.clear();
        if (this.m_archive != null) {
            System.out.println("Creating archive " + this.m_archive);
            File file = new File(this.m_archive);
            object = new FileOutputStream(file);
            this.m_archiveStream = new ZipOutputStream((OutputStream)object);
        }
        int n = 0;
        while (n < this.m_classList.length) {
            object = this.m_classList[n];
            this.check((String)object);
            ++n;
        }
        if (this.m_archiveStream != null) {
            this.m_archiveStream.close();
        }
        if (this.m_archive != null) {
            System.out.println("\n" + this.m_archive + " created.");
        }
    }

    public Vector getDependenciesVector() {
        return this.dependencies;
    }

    public Hashtable getSourceHashtable() {
        return this.source;
    }

    public String[] getDependencies() {
        return null;
    }

    protected void check(String string) throws Exception {
        byte[] byArray;
        String string2;
        if (string.endsWith(".class")) {
            string2 = RollCall.replaceSubstring(string, "..", "*");
            string2 = RollCall.replaceSubstring(string2, "*", "..");
            if (string.startsWith("./")) {
                string2 = new String("." + string2.substring(1));
            }
            byArray = string2.indexOf("/") != -1 ? this.openResource(string2.substring(string2.lastIndexOf("/") + 1), string2.substring(0, string2.lastIndexOf("/"))) : this.openResource(string2, "./");
        } else {
            string2 = String.valueOf(string.replace('.', '/')) + ".class";
            byArray = this.openResource(string2);
        }
        if (byArray == null) {
            throw new Exception("Class " + string + " not found");
        }
        this.processClass(string2, byArray);
    }

    protected byte[] openResource(String string) throws Exception {
        byte[] byArray = null;
        String string2 = System.getProperty("java.class.path");
        int n = 0;
        int n2 = string2.indexOf(File.pathSeparator);
        while (true) {
            String string3 = "";
            string3 = n2 == -1 ? string2.substring(n) : string2.substring(n, n2);
            byArray = this.openResource(string, string3);
            if (byArray != null || n2 == -1) break;
            n = n2 + 1;
            n2 = string2.indexOf(File.pathSeparator, n);
        }
        return byArray;
    }

    protected byte[] openResource(String string, String string2) throws Exception {
        byte[] byArray = null;
        String string3 = string2.toLowerCase();
        if (string3.endsWith(".zip") || string3.endsWith(".jar")) {
            this.source.put(RollCall.replaceSubstring(string, "/", "$/"), string2);
            byArray = this.openResourceFromJar(string, string2);
        } else {
            File file;
            this.source.put(RollCall.replaceSubstring(string, "/", "$/"), "");
            String string4 = string2;
            if (!string2.endsWith("\\") && !string2.endsWith("/")) {
                string4 = String.valueOf(string4) + "/";
            }
            if ((file = new File(string4 = String.valueOf(string4) + string)).exists() && file.isFile()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                long l = file.length();
                byArray = new byte[(int)l];
                fileInputStream.read(byArray);
                fileInputStream.close();
            }
        }
        return byArray;
    }

    protected byte[] openResourceFromJar(String string, String string2) throws Exception {
        ZipEntry zipEntry;
        byte[] byArray = null;
        File file = new File(string2);
        ZipFile zipFile = null;
        if (file.exists() && file.isFile() && (zipEntry = (zipFile = new ZipFile(file)).getEntry(string)) != null) {
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            int n = (int)zipEntry.getSize();
            byArray = new byte[n];
            inputStream.read(byArray, 0, n);
            inputStream.close();
        }
        if (zipFile != null) {
            zipFile.close();
        }
        return byArray;
    }

    static String replaceSubstring(String string, String string2, String string3) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.length();
        int n3 = string2.length();
        int n4 = 0;
        int n5 = 0;
        while ((n5 = string.indexOf(string2, n4)) != -1) {
            n = n4;
            while (n < n5) {
                stringBuffer.append(string.charAt(n));
                ++n;
            }
            if (string3 != null) {
                stringBuffer.append(string3);
            }
            n4 = n5 += n3;
        }
        n = n4;
        while (n < n2) {
            stringBuffer.append(string.charAt(n));
            ++n;
        }
        return stringBuffer.toString();
    }

    protected void processClass(String string, byte[] byArray) throws Exception {
        String string2;
        int n;
        ByteArrayInputStream byteArrayInputStream;
        DataInputStream dataInputStream;
        int n2;
        if (this.isClassProcessed(string)) {
            return;
        }
        this.dependencies.addElement(RollCall.replaceSubstring(string, "/", "$/"));
        this.setClassProcessed(string);
        if (this.m_archiveStream != null) {
            this.addToArchive(string, byArray);
        }
        if ((n2 = (dataInputStream = new DataInputStream(byteArrayInputStream = new ByteArrayInputStream(byArray))).readInt()) != -889275714) {
            throw new Exception("Invalid magic number in " + string);
        }
        short s = dataInputStream.readShort();
        short s2 = dataInputStream.readShort();
        if (s != 3 && s2 != 45) {
            throw new Exception("Invalid version number in " + string);
        }
        int n3 = dataInputStream.readShort();
        Vector<Integer> vector = new Vector<Integer>();
        Hashtable<Integer, String> hashtable = new Hashtable<Integer, String>();
        int n4 = 1;
        while (n4 < n3) {
            n = dataInputStream.readByte();
            switch (n) {
                case 7: {
                    short s3 = dataInputStream.readShort();
                    vector.addElement(new Integer(s3));
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    dataInputStream.skipBytes(4);
                    break;
                }
                case 8: {
                    dataInputStream.skipBytes(2);
                    break;
                }
                case 3: 
                case 4: {
                    dataInputStream.skipBytes(4);
                    break;
                }
                case 5: 
                case 6: {
                    dataInputStream.skipBytes(8);
                    ++n4;
                    break;
                }
                case 12: {
                    dataInputStream.skipBytes(4);
                    break;
                }
                case 1: {
                    string2 = dataInputStream.readUTF();
                    hashtable.put(new Integer(n4), string2);
                    break;
                }
                default: {
                    System.out.println("WARNING: Unknown constant tag (" + n + "@" + n4 + " of " + n3 + ") in " + string);
                }
            }
            ++n4;
        }
        byArray = null;
        dataInputStream.close();
        n = 0;
        while (n < vector.size()) {
            block22: {
                block21: {
                    Integer n5 = (Integer)vector.elementAt(n);
                    string2 = (String)hashtable.get(n5);
                    if (!string2.startsWith("[")) break block21;
                    while (string2.startsWith("[")) {
                        string2 = string2.substring(1);
                    }
                    if (!string2.startsWith("L")) break block22;
                    string2 = string2.substring(1, string2.length() - 1);
                }
                if (!this.isClassProcessed(string2 = String.valueOf(string2) + ".class") && (byArray = this.openResource(string2)) != null) {
                    if (!string.substring(0, string.lastIndexOf(47)).endsWith(string2.substring(0, string2.lastIndexOf(47)))) {
                        this.dependencies.addElement(RollCall.replaceSubstring(string2, "/", "$/"));
                    }
                    this.setClassProcessed(string2);
                }
            }
            ++n;
        }
    }

    private boolean isClassProcessed(String string) {
        int n;
        boolean bl = false;
        if (string.startsWith("java/")) {
            return true;
        }
        if (this.m_excludePackageList != null) {
            n = 0;
            while (n < this.m_excludePackageList.length) {
                if (string.startsWith(this.m_excludePackageList[n])) {
                    return true;
                }
                ++n;
            }
        }
        n = 0;
        while (n < this.m_dep.size()) {
            String string2 = (String)this.m_dep.elementAt(n);
            if (string2.equals(string)) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    private void setClassProcessed(String string) {
        this.m_dep.addElement(string);
    }

    private void addToArchive(String string, byte[] byArray) throws Exception {
        ZipEntry zipEntry = new ZipEntry(string);
        zipEntry.setSize(byArray.length);
        this.m_archiveStream.putNextEntry(zipEntry);
        this.m_archiveStream.write(byArray, 0, byArray.length);
        this.m_archiveStream.closeEntry();
    }

    private String tabs(int n) {
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            string = String.valueOf(string) + "  ";
            ++n2;
        }
        return string;
    }
}

