/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src.nodes;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.Element;
import org.openide.src.ElementFormat;
import org.openide.src.ElementProperties;
import org.openide.src.FieldElement;
import org.openide.src.InitializerElement;
import org.openide.src.MemberElement;
import org.openide.src.MethodElement;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.src.nodes.DefaultFactory;
import org.openide.src.nodes.IconStrings;
import org.openide.src.nodes.SourceEditSupport;
import org.openide.src.nodes.SourceOptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;

public abstract class ElementNode
extends AbstractNode
implements IconStrings,
ElementProperties {
    static ResourceBundle bundle = NbBundle.getBundle(class$org$openide$src$nodes$ElementNode == null ? (class$org$openide$src$nodes$ElementNode = ElementNode.class$("org.openide.src.nodes.ElementNode")) : class$org$openide$src$nodes$ElementNode);
    private static ElementFormat invalidFormat;
    protected static final SourceOptions sourceOptions;
    private static final String[] ICON_AFFECTING_PROPERTIES;
    protected Element element;
    protected ElementFormat elementFormat = new ElementFormat("");
    protected boolean writeable;
    private transient PropertyChangeListener listener;
    static /* synthetic */ Class class$org$openide$src$nodes$ElementNode;
    static /* synthetic */ Class class$org$openide$src$nodes$SourceOptions;

    public ElementNode(Element element, Children children, boolean bl) {
        super(children);
        this.element = element;
        this.writeable = bl;
        this.setIconBase(this.resolveIconBase());
        this.setDisplayName(this.getElementFormat().format(element));
        this.listener = this.createElementListener();
        element.addPropertyChangeListener(WeakListener.propertyChange(this.listener, element));
        this.displayFormat = null;
    }

    public String getShortDescription() {
        try {
            return this.getHintElementFormat().format(this.element);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.getShortDescription();
        }
    }

    protected abstract String resolveIconBase();

    protected String[] getIconAffectingProperties() {
        return ICON_AFFECTING_PROPERTIES;
    }

    public final ElementFormat getElementFormat() {
        return this.elementFormat;
    }

    public final void setElementFormat(ElementFormat elementFormat) {
        this.setDisplayName(elementFormat.format(this.element));
        this.elementFormat = elementFormat;
    }

    final void setElementFormat0(ElementFormat elementFormat) {
        try {
            this.setElementFormat(elementFormat);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setElementFormat(ElementNode.getInvalidFormat());
        }
    }

    static ElementFormat getInvalidFormat() {
        if (invalidFormat != null) {
            return invalidFormat;
        }
        invalidFormat = new ElementFormat(bundle.getString("FMT_InvalidFormat"));
        return invalidFormat;
    }

    protected abstract ElementFormat getHintElementFormat();

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$openide$src$nodes$ElementNode == null ? (class$org$openide$src$nodes$ElementNode = ElementNode.class$("org.openide.src.nodes.ElementNode")) : class$org$openide$src$nodes$ElementNode);
    }

    public boolean canRename() {
        return this.isWriteable();
    }

    public boolean canDestroy() {
        return this.isWriteable();
    }

    public Transferable clipboardCopy() throws IOException {
        ExTransferable exTransferable = ExTransferable.create(super.clipboardCopy());
        exTransferable.put(new ElementStringTransferable());
        return exTransferable;
    }

    public Transferable clipboardCut() throws IOException {
        if (!this.isWriteable()) {
            throw new IOException();
        }
        ExTransferable exTransferable = ExTransferable.create(super.clipboardCut());
        exTransferable.put(new ElementStringTransferable());
        return exTransferable;
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return this.isWriteable();
    }

    public void setActions(SystemAction[] systemActionArray) {
        this.systemActions = systemActionArray;
    }

    void superFireCookieChange() {
        this.fireCookieChange();
    }

    public Node.Cookie getCookie(Class clazz) {
        Node.Cookie cookie = super.getCookie(clazz);
        if (cookie == null) {
            cookie = this.element.getCookie(clazz);
        }
        return cookie;
    }

    public boolean equals(Object object) {
        return object instanceof ElementNode && this.element.equals(((ElementNode)object).element);
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    public Node.Handle getHandle() {
        Node.Handle handle = super.getHandle();
        if (handle != null) {
            return handle;
        }
        if (this.element instanceof SourceElement) {
            return null;
        }
        return new ElementNodeHandle(this.element, this.writeable, this.elementFormat);
    }

    boolean isWriteable() {
        return this.writeable && SourceEditSupport.isWriteable(this.element);
    }

    void superSetName(String string) {
        super.setName(string);
    }

    void superPropertyChange(String string, Object object, Object object2) {
        super.firePropertyChange(string, object, object2);
    }

    void superShortDescriptionChange(String string, String string2) {
        super.fireShortDescriptionChange(string, string2);
    }

    PropertyChangeListener createElementListener() {
        return new ElementListener();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        sourceOptions = (SourceOptions)SourceOptions.findObject(class$org$openide$src$nodes$SourceOptions == null ? (class$org$openide$src$nodes$SourceOptions = ElementNode.class$("org.openide.src.nodes.SourceOptions")) : class$org$openide$src$nodes$SourceOptions, true);
        ICON_AFFECTING_PROPERTIES = new String[]{"modifiers"};
    }

    static abstract class ElementProp
    extends PropertySupport {
        public ElementProp(String string, Class clazz, boolean bl) {
            super(string, clazz, bundle.getString("PROP_" + string), bundle.getString("HINT_" + string), true, bl);
        }

        public void setValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (!this.canWrite()) {
                throw new IllegalAccessException(bundle.getString("MSG_Cannot_Write"));
            }
        }

        void runAtomic(Element element, SourceEditSupport.ExceptionalRunnable exceptionalRunnable) throws InvocationTargetException {
            SourceException[] sourceExceptionArray = new SourceException[]{null};
            try {
                SourceElement sourceElement = SourceEditSupport.findSource(element);
                if (sourceElement == null) {
                    exceptionalRunnable.run();
                } else {
                    Runnable runnable = new Runnable(this, exceptionalRunnable, sourceExceptionArray){
                        private final /* synthetic */ SourceEditSupport.ExceptionalRunnable val$exRun;
                        private final /* synthetic */ SourceException[] val$ex;
                        private final /* synthetic */ ElementProp this$0;
                        {
                            this.this$0 = elementProp;
                            this.val$exRun = exceptionalRunnable;
                            this.val$ex = sourceExceptionArray;
                        }

                        public void run() {
                            try {
                                this.val$exRun.run();
                            }
                            catch (SourceException sourceException) {
                                this.val$ex[0] = sourceException;
                            }
                        }
                    };
                    sourceElement.runAtomicAsUser(runnable);
                }
            }
            catch (SourceException sourceException) {
                sourceExceptionArray[0] = sourceException;
            }
            if (sourceExceptionArray[0] != null) {
                throw new InvocationTargetException(sourceExceptionArray[0]);
            }
        }
    }

    class ElementListener
    implements PropertyChangeListener {
        ElementListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == null) {
                ElementNode.this.setDisplayName(ElementNode.this.getElementFormat().format(ElementNode.this.element));
                ElementNode.this.setIconBase(ElementNode.this.resolveIconBase());
            } else {
                if ("valid".equals(string)) {
                    ElementNode.super.fireNodeDestroyed();
                    return;
                }
                if (ElementNode.this.getElementFormat().dependsOnProperty(string)) {
                    ElementNode.this.setDisplayName(ElementNode.this.getElementFormat().format(ElementNode.this.element));
                }
                String[] stringArray = ElementNode.this.getIconAffectingProperties();
                int n = 0;
                while (n < stringArray.length) {
                    if (stringArray[n].equals(string)) {
                        ElementNode.this.setIconBase(ElementNode.this.resolveIconBase());
                        break;
                    }
                    ++n;
                }
                if (string.equals("name")) {
                    try {
                        ElementNode.this.superSetName(((MemberElement)ElementNode.this.element).getName().toString());
                    }
                    catch (ClassCastException classCastException) {}
                } else if (string.equals("cookie")) {
                    ElementNode.this.superFireCookieChange();
                    return;
                }
            }
            if (ElementNode.this.getHintElementFormat().dependsOnProperty(propertyChangeEvent.getPropertyName())) {
                ElementNode.this.superShortDescriptionChange("", ElementNode.this.getShortDescription());
            }
            ElementNode.this.superPropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
    }

    private static final class ElementNodeHandle
    implements Node.Handle {
        private static final long serialVersionUID = 910667289626540L;
        private Element element;
        private boolean writable;
        private ElementFormat elementFormat;

        public ElementNodeHandle(Element element, boolean bl, ElementFormat elementFormat) {
            this.element = element;
            this.writable = bl;
            this.elementFormat = elementFormat;
        }

        public Node getNode() throws IOException {
            Node node;
            DefaultFactory defaultFactory = new DefaultFactory(this.writable);
            if (this.element instanceof ClassElement) {
                node = defaultFactory.createClassNode((ClassElement)this.element);
            } else if (this.element instanceof ConstructorElement) {
                node = defaultFactory.createConstructorNode((ConstructorElement)this.element);
            } else if (this.element instanceof FieldElement) {
                node = defaultFactory.createFieldNode((FieldElement)this.element);
            } else if (this.element instanceof InitializerElement) {
                node = defaultFactory.createInitializerNode((InitializerElement)this.element);
            } else if (this.element instanceof MethodElement) {
                node = defaultFactory.createMethodNode((MethodElement)this.element);
            } else {
                throw new IOException("what is element " + this.element + "? cannot restore node");
            }
            if (node instanceof ElementNode) {
                ((ElementNode)node).setElementFormat(this.elementFormat);
            }
            return node;
        }

        public String toString() {
            return "ElementNodeHandle[" + this.element + "]";
        }
    }

    class ElementStringTransferable
    extends ExTransferable.Single {
        ElementStringTransferable() {
            super(DataFlavor.stringFlavor);
        }

        protected Object getData() {
            return ElementNode.this.element.toString();
        }
    }
}

