/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.openide.util.Lookup;
import org.openide.util.enum.AlterEnumeration;
import org.openide.util.enum.EmptyEnumeration;
import org.openide.util.enum.QueueEnumeration;
import org.openide.util.enum.SequenceEnumeration;
import org.openide.util.enum.SingletonEnumeration;
import org.openide.util.lookup.AbstractLookup;

final class InheritanceTree
implements Comparator {
    private Node object = new Node(class$java$lang$Object == null ? (class$java$lang$Object = InheritanceTree.class$("java.lang.Object")) : class$java$lang$Object);
    private Map interfaces;
    static /* synthetic */ Class class$java$lang$Object;

    public boolean add(AbstractLookup.Pair pair, Collection collection) {
        Node node = InheritanceTree.registerClass(this.object, pair);
        collection.add(node.getType());
        if (!node.assignItem(pair)) {
            return false;
        }
        boolean bl = this.registerInterface(pair, collection);
        return bl;
    }

    public void remove(AbstractLookup.Pair pair, Collection collection) {
        Node node = InheritanceTree.removeClass(this.object, pair);
        if (node != null) {
            collection.add(node.getType());
        }
        this.removeInterface(pair, collection);
    }

    public void retainAll(Map map, Collection collection) {
        this.retainAllInterface(map, collection);
        InheritanceTree.retainAllClasses(this.object, map, collection);
    }

    public Enumeration lookup(Class clazz) {
        if (clazz.isInterface()) {
            return this.searchInterface(clazz);
        }
        return InheritanceTree.searchClass(this.object, clazz);
    }

    public static boolean unsorted(Enumeration enumeration) {
        return enumeration instanceof SequenceEnumeration;
    }

    public void print(PrintStream printStream, boolean bl) {
        InheritanceTree.printNode(this.object, "", printStream, bl);
    }

    private static Node registerClass(Node node, AbstractLookup.Pair pair) {
        if (!node.accepts(pair)) {
            return null;
        }
        if (node.children != null) {
            Node node2;
            Iterator iterator = node.children.iterator();
            while ((node2 = InheritanceTree.extractNode(iterator)) != null) {
                Node node3 = InheritanceTree.registerClass(node2, pair);
                if (node3 == null) continue;
                return node3;
            }
        }
        return node;
    }

    private static Node removeClass(Node node, AbstractLookup.Pair pair) {
        if (!node.accepts(pair)) {
            return null;
        }
        if (node.items != null && node.items.remove(pair)) {
            return node;
        }
        if (node.children != null) {
            Node node2;
            Iterator iterator = node.children.iterator();
            while ((node2 = InheritanceTree.extractNode(iterator)) != null) {
                Node node3 = InheritanceTree.removeClass(node2, pair);
                if ((node2.items == null || node2.items.isEmpty()) && (node2.children == null || node2.children.isEmpty())) {
                    iterator.remove();
                }
                if (node3 == null) continue;
                return node3;
            }
        }
        return null;
    }

    private static Node classToNode(Node node, Class clazz) {
        Object object;
        Object object2;
        Object object3;
        if (!node.accepts(clazz)) {
            return null;
        }
        if (node.getType() == clazz) {
            return node;
        }
        if (node.children != null) {
            object3 = node.children.iterator();
            while ((object2 = InheritanceTree.extractNode(object3)) != null) {
                object = InheritanceTree.classToNode((Node)object2, clazz);
                if (object == null) continue;
                return object;
            }
        }
        object3 = null;
        if (node.children == null) {
            node.children = new ArrayList();
        } else {
            object2 = node.children.iterator();
            while ((object = InheritanceTree.extractNode((Iterator)object2)) != null) {
                if (!clazz.isAssignableFrom(((Node)object).getType())) continue;
                if (object3 == null) {
                    object3 = new ArrayList();
                }
                ((ArrayList)object3).add((Node)object);
                object2.remove();
            }
        }
        object2 = new Node(clazz);
        node.children.add(object2);
        if (object3 != null) {
            ((Node)object2).children = object3;
        }
        if (node.items != null) {
            object = node.items.iterator();
            while (object.hasNext()) {
                AbstractLookup.Pair pair = (AbstractLookup.Pair)object.next();
                if (!pair.instanceOf(clazz)) continue;
                object.remove();
                ((Node)object2).assignItem(pair);
            }
        }
        return object2;
    }

    private static Enumeration searchClass(Node node, Class clazz) {
        if ((node = InheritanceTree.classToNode(node, clazz)) == null) {
            return EmptyEnumeration.EMPTY;
        }
        return InheritanceTree.nodeToEnum(node);
    }

    private static boolean retainAllClasses(Node node, Map map, Collection collection) {
        Object object;
        Iterator iterator;
        boolean bl = false;
        if (node.items != null && map != null) {
            iterator = node.items.iterator();
            while (iterator.hasNext()) {
                object = (AbstractLookup.Pair)iterator.next();
                AbstractLookup.Info info = (AbstractLookup.Info)map.get(object);
                if (info == null) {
                    iterator.remove();
                    bl = true;
                    continue;
                }
                if (((AbstractLookup.Pair)object).index == info.index) continue;
                ((AbstractLookup.Pair)object).index = info.index;
                collection.addAll(info.modified);
            }
            if (bl && collection != null) {
                collection.add(node.getType());
            }
        }
        if (node.children != null) {
            iterator = node.children.iterator();
            while ((object = InheritanceTree.extractNode(iterator)) != null) {
                boolean bl2 = InheritanceTree.retainAllClasses((Node)object, map, collection);
                if (!bl2) continue;
                iterator.remove();
            }
        }
        return bl && node.items.isEmpty() && (node.children == null || node.children.isEmpty());
    }

    private static Enumeration nodeToEnum(Node node) {
        if (node.children == null) {
            return node.items == null ? EmptyEnumeration.EMPTY : Collections.enumeration(node.items);
        }
        QueueEnumeration queueEnumeration = new QueueEnumeration(){

            protected void process(Object object) {
                Node node = (Node)object;
                if (node.children != null) {
                    Object[] objectArray = node.children.toArray();
                    this.put(objectArray);
                }
            }
        };
        queueEnumeration.put(node);
        AlterEnumeration alterEnumeration = new AlterEnumeration(queueEnumeration){

            protected Object alter(Object object) {
                Node node = (Node)object;
                if (node.items == null || node.items.isEmpty()) {
                    return EmptyEnumeration.EMPTY;
                }
                return Collections.enumeration(node.items);
            }
        };
        return new SequenceEnumeration(alterEnumeration);
    }

    private boolean registerInterface(AbstractLookup.Pair pair, Collection collection) {
        if (this.interfaces == null) {
            return true;
        }
        Iterator iterator = this.interfaces.entrySet().iterator();
        while (iterator.hasNext()) {
            ArrayList<AbstractLookup.Pair> arrayList;
            Map.Entry entry = iterator.next();
            Class clazz = (Class)entry.getKey();
            if (!pair.instanceOf(clazz)) continue;
            Object v = entry.getValue();
            if (v instanceof Collection) {
                arrayList = (ArrayList<AbstractLookup.Pair>)v;
                if (!arrayList.add(pair)) {
                    return false;
                }
            } else {
                if (v.equals(pair)) {
                    return false;
                }
                arrayList = new ArrayList<AbstractLookup.Pair>(3);
                arrayList.add((AbstractLookup.Pair)v);
                arrayList.add(pair);
                entry.setValue(arrayList);
            }
            collection.add(clazz);
        }
        return true;
    }

    private void removeInterface(AbstractLookup.Pair pair, Collection collection) {
        if (this.interfaces == null) {
            return;
        }
        Iterator iterator = this.interfaces.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object v = entry.getValue();
            if (v instanceof Collection) {
                Collection collection2 = (Collection)v;
                if (!collection2.remove(pair)) continue;
                if (collection2.size() == 1) {
                    entry.setValue(collection2.iterator().next());
                }
                collection.add(entry.getKey());
                continue;
            }
            if (!v.equals(pair)) continue;
            iterator.remove();
            collection.add(entry.getKey());
        }
    }

    private void retainAllInterface(Map map, Collection collection) {
        if (this.interfaces == null) {
            return;
        }
        Iterator iterator = this.interfaces.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            Map.Entry entry = iterator.next();
            Object v = entry.getValue();
            boolean bl = v instanceof Collection;
            Iterator<Object> iterator2 = bl ? ((Collection)v).iterator() : Collections.singleton(v).iterator();
            boolean bl2 = false;
            boolean bl3 = false;
            while (iterator2.hasNext()) {
                object = (AbstractLookup.Pair)iterator2.next();
                AbstractLookup.Info info = (AbstractLookup.Info)map.get(object);
                if (info == null) {
                    if (bl) {
                        iterator2.remove();
                    }
                    bl2 = true;
                    continue;
                }
                if (((AbstractLookup.Pair)object).index == info.index) continue;
                ((AbstractLookup.Pair)object).index = info.index;
                collection.addAll(info.modified);
                bl3 = true;
            }
            if (bl3 && v instanceof List) {
                object = (List)v;
                Collections.sort(object, this);
            }
            if (!bl2) continue;
            if (bl) {
                object = (Collection)v;
                if (object.size() == 1) {
                    entry.setValue(object.iterator().next());
                }
            } else {
                iterator.remove();
            }
            collection.add(entry.getKey());
        }
    }

    private Enumeration searchInterface(Class clazz) {
        Object v;
        if (this.interfaces == null) {
            this.interfaces = new WeakHashMap();
        }
        if ((v = this.interfaces.get(clazz)) == null) {
            AbstractLookup.Pair pair = null;
            ArrayList<AbstractLookup.Pair> arrayList = null;
            Enumeration enumeration = this.lookup(class$java$lang$Object == null ? (class$java$lang$Object = InheritanceTree.class$("java.lang.Object")) : class$java$lang$Object);
            while (enumeration.hasMoreElements()) {
                AbstractLookup.Pair pair2 = (AbstractLookup.Pair)enumeration.nextElement();
                if (!pair2.instanceOf(clazz)) continue;
                if (pair == null) {
                    pair = pair2;
                    continue;
                }
                if (arrayList == null) {
                    arrayList = new ArrayList(3);
                    arrayList.add(pair);
                }
                arrayList.add(pair2);
            }
            if (arrayList == null && pair != null) {
                this.interfaces.put(clazz, pair);
                return new SingletonEnumeration(pair);
            }
            if (arrayList == null) {
                arrayList = new ArrayList<AbstractLookup.Pair>(2);
            }
            this.interfaces.put(clazz, arrayList);
            return Collections.enumeration(arrayList);
        }
        if (v instanceof Collection) {
            return Collections.enumeration((Collection)v);
        }
        return new SingletonEnumeration(v);
    }

    private static Node extractNode(Iterator iterator) {
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (node.get() == null) {
                iterator.remove();
                continue;
            }
            return node;
        }
        return null;
    }

    private static void printNode(Node node, String string, PrintStream printStream, boolean bl) {
        Object object;
        Iterator iterator;
        int n;
        Class clazz = node.getType();
        printStream.print(string);
        printStream.println("Node for: " + clazz + "\t" + (clazz == null ? null : clazz.getClassLoader()));
        if (node.items != null) {
            n = 0;
            iterator = new ArrayList(node.items).iterator();
            while (iterator.hasNext()) {
                object = (AbstractLookup.Pair)iterator.next();
                printStream.print(string);
                printStream.print("  item (" + n++ + "): ");
                printStream.print(object);
                printStream.print(" id: " + Integer.toHexString(System.identityHashCode(object)));
                printStream.print(" index: ");
                printStream.print(((AbstractLookup.Pair)object).index);
                if (bl) {
                    printStream.print(" I: " + ((Lookup.Item)object).getInstance());
                }
                printStream.println();
            }
        }
        if (node.children != null) {
            n = 0;
            iterator = node.children.iterator();
            while (iterator.hasNext()) {
                object = (Node)iterator.next();
                InheritanceTree.printNode((Node)object, string + "  ", printStream, bl);
            }
        }
    }

    public int compare(Object object, Object object2) {
        AbstractLookup.Pair pair = (AbstractLookup.Pair)object;
        AbstractLookup.Pair pair2 = (AbstractLookup.Pair)object2;
        int n = pair.index - pair2.index;
        if (n == 0) {
            if (pair != pair2) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                PrintStream printStream = new PrintStream(byteArrayOutputStream);
                printStream.println("Please report this exception as issue http://www.netbeans.org/issues/show_bug.cgi?id=13779 Pair1: " + pair + " pair2: " + pair2 + " index1: " + pair.index + " index2: " + pair2.index + " item1: " + pair.getInstance() + " item2: " + pair2.getInstance() + " id1: " + Integer.toHexString(System.identityHashCode(pair)) + " id2: " + Integer.toHexString(System.identityHashCode(pair2)));
                this.print(printStream, false);
                printStream.close();
                throw new IllegalStateException(byteArrayOutputStream.toString());
            }
            return 0;
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static final class Node
    extends WeakReference {
        public ArrayList children;
        public ArrayList items;

        public Node(Class clazz) {
            super(clazz);
        }

        public Class getType() {
            Class clazz = (Class)this.get();
            return clazz == null ? Void.TYPE : clazz;
        }

        public boolean accepts(Class clazz) {
            if (this.getType() == (class$java$lang$Object == null ? (class$java$lang$Object = InheritanceTree.class$("java.lang.Object")) : class$java$lang$Object)) {
                return true;
            }
            return this.getType().isAssignableFrom(clazz);
        }

        public boolean accepts(AbstractLookup.Pair pair) {
            if (this.getType() == (class$java$lang$Object == null ? (class$java$lang$Object = InheritanceTree.class$("java.lang.Object")) : class$java$lang$Object)) {
                return true;
            }
            return pair.instanceOf(this.getType());
        }

        public boolean assignItem(AbstractLookup.Pair pair) {
            if (this.items == null) {
                this.items = new ArrayList();
                this.items.add(pair);
                return true;
            }
            boolean bl = this.items.remove(pair);
            this.items.add(pair);
            return !bl;
        }
    }
}

