/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.spi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Hashtable;
import org.apache.log4j.Category;
import org.apache.log4j.NDC;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.ThrowableInformation;

public class LoggingEvent
implements Serializable {
    private static long startTime = System.currentTimeMillis();
    public final transient String fqnOfCategoryClass;
    public transient Category category;
    public final String categoryName;
    public transient Priority priority;
    private String ndc;
    private boolean ndcLookupRequired = true;
    private transient Object message;
    private String renderedMessage;
    private String threadName;
    private ThrowableInformation throwableInfo;
    public final long timeStamp;
    private LocationInfo locationInfo;
    static final long serialVersionUID = -868428216207166145L;
    static final Integer[] PARAM_ARRAY = new Integer[1];
    static final String TO_PRIORITY = "toPriority";
    static final Class[] TO_PRIORITY_PARAMS = new Class[]{Integer.TYPE};
    static final Hashtable methodCache = new Hashtable(3);
    static /* synthetic */ Class class$org$apache$log4j$Priority;

    public LoggingEvent(String fqnOfCategoryClass, Category category, Priority priority, Object message, Throwable throwable) {
        this.fqnOfCategoryClass = fqnOfCategoryClass;
        this.category = category;
        this.categoryName = category.getName();
        this.priority = priority;
        this.message = message;
        if (throwable != null) {
            this.throwableInfo = new ThrowableInformation(throwable);
        }
        this.timeStamp = System.currentTimeMillis();
    }

    public LocationInfo getLocationInformation() {
        if (this.locationInfo == null) {
            this.locationInfo = new LocationInfo(new Throwable(), this.fqnOfCategoryClass);
        }
        return this.locationInfo;
    }

    public Object getMessage() {
        if (this.message != null) {
            return this.message;
        }
        return this.getRenderedMessage();
    }

    public String getNDC() {
        if (this.ndcLookupRequired) {
            this.ndcLookupRequired = false;
            this.ndc = NDC.get();
        }
        return this.ndc;
    }

    public String getRenderedMessage() {
        if (this.renderedMessage == null && this.message != null) {
            this.renderedMessage = this.message instanceof String ? (String)this.message : this.category.getHierarchy().getRendererMap().findAndRender(this.message);
        }
        return this.renderedMessage;
    }

    public static long getStartTime() {
        return startTime;
    }

    public String getThreadName() {
        if (this.threadName == null) {
            this.threadName = Thread.currentThread().getName();
        }
        return this.threadName;
    }

    public ThrowableInformation getThrowableInformation() {
        return this.throwableInfo;
    }

    public String[] getThrowableStrRep() {
        if (this.throwableInfo == null) {
            return null;
        }
        return this.throwableInfo.getThrowableStrRep();
    }

    private void readPriority(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        int p = ois.readInt();
        try {
            String className = (String)ois.readObject();
            if (className == null) {
                this.priority = Priority.toPriority(p);
            } else {
                Method m = (Method)methodCache.get(className);
                if (m == null) {
                    Class<?> clazz = Class.forName(className);
                    m = clazz.getDeclaredMethod(TO_PRIORITY, TO_PRIORITY_PARAMS);
                    methodCache.put(className, m);
                }
                LoggingEvent.PARAM_ARRAY[0] = new Integer(p);
                this.priority = (Priority)m.invoke(null, (Object[])PARAM_ARRAY);
            }
        }
        catch (Exception e) {
            LogLog.warn("Priority deserialization failed, reverting to default.", e);
            this.priority = Priority.toPriority(p);
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.readPriority(ois);
        if (this.locationInfo == null) {
            this.locationInfo = new LocationInfo(null, null);
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        this.getThreadName();
        this.getRenderedMessage();
        this.getNDC();
        this.getThrowableStrRep();
        oos.defaultWriteObject();
        this.writePriority(oos);
    }

    private void writePriority(ObjectOutputStream oos) throws IOException {
        oos.writeInt(this.priority.toInt());
        Class<?> clazz = this.priority.getClass();
        if (clazz == (class$org$apache$log4j$Priority == null ? (class$org$apache$log4j$Priority = LoggingEvent.class$("org.apache.log4j.Priority")) : class$org$apache$log4j$Priority)) {
            oos.writeObject(null);
        } else {
            oos.writeObject(clazz.getName());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

