*** orig/win32_60/inc/pgpErrors.h	Wed Aug 30 12:08:12 2000
--- modified/win32_60/inc/pgpErrors.h	Wed Aug 30 12:08:12 2000
***************
*** 1,41 ****
  /*____________________________________________________________________________
  	pgpErrors.h
  
  	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
  	All rights reserved.
  
  	Error codes for all PGP errors can be found in this file.
  
! 	$Id: pgpErrors.h,v 1.80.10.1 1998/11/12 03:23:33 heller Exp $
  ____________________________________________________________________________*/
  #ifndef Included_pgpErrors_h	/* [ */
  #define Included_pgpErrors_h
  
  #include "pgpPubTypes.h"
- 
- 
  #include "pgpPFLErrors.h"
  
  #define kPGPErrorRange		1000
  
  enum PGPError_
  {
  	/*
  		NOTE: error code values must not be changed;
  		compiled client code depends on them.
  	*/
  	kPGPError_FirstError		= -11500,
  	kPGPError_Last				= -10500,
  
  	kPGPError_BadPassphrase		= -11500,
  	kPGPError_OptionNotFound	= -11499,
  
  /* Errors from pgpEncode */
  	kPGPError_RedundantOptions	= -11498,
  	kPGPError_KeyRevoked		= -11497,
  	kPGPError_KeyExpired		= -11496,
  	kPGPError_KeyDisabled		= -11495,
  	kPGPError_KeyInvalid		= -11494,
  	kPGPError_KeyUnusableForEncryption			= -11493,
  	kPGPError_KeyUnusableForSignature			= -11492,
  	kPGPError_OutputBufferTooSmall				= -11491,
--- 1,39 ----
  /*____________________________________________________________________________
  	pgpErrors.h
  
  	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
  	All rights reserved.
  
  	Error codes for all PGP errors can be found in this file.
  
! 	$Id: pgpErrors.h,v 1.1 2000/07/28 15:52:08 mhu Exp $
  ____________________________________________________________________________*/
  #ifndef Included_pgpErrors_h	/* [ */
  #define Included_pgpErrors_h
  
  #include "pgpPubTypes.h"
  #include "pgpPFLErrors.h"
  
  #define kPGPErrorRange		1000
  
  enum PGPError_
  {
  	/*
  		NOTE: error code values must not be changed;
  		compiled client code depends on them.
  	*/
  	kPGPError_FirstError		= -11500,
  	kPGPError_Last				= -10500,
  
  	kPGPError_BadPassphrase		= -11500,
  	kPGPError_OptionNotFound	= -11499,
  
  /* Errors from pgpEncode */
  	kPGPError_RedundantOptions	= -11498,
  	kPGPError_KeyRevoked		= -11497,
  	kPGPError_KeyExpired		= -11496,
  	kPGPError_KeyDisabled		= -11495,
  	kPGPError_KeyInvalid		= -11494,
  	kPGPError_KeyUnusableForEncryption			= -11493,
  	kPGPError_KeyUnusableForSignature			= -11492,
  	kPGPError_OutputBufferTooSmall				= -11491,
***************
*** 230,274 ****
  	kPGPError_SocketsOperationNotSupported		= -11095,
  	kPGPError_SocketsProtocolNotSupported		= -11094,
  	kPGPError_SocketsAddressFamilyNotSupported	= -11093,
  	kPGPError_SocketsNotASocket					= -11092,
  	kPGPError_SocketsAddressInUse				= -11091,
  	kPGPError_SocketsBufferOverflow				= -11090,
  	kPGPError_SocketsListenQueueFull			= -11089,
  	kPGPError_SocketsAddressNotAvailable		= -11088,
  	kPGPError_SocketsAlreadyConnected			= -11087,
  	kPGPError_SocketsTimedOut					= -11086,
  	kPGPError_SocketsNoStaticStorage			= -11085,
  	
  	kPGPError_SocketsHostNotFound				= -11050,
  	kPGPError_SocketsDomainServerError			= -11049,
  	
  	kPGPError_DummyEnumValue
  	/* kPGPError_Last */
  } ;
  
  
  PGP_BEGIN_C_DECLARATIONS
  #if PRAGMA_IMPORT_SUPPORTED
  #pragma import on
  #endif
  
! PGPError 	PGPGetErrorString( PGPError theError,
  				PGPSize bufferSize, char * theString );
  
  #if PRAGMA_IMPORT_SUPPORTED
  #pragma import reset
  #endif
  PGP_END_C_DECLARATIONS
  
  
  #endif /* ] Included_pgpErrors_h */
  
  
  /*__Editor_settings____
  
  	Local Variables:
  	tab-width: 4
  	End:
  	vi: ts=4 sw=4
  	vim: si
  _____________________*/
--- 228,272 ----
  	kPGPError_SocketsOperationNotSupported		= -11095,
  	kPGPError_SocketsProtocolNotSupported		= -11094,
  	kPGPError_SocketsAddressFamilyNotSupported	= -11093,
  	kPGPError_SocketsNotASocket					= -11092,
  	kPGPError_SocketsAddressInUse				= -11091,
  	kPGPError_SocketsBufferOverflow				= -11090,
  	kPGPError_SocketsListenQueueFull			= -11089,
  	kPGPError_SocketsAddressNotAvailable		= -11088,
  	kPGPError_SocketsAlreadyConnected			= -11087,
  	kPGPError_SocketsTimedOut					= -11086,
  	kPGPError_SocketsNoStaticStorage			= -11085,
  	
  	kPGPError_SocketsHostNotFound				= -11050,
  	kPGPError_SocketsDomainServerError			= -11049,
  	
  	kPGPError_DummyEnumValue
  	/* kPGPError_Last */
  } ;
  
  
  PGP_BEGIN_C_DECLARATIONS
  #if PRAGMA_IMPORT_SUPPORTED
  #pragma import on
  #endif
  
! PGPError 	PGPAPI PGPGetErrorString( PGPError theError,
  				PGPSize bufferSize, char * theString );
  
  #if PRAGMA_IMPORT_SUPPORTED
  #pragma import reset
  #endif
  PGP_END_C_DECLARATIONS
  
  
  #endif /* ] Included_pgpErrors_h */
  
  
  /*__Editor_settings____
  
  	Local Variables:
  	tab-width: 4
  	End:
  	vi: ts=4 sw=4
  	vim: si
  _____________________*/
