
#include <vector>
#include <fstream>

#include <pspell/getdata.hh>
#include <pspell/string.hh>

#include "data.hh"
#include "file_util.hh"
#include "file_exceps.hh"
#include "bad_value.hh"
#include "config.hh"

namespace aspell {

  class MultiWS : public BasicMultiSet
  {
  public:
    void load(const string &, Config *, Manager *, const LocalWordSetInfo * li);
    
    VirEmul *  elements() const ;
    Size       size()     const;
    
  private:
    typedef vector<Value> Wss;
    Wss wss;
    struct ElementsParms;
  };
  
  void MultiWS::load(const string & fn, 
		     Config * config, Manager * manager, 
		     const LocalWordSetInfo * li)
  {
    ifstream in;
    in.open(fn.c_str());
    if (!in)
      throw CantReadFile(fn);
    set_file_name(fn);
    PspellString key, data;
    PspellGetLineFromStream gl(&in);
    bool strip_accents;
    if (config->have("strip-accents"))
      strip_accents = config->retrieve_bool("strip-accents");
    else if (li == 0)
      strip_accents = false;
    else
      strip_accents = li->convert.strip_accents;
    while( getdata_pair(gl, key, data) ) {
      if (strcmp(key.c_str(), "strip-accents") == 0) {
	if (config->have("strip-accents")) {
	  // do nothing
	} if (strcmp(data.c_str(), "true")==0) {
	  strip_accents = true;
	} else if (strcmp(data.c_str(), "false") == 0) {
	  strip_accents = false;
	} else {
	  //FIXME: Add Exception BadValueInFile
	  throw BadValue("strip-accents", data.c_str(), "true or false");
	}
      } else if (strcmp(key.c_str(), "add") == 0) {
	LocalWordSet ws;
	ws.local_info.set(0, config, strip_accents);
	ws.word_set = add_data_set(data.c_str(), *config, manager, &ws.local_info);
	set_check_lang(ws.word_set->lang()->name(), config);
	ws.local_info.set_language(ws.word_set->lang());
	wss.push_back(ws);

      } else {
	
	//FIXME: Add Exception UnknownKeyInFile
	string msg;
	msg   = "The key \"";
	msg += key.c_str();
	msg += "\" is unknown.";
	throw BadFileFormat(fn, msg);
      }
    }
  }

  struct MultiWS::ElementsParms
  {
    typedef Wss::value_type     Value;
    typedef Wss::const_iterator Iterator;
    Iterator end;
    ElementsParms(Iterator e) : end(e) {}
    bool endf(Iterator i)   const {return i == end;}
    Value end_state()       const {return Value();}
    Value deref(Iterator i) const {return *i;}
  };

  MultiWS::VirEmul * MultiWS::elements() const
  {
    return new MakeVirEmulation<ElementsParms>(wss.begin(), wss.end());
  }
  
  MultiWS::Size MultiWS::size() const 
  {
    return wss.size();
  }

  BasicMultiSet * new_default_multi_word_set() 
  {
    return new MultiWS();
  }

}
