// __________ Imports __________

// base classes
import com.sun.star.uno.UnoRuntime;
import com.sun.star.lang.*;

// property access
import com.sun.star.beans.*;

// application specific classes
import com.sun.star.drawing.*;

// XModel, XController
import com.sun.star.frame.*;

// Point, Size
import com.sun.star.awt.*;

//
import com.sun.star.view.*;


// __________ Implementation __________

/** ControlAndSelectDemo
    @author Sven Jacobi

   A (GroupBox) ControlShape will be created.
   Finally the ControlShape will be inserted into a selection.
*/

public class ControlAndSelectDemo
{
    public static void main( String args[] )
    {
		XComponent xComponent = null;
		try
		{
			String sConnection;
			if ( args.length >= 1 )
				sConnection = args[ 0 ];
			else
				sConnection = "uno:socket,host=localhost,port=8100;urp;StarOffice.ServiceManager";
			XMultiServiceFactory xServiceFactory =
				Helper.connect( sConnection );

			// suppress Presentation Autopilot when opening the document
			// properties are the same as described for com.sun.star.document.MediaDescriptor
			PropertyValue[] pPropValues = new PropertyValue[ 1 ];
			pPropValues[ 0 ] = new PropertyValue();
			pPropValues[ 0 ].Name = "Silent";
			pPropValues[ 0 ].Value = new Boolean( true );

			xComponent = Helper.createDocument( xServiceFactory,
				"private:factory/sdraw", "_blank", 0, pPropValues );

			XMultiServiceFactory xFactory =
				(XMultiServiceFactory )UnoRuntime.queryInterface(
					XMultiServiceFactory.class, xComponent );
		
			XDrawPagesSupplier xDrawPagesSupplier =
				(XDrawPagesSupplier)UnoRuntime.queryInterface(
					XDrawPagesSupplier.class, xComponent );
			XDrawPages xDrawPages = xDrawPagesSupplier.getDrawPages();
			XDrawPage xDrawPage = (XDrawPage)UnoRuntime.queryInterface(
                XDrawPage.class, xDrawPages.getByIndex( 0 ));
			XShapes xShapes = (XShapes)UnoRuntime.queryInterface( XShapes.class, xDrawPage );


			// create and insert the ControlShape
			Object xObj = xFactory.createInstance( "com.sun.star.drawing.ControlShape" );
			XShape xShape = (XShape)UnoRuntime.queryInterface( XShape.class, xObj );
			xShape.setPosition( new Point( 1000, 1000 ) );
			xShape.setSize( new Size( 2000, 2000 ) );
			xShapes.add( xShape );

			// create and set the control
			XControlModel xControlModel = (XControlModel)UnoRuntime.queryInterface( XControlModel.class,
				xFactory.createInstance( "com.sun.star.form.component.GroupBox" ) );
			XControlShape xControlShape = (XControlShape)UnoRuntime.queryInterface( XControlShape.class, xShape );
			xControlShape.setControl( xControlModel );


			// the following code will demonstrate how to
			// make a selection that contains our new created ControlShape
			XModel xModel = (XModel)UnoRuntime.queryInterface( XModel.class, xComponent );
			XController xController = xModel.getCurrentController();
			XSelectionSupplier xSelectionSupplier =(XSelectionSupplier)
				UnoRuntime.queryInterface( XSelectionSupplier.class, xController );
			// take care to use the global service factory only and not the one that is
			// provided by the component if you create the ShapeColletion
			XShapes xSelection = (XShapes)UnoRuntime.queryInterface( XShapes.class,
				xServiceFactory.createInstance( "com.sun.star.drawing.ShapeCollection" ) );
			xSelection.add( xShape );
			xSelectionSupplier.select( xSelection );
		}
		catch( java.lang.Exception ex )
		{
			System.out.println( ex );
		}
		System.exit( 0 );
    }
}
