
#include <string.h>
#include "string.hh"

PspellString::PspellString() {
  allocated_ = 16;
  str_ = new char[allocated_];
  str_[0] = '\0';
  size_ = 0;
}

PspellString::PspellString(const char * s) {
  size_ = strlen(s);
  allocated_ = size_ + 1;
  str_ = new char[allocated_];
  strncpy(str_, s, allocated_);
}

PspellString::PspellString(const char * s, unsigned int size) {
  size_ = size;
  allocated_ = size_ + 1;
  str_ = new char[allocated_];
  strncpy(str_, s, size_);
  str_[size_] = '\0';
}

PspellString::PspellString(const PspellString & other) {
  size_ = other.size_;
  allocated_ = size_ + 1;
  str_ = new char[allocated_];
  strncpy(str_, other.str_, size_ + 1);
}

PspellString::~PspellString() {
  delete[] str_;
}

void PspellString::assign(const char * s, unsigned int s_size) {
  size_ = s_size;
  if (size_ + 1 > allocated_) {
    delete[] str_;
    allocated_ = size_ + 1;
    str_ = new char[allocated_];
  }
  strncpy(str_, s, size_);
  str_[size_] = '\0';
}

void PspellString::append(const char * s, unsigned int s_size) {
  if (s_size == 0) return;
  if (size_ + s_size + 1 > allocated_) {
    char * orig_str = str_;
    if (size_ + s_size + 1 > allocated_*2) 
      allocated_ = size_ + s_size + 1;
    else
      allocated_ *= 2;
    str_ = new char[allocated_];
    strncpy(str_, orig_str, size_);
    delete[] orig_str;
  }
  strncpy(str_ + size_, s, s_size);
  size_ += s_size;
  str_[size_] = '\0';
}
