*** orig/dmake/dbug/malloc/tostring.c	Sat Sep  9 18:36:36 2000
--- modified/dmake/dbug/malloc/tostring.c	Sat Sep  9 18:36:36 2000
***************
*** 20,70 ****
   *
   * Narrative:	IF fill character is non-blank
   *		    Determine base
   *		        If base is HEX
   *		            add "0x" to begining of string
   *		        IF base is OCTAL
   *		            add "0" to begining of string
   *
   *		While value is greater than zero
   *		    use val % base as index into xlation str to get cur char
   *		    divide val by base
   *
   *		Determine fill-in length
   *
   *		Fill in fill chars
   *
   *		Copy in number
   *		
   *
   * Mod History:	
   *   90/01/24	cpcahil		Initial revision.
   */
  
  #ifndef lint
  static
! char rcs_hdr[] = "$Id: tostring.c,v 1.1.1.1 1997/07/15 16:02:26 dvadura Exp $";
  #endif
  
  #define T_LEN 10
  
  int
  tostring(buf,val,len,base,fill)
  	int	  base;
  	char	* buf;
  	char	  fill;
  	int	  len;
  	int	  val;
  	
  {
  	char	* bufstart = buf;
  	int	  i = T_LEN;
  	char	* xbuf = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
  	char	  tbuf[T_LEN];
  
  	/*
  	 * if we are filling with non-blanks, make sure the
  	 * proper start string is added
  	 */
  	if( fill != ' ' )
  	{
  		switch(base)
--- 20,70 ----
   *
   * Narrative:	IF fill character is non-blank
   *		    Determine base
   *		        If base is HEX
   *		            add "0x" to begining of string
   *		        IF base is OCTAL
   *		            add "0" to begining of string
   *
   *		While value is greater than zero
   *		    use val % base as index into xlation str to get cur char
   *		    divide val by base
   *
   *		Determine fill-in length
   *
   *		Fill in fill chars
   *
   *		Copy in number
   *		
   *
   * Mod History:	
   *   90/01/24	cpcahil		Initial revision.
   */
  
  #ifndef lint
  static
! char rcs_hdr[] = "$Id: tostring.c,v 1.1.1.1 1997/09/22 14:51:11 hjs Exp $";
  #endif
  
  #define T_LEN 10
  
  int
  tostring(buf,val,len,base,fill)
  	int	  base;
  	char	* buf;
  	char	  fill;
  	int	  len;
  	int	  val;
  	
  {
  	char	* bufstart = buf;
  	int	  i = T_LEN;
  	char	* xbuf = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
  	char	  tbuf[T_LEN];
  
  	/*
  	 * if we are filling with non-blanks, make sure the
  	 * proper start string is added
  	 */
  	if( fill != ' ' )
  	{
  		switch(base)
***************
*** 110,159 ****
--- 110,162 ----
  		{
  			/* 
  			 * string is too long so we must truncate
  			 * off some characters.  We do this the easiest
  			 * way by just incrementing i.  This means the
  			 * most significant digits are lost.
  			 */
  			while( len++ < 0 )
  			{
  				i++;
  			}
  		}
  	}
  
  	while( i < T_LEN )
  	{
  		*(buf++) = tbuf[i++];
  	}
  
  	return( (int) (buf - bufstart) );
  
  } /* tostring(... */
  
  /*
   * $Log: tostring.c,v $
+  * Revision 1.1.1.1  1997/09/22 14:51:11  hjs
+  * dmake 4.1 orginal sourcen
+  *
   * Revision 1.1.1.1  1997/07/15 16:02:26  dvadura
   * dmake gold 4.1.00 initial import
   *
   * Revision 1.1.1.1  1996/10/27 07:30:15  dvadura
   * Dmake 4.1 Initial Import
   *
   * Revision 1.1.1.1  1996/10/24 05:33:14  dvadura
   * Initial import for final release of dmake 4.1
   *
   * Revision 1.1  1994/10/06  17:43:20  dvadura
   * dmake Release Version 4.0, Initial revision
   *
   * Revision 1.1  1994/10/06  03:45:29  dvadura
   * dmake Release Version 4.0, Initial revision
   *
   * Revision 1.1  1992/01/24  03:29:16  dvadura
   * dmake Version 3.8, Initial revision
   *
   * Revision 1.4  90/05/11  00:13:11  cpcahil
   * added copyright statment
   * 
   * Revision 1.3  90/02/24  21:50:33  cpcahil
   * lots of lint fixes
   * 
   * Revision 1.2  90/02/24  17:29:42  cpcahil
