*** orig/dmake/unix/dcache.c	Sat Sep  9 18:36:50 2000
--- modified/dmake/unix/dcache.c	Sat Sep  9 18:36:50 2000
***************
*** 1,62 ****
! /* RCS  $Id: dcache.c,v 1.1.1.1 1997/07/15 16:02:34 dvadura Exp $
  --
  -- SYNOPSIS
  --      Directory cache management routines.
  --
  -- DESCRIPTION
  --      This is the code that maintains a directory cache for each directory
  --      that dmake visits.  The entire directory is thus only read once and
  --      the need for performing costly 'stat' calls when performing target
  --      inference is much reduced.  The improvement in performance should be
  --      significant for NFS or remote mounted file systems.
  --
  -- AUTHOR
  --      Dennis Vadura, dvadura@dmake.wticorp.com
  --
  -- WWW
  --      http://dmake.wticorp.com/
  --
  -- COPYRIGHT
  --      Copyright (c) 1996,1997 by WTI Corp.  All rights reserved.
  -- 
  --      This program is NOT free software; you can redistribute it and/or
  --      modify it under the terms of the Software License Agreement Provided
  --      in the file <distribution-root>/readme/license.txt.
  --
  -- LOG
  --      Use cvs log to obtain detailed change logs.
  */
  
  /* For Borland 5.00 compile, for some reason they seem to insist on pulling
   * in the winnt.h if __WIN32__ is defined and you include <dirent.h>.  This
   * is, in my opinion, a BUG! on Borland's part.
   */
  #if defined(__BORLANDC__) && defined(__WIN32__)
  #undef __WIN32__
  #endif
  
  #include <dirent.h>
  #include "extern.h"
  #include "sysintf.h"
  
  
  typedef struct ent {
     char    *name;
     uint32  hkey;
     time_t  mtime;
     int     isdir;
     struct ent *next;
  } Entry, *EntryPtr;
  
  
  typedef struct mydir {
     char         *path;
     uint32        hkey;
     EntryPtr      entries;
     struct mydir *next;
  } DirEntry, *DirEntryPtr;
  
  static DirEntryPtr dtab[HASH_TABLE_SIZE];
  
  
  /* Stat a path using the directory cache.
--- 1,65 ----
! /* RCS  $Id: dcache.c,v 1.2 2000/06/09 17:28:39 patrick.luby Exp $
  --
  -- SYNOPSIS
  --      Directory cache management routines.
  --
  -- DESCRIPTION
  --      This is the code that maintains a directory cache for each directory
  --      that dmake visits.  The entire directory is thus only read once and
  --      the need for performing costly 'stat' calls when performing target
  --      inference is much reduced.  The improvement in performance should be
  --      significant for NFS or remote mounted file systems.
  --
  -- AUTHOR
  --      Dennis Vadura, dvadura@dmake.wticorp.com
  --
  -- WWW
  --      http://dmake.wticorp.com/
  --
  -- COPYRIGHT
  --      Copyright (c) 1996,1997 by WTI Corp.  All rights reserved.
  -- 
  --      This program is NOT free software; you can redistribute it and/or
  --      modify it under the terms of the Software License Agreement Provided
  --      in the file <distribution-root>/readme/license.txt.
  --
  -- LOG
  --      Use cvs log to obtain detailed change logs.
  */
  
  /* For Borland 5.00 compile, for some reason they seem to insist on pulling
   * in the winnt.h if __WIN32__ is defined and you include <dirent.h>.  This
   * is, in my opinion, a BUG! on Borland's part.
   */
  #if defined(__BORLANDC__) && defined(__WIN32__)
  #undef __WIN32__
  #endif
  
+ #ifdef __APPLE__
+ #include <sys/types.h>
+ #endif
  #include <dirent.h>
  #include "extern.h"
  #include "sysintf.h"
  
  
  typedef struct ent {
     char    *name;
     uint32  hkey;
     time_t  mtime;
     int     isdir;
     struct ent *next;
  } Entry, *EntryPtr;
  
  
  typedef struct mydir {
     char         *path;
     uint32        hkey;
     EntryPtr      entries;
     struct mydir *next;
  } DirEntry, *DirEntryPtr;
  
  static DirEntryPtr dtab[HASH_TABLE_SIZE];
  
  
  /* Stat a path using the directory cache.
***************
*** 72,121 ****
--- 75,132 ----
   * otherwise.
   *
   * If the directory is not in our cache we insert it into the cache by
   * openning the directory and reading all of the files within.  Once read
   * then we return the result of the above search.
   *
   * Optionally, if force is TRUE, and we did NOT read the directory to provide
   * the result then stat the file anyway and update the internal cache.
   */
  
  PUBLIC time_t
  CacheStat(path, force)
  char        *path;
  int          force;
  {
     struct stat stbuf;
     DirEntryPtr dp;
     EntryPtr    ep;
     uint32 hkey;
     uint16 hv;
     char *fpath;
     char *spath;
     char *comp;
     char *dir;
     int  loaded=FALSE;
+ 
+ #ifdef __APPLE__
+    /* On Mac OS X, open, stat, and other system calls are case-insenstive.
+       Since this function keeps a case-sensitive cache, we need to force
+       a stat of the file if there is no match in the cache just to make sure
+       that we don't miss a file when only the case is different */
+    force = TRUE;
+ #endif
  
     if (If_root_path(path))
        spath = path;
     else
        spath = Build_path(Pwd,path);
  
     fpath = DmStrDup(spath);
     comp  = Basename(fpath);
     dir   = Filedir(fpath);
  
     hv = Hash(dir,&hkey);
  
     for(dp=dtab[hv]; dp; dp=dp->next)
        if (hkey == dp->hkey && strcmp(dp->path,dir) == 0)
  	 break;
  
     if (!dp) {
        DIR *dirp;
        struct dirent *direntp;
  
        if( Verbose & V_DIR_CACHE )
  	 printf( "%s:  Caching directory [%s]\n", Pname, dir  );
  
        /* Load the directory, we have the right hash position already */
        loaded = TRUE;
